"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isClassDeclaration = exports.isIdentifierOrMemberExpression = exports.isMemberExpression = exports.isCallExpression = exports.getReplacementText = exports.getRawText = exports.isImportedFrom = exports.getLifecycleInterfaceByMethodName = exports.getMethodName = exports.getDeclaredMethods = exports.getDecoratorPropertyValue = exports.getDecoratorProperty = exports.getPropertyDefinitionName = exports.isAngularInnerClassDecorator = exports.isAngularClassDecorator = exports.isAngularLifecycleMethod = exports.isAngularLifecycleInterface = exports.ANGULAR_LIFECYCLE_METHODS = exports.ANGULAR_LIFECYCLE_INTERFACES = exports.getDecoratorName = exports.getDecoratorArgument = exports.getAngularClassDecorator = exports.getDecorator = exports.getClassName = exports.getNearestNodeFrom = exports.getDeclaredAngularLifecycleMethods = exports.getDeclaredAngularLifecycleInterfaces = exports.getDeclaredInterfaceNames = exports.getInterfaces = exports.getPipeDecorator = exports.getInterfaceName = exports.getInterface = exports.getImportDeclarationSpecifier = exports.getImportDeclarations = exports.getCorrespondentImportClause = exports.ANGULAR_CLASS_DECORATOR_MAPPER = exports.ANGULAR_CLASS_DECORATORS = exports.ANGULAR_INNER_CLASS_DECORATORS = exports.ANGULAR_CLASS_DECORATOR_LIFECYCLE_METHOD_MAPPER = exports.angularLifecycleMethodsOrdered = exports.angularLifecycleMethodKeys = exports.angularLifecycleInterfaceKeys = exports.angularInnerClassDecoratorKeys = exports.angularClassDecoratorKeys = exports.OPTION_STYLE_KEBAB_CASE = exports.OPTION_STYLE_CAMEL_CASE = exports.AngularLifecycleMethods = exports.AngularLifecycleInterfaces = exports.AngularInnerClassDecorators = exports.AngularClassDecorators = void 0;
exports.isImplementsToken = exports.isSuper = exports.isMethodDefinition = exports.isStringLiteral = exports.isImportSpecifier = exports.isImportDeclaration = exports.isTemplateLiteral = exports.isTemplateElement = exports.isLiteral = exports.isProperty = exports.isArrayExpression = exports.isObjectExpression = exports.isImportNamespaceSpecifier = exports.isImportDefaultSpecifier = exports.isPropertyOrMethodDefinition = exports.isPropertyDefinition = void 0;
const utils_1 = require("@typescript-eslint/utils");
const utils_2 = require("../utils");
var AngularClassDecorators;
(function (AngularClassDecorators) {
    AngularClassDecorators["Component"] = "Component";
    AngularClassDecorators["Directive"] = "Directive";
    AngularClassDecorators["Injectable"] = "Injectable";
    AngularClassDecorators["NgModule"] = "NgModule";
    AngularClassDecorators["Pipe"] = "Pipe";
})(AngularClassDecorators || (exports.AngularClassDecorators = AngularClassDecorators = {}));
var AngularConstructorParameterDecorators;
(function (AngularConstructorParameterDecorators) {
    AngularConstructorParameterDecorators["Attribute"] = "Attribute";
    AngularConstructorParameterDecorators["Host"] = "Host";
    AngularConstructorParameterDecorators["Inject"] = "Inject";
    AngularConstructorParameterDecorators["Optional"] = "Optional";
    AngularConstructorParameterDecorators["Self"] = "Self";
    AngularConstructorParameterDecorators["SkipSelf"] = "SkipSelf";
})(AngularConstructorParameterDecorators || (AngularConstructorParameterDecorators = {}));
var AngularMethodDecorators;
(function (AngularMethodDecorators) {
    AngularMethodDecorators["HostListener"] = "HostListener";
})(AngularMethodDecorators || (AngularMethodDecorators = {}));
var AngularPropertyAccessorDecorators;
(function (AngularPropertyAccessorDecorators) {
    AngularPropertyAccessorDecorators["ContentChild"] = "ContentChild";
    AngularPropertyAccessorDecorators["ContentChildren"] = "ContentChildren";
    AngularPropertyAccessorDecorators["HostBinding"] = "HostBinding";
    AngularPropertyAccessorDecorators["Input"] = "Input";
    AngularPropertyAccessorDecorators["Output"] = "Output";
    AngularPropertyAccessorDecorators["ViewChild"] = "ViewChild";
    AngularPropertyAccessorDecorators["ViewChildren"] = "ViewChildren";
})(AngularPropertyAccessorDecorators || (AngularPropertyAccessorDecorators = {}));
exports.AngularInnerClassDecorators = Object.assign(Object.assign(Object.assign({}, AngularConstructorParameterDecorators), AngularMethodDecorators), AngularPropertyAccessorDecorators);
var AngularLifecycleInterfaces;
(function (AngularLifecycleInterfaces) {
    AngularLifecycleInterfaces["AfterContentChecked"] = "AfterContentChecked";
    AngularLifecycleInterfaces["AfterContentInit"] = "AfterContentInit";
    AngularLifecycleInterfaces["AfterViewChecked"] = "AfterViewChecked";
    AngularLifecycleInterfaces["AfterViewInit"] = "AfterViewInit";
    AngularLifecycleInterfaces["DoBootstrap"] = "DoBootstrap";
    AngularLifecycleInterfaces["DoCheck"] = "DoCheck";
    AngularLifecycleInterfaces["OnChanges"] = "OnChanges";
    AngularLifecycleInterfaces["OnDestroy"] = "OnDestroy";
    AngularLifecycleInterfaces["OnInit"] = "OnInit";
})(AngularLifecycleInterfaces || (exports.AngularLifecycleInterfaces = AngularLifecycleInterfaces = {}));
var AngularLifecycleMethods;
(function (AngularLifecycleMethods) {
    AngularLifecycleMethods["ngAfterContentChecked"] = "ngAfterContentChecked";
    AngularLifecycleMethods["ngAfterContentInit"] = "ngAfterContentInit";
    AngularLifecycleMethods["ngAfterViewChecked"] = "ngAfterViewChecked";
    AngularLifecycleMethods["ngAfterViewInit"] = "ngAfterViewInit";
    AngularLifecycleMethods["ngDoBootstrap"] = "ngDoBootstrap";
    AngularLifecycleMethods["ngDoCheck"] = "ngDoCheck";
    AngularLifecycleMethods["ngOnChanges"] = "ngOnChanges";
    AngularLifecycleMethods["ngOnDestroy"] = "ngOnDestroy";
    AngularLifecycleMethods["ngOnInit"] = "ngOnInit";
})(AngularLifecycleMethods || (exports.AngularLifecycleMethods = AngularLifecycleMethods = {}));
exports.OPTION_STYLE_CAMEL_CASE = 'camelCase';
exports.OPTION_STYLE_KEBAB_CASE = 'kebab-case';
exports.angularClassDecoratorKeys = (0, utils_2.objectKeys)(AngularClassDecorators);
exports.angularInnerClassDecoratorKeys = (0, utils_2.objectKeys)(exports.AngularInnerClassDecorators);
exports.angularLifecycleInterfaceKeys = (0, utils_2.objectKeys)(AngularLifecycleInterfaces);
exports.angularLifecycleMethodKeys = (0, utils_2.objectKeys)(AngularLifecycleMethods);
/**
 * See lifecycle event sequence:
 * https://angular.io/guide/lifecycle-hooks#lifecycle-event-sequence
 */
exports.angularLifecycleMethodsOrdered = [
    AngularLifecycleMethods.ngOnChanges,
    AngularLifecycleMethods.ngOnInit,
    AngularLifecycleMethods.ngDoCheck,
    AngularLifecycleMethods.ngAfterContentInit,
    AngularLifecycleMethods.ngAfterContentChecked,
    AngularLifecycleMethods.ngAfterViewInit,
    AngularLifecycleMethods.ngAfterViewChecked,
    AngularLifecycleMethods.ngOnDestroy,
];
exports.ANGULAR_CLASS_DECORATOR_LIFECYCLE_METHOD_MAPPER = new Map([
    [
        AngularClassDecorators.Component,
        new Set([
            AngularLifecycleMethods.ngAfterContentChecked,
            AngularLifecycleMethods.ngAfterContentInit,
            AngularLifecycleMethods.ngAfterViewChecked,
            AngularLifecycleMethods.ngAfterViewInit,
            AngularLifecycleMethods.ngOnChanges,
            AngularLifecycleMethods.ngOnDestroy,
            AngularLifecycleMethods.ngOnInit,
            AngularLifecycleMethods.ngDoCheck,
        ]),
    ],
    [
        AngularClassDecorators.Directive,
        new Set([
            AngularLifecycleMethods.ngAfterContentChecked,
            AngularLifecycleMethods.ngAfterContentInit,
            AngularLifecycleMethods.ngAfterViewChecked,
            AngularLifecycleMethods.ngAfterViewInit,
            AngularLifecycleMethods.ngOnChanges,
            AngularLifecycleMethods.ngOnDestroy,
            AngularLifecycleMethods.ngOnInit,
            AngularLifecycleMethods.ngDoCheck,
        ]),
    ],
    [
        AngularClassDecorators.Injectable,
        new Set([AngularLifecycleMethods.ngOnDestroy]),
    ],
    [
        AngularClassDecorators.NgModule,
        new Set([
            AngularLifecycleMethods.ngDoBootstrap,
        ]),
    ],
    [
        AngularClassDecorators.Pipe,
        new Set([AngularLifecycleMethods.ngOnDestroy]),
    ],
]);
exports.ANGULAR_INNER_CLASS_DECORATORS = new Set(exports.angularInnerClassDecoratorKeys);
exports.ANGULAR_CLASS_DECORATORS = new Set(exports.angularClassDecoratorKeys);
exports.ANGULAR_CLASS_DECORATOR_MAPPER = new Map([
    [AngularClassDecorators.Component, exports.ANGULAR_INNER_CLASS_DECORATORS],
    [AngularClassDecorators.Directive, exports.ANGULAR_INNER_CLASS_DECORATORS],
    [
        AngularClassDecorators.Injectable,
        new Set([
            exports.AngularInnerClassDecorators.Host,
            exports.AngularInnerClassDecorators.Inject,
            exports.AngularInnerClassDecorators.Optional,
            exports.AngularInnerClassDecorators.Self,
            exports.AngularInnerClassDecorators.SkipSelf,
        ]),
    ],
    [
        AngularClassDecorators.NgModule,
        new Set([
            exports.AngularInnerClassDecorators.Host,
            exports.AngularInnerClassDecorators.Inject,
            exports.AngularInnerClassDecorators.Optional,
            exports.AngularInnerClassDecorators.Self,
            exports.AngularInnerClassDecorators.SkipSelf,
        ]),
    ],
    [
        AngularClassDecorators.Pipe,
        new Set([
            exports.AngularInnerClassDecorators.Host,
            exports.AngularInnerClassDecorators.Inject,
            exports.AngularInnerClassDecorators.Optional,
            exports.AngularInnerClassDecorators.Self,
            exports.AngularInnerClassDecorators.SkipSelf,
        ]),
    ],
]);
function getCorrespondentImportClause(importDeclarations, compatibleWithTypeOnlyImport = false) {
    let importClause;
    for (const { importKind, specifiers } of importDeclarations) {
        const lastImportSpecifier = (0, utils_2.getLast)(specifiers);
        if ((!compatibleWithTypeOnlyImport && importKind === 'type') ||
            isImportNamespaceSpecifier(lastImportSpecifier)) {
            continue;
        }
        importClause = lastImportSpecifier;
    }
    return importClause;
}
exports.getCorrespondentImportClause = getCorrespondentImportClause;
function getImportDeclarations(node, moduleName) {
    let parentNode = node;
    while ((parentNode = parentNode.parent)) {
        if (!isProgram(parentNode))
            continue;
        return parentNode.body.filter((node) => isImportDeclaration(node) && node.source.value === moduleName);
    }
    return parentNode;
}
exports.getImportDeclarations = getImportDeclarations;
function getImportDeclarationSpecifier(importDeclarations, importName) {
    for (const importDeclaration of importDeclarations) {
        const importSpecifier = importDeclaration.specifiers.find((importClause) => {
            return (isImportSpecifier(importClause) &&
                importClause.imported.name === importName);
        });
        if (importSpecifier) {
            return { importDeclaration, importSpecifier };
        }
    }
    return undefined;
}
exports.getImportDeclarationSpecifier = getImportDeclarationSpecifier;
function getInterface(node, interfaceName) {
    return getInterfaces(node).find((interfaceMember) => getInterfaceName(interfaceMember) === interfaceName);
}
exports.getInterface = getInterface;
function getInterfaceName(interfaceMember) {
    if (utils_1.ASTUtils.isIdentifier(interfaceMember)) {
        return interfaceMember.name;
    }
    return utils_1.ASTUtils.isIdentifier(interfaceMember.property)
        ? interfaceMember.property.name
        : undefined;
}
exports.getInterfaceName = getInterfaceName;
const getPipeDecorator = (node) => (0, exports.getDecorator)(node, 'Pipe');
exports.getPipeDecorator = getPipeDecorator;
function getInterfaces(node) {
    var _a;
    return ((_a = node.implements) !== null && _a !== void 0 ? _a : [])
        .map(({ expression }) => expression)
        .filter(isIdentifierOrMemberExpression);
}
exports.getInterfaces = getInterfaces;
function getDeclaredInterfaceNames(node) {
    return getInterfaces(node).map(getInterfaceName).filter(utils_2.isNotNullOrUndefined);
}
exports.getDeclaredInterfaceNames = getDeclaredInterfaceNames;
const getDeclaredAngularLifecycleInterfaces = (node) => getDeclaredInterfaceNames(node).filter(exports.isAngularLifecycleInterface);
exports.getDeclaredAngularLifecycleInterfaces = getDeclaredAngularLifecycleInterfaces;
const getDeclaredAngularLifecycleMethods = (node) => (0, exports.getDeclaredMethods)(node)
    .map(exports.getMethodName)
    .filter(utils_2.isNotNullOrUndefined)
    .filter(exports.isAngularLifecycleMethod);
exports.getDeclaredAngularLifecycleMethods = getDeclaredAngularLifecycleMethods;
function getNearestNodeFrom({ parent }, predicate) {
    while (parent && !isProgram(parent)) {
        if (predicate(parent)) {
            return parent;
        }
        parent = parent.parent;
    }
    return null;
}
exports.getNearestNodeFrom = getNearestNodeFrom;
const getClassName = (node) => {
    var _a;
    if (isClassDeclaration(node)) {
        return (_a = node.id) === null || _a === void 0 ? void 0 : _a.name;
    }
    if (node.parent) {
        return (0, exports.getClassName)(node.parent);
    }
    return undefined;
};
exports.getClassName = getClassName;
const getDecorator = (node, decoratorName) => {
    var _a;
    return (_a = node.decorators) === null || _a === void 0 ? void 0 : _a.find((decorator) => (0, exports.getDecoratorName)(decorator) === decoratorName);
};
exports.getDecorator = getDecorator;
const getAngularClassDecorator = ({ decorators, }) => {
    return decorators === null || decorators === void 0 ? void 0 : decorators.map(exports.getDecoratorName).filter(utils_2.isNotNullOrUndefined).find(exports.isAngularClassDecorator);
};
exports.getAngularClassDecorator = getAngularClassDecorator;
const getDecoratorArgument = ({ expression, }) => {
    if (!isCallExpression(expression) || expression.arguments.length === 0) {
        return undefined;
    }
    const [arg] = expression.arguments;
    return isObjectExpression(arg) && arg.properties ? arg : undefined;
};
exports.getDecoratorArgument = getDecoratorArgument;
const getDecoratorName = ({ expression, }) => {
    if (utils_1.ASTUtils.isIdentifier(expression))
        return expression.name;
    return isCallExpression(expression) &&
        utils_1.ASTUtils.isIdentifier(expression.callee)
        ? expression.callee.name
        : undefined;
};
exports.getDecoratorName = getDecoratorName;
exports.ANGULAR_LIFECYCLE_INTERFACES = new Set(exports.angularLifecycleInterfaceKeys);
exports.ANGULAR_LIFECYCLE_METHODS = new Set(exports.angularLifecycleMethodKeys);
const isAngularLifecycleInterface = (value) => exports.ANGULAR_LIFECYCLE_INTERFACES.has(value);
exports.isAngularLifecycleInterface = isAngularLifecycleInterface;
const isAngularLifecycleMethod = (value) => exports.ANGULAR_LIFECYCLE_METHODS.has(value);
exports.isAngularLifecycleMethod = isAngularLifecycleMethod;
const isAngularClassDecorator = (value) => exports.ANGULAR_CLASS_DECORATORS.has(value);
exports.isAngularClassDecorator = isAngularClassDecorator;
const isAngularInnerClassDecorator = (value) => exports.ANGULAR_INNER_CLASS_DECORATORS.has(value);
exports.isAngularInnerClassDecorator = isAngularInnerClassDecorator;
/**
 * `PropertyDefinition` nodes can have different types of `key`s
 *
 * E.g.
 *
 * class Foo {
 *  a // Identifier
 * 'b' // Literal
 *  ['c'] // Literal
 * }
 */
function getPropertyDefinitionName({ computed, key, }) {
    if (utils_1.ASTUtils.isIdentifier(key) && !computed) {
        return key.name;
    }
    if (isLiteral(key)) {
        return key.raw;
    }
    throw new Error(`Unexpected "PropertyDefinition.key.type" provided: ${key.type}`);
}
exports.getPropertyDefinitionName = getPropertyDefinitionName;
const getDecoratorProperty = (decorator, name) => {
    var _a;
    return (_a = (0, exports.getDecoratorArgument)(decorator)) === null || _a === void 0 ? void 0 : _a.properties.filter(isProperty).find(({ key }) => utils_1.ASTUtils.isIdentifier(key) && key.name === name);
};
exports.getDecoratorProperty = getDecoratorProperty;
const getDecoratorPropertyValue = (decorator, name) => {
    var _a;
    return (_a = (0, exports.getDecoratorProperty)(decorator, name)) === null || _a === void 0 ? void 0 : _a.value;
};
exports.getDecoratorPropertyValue = getDecoratorPropertyValue;
const getDeclaredMethods = ({ body: { body }, }) => {
    return body.filter(isMethodDefinition);
};
exports.getDeclaredMethods = getDeclaredMethods;
const getMethodName = ({ computed, key, }) => {
    if (isStringLiteral(key)) {
        return key.value;
    }
    return utils_1.ASTUtils.isIdentifier(key) && !computed ? key.name : undefined;
};
exports.getMethodName = getMethodName;
const getLifecycleInterfaceByMethodName = (methodName) => methodName.slice(2);
exports.getLifecycleInterfaceByMethodName = getLifecycleInterfaceByMethodName;
function isImportedFrom(identifier, moduleName) {
    const importDeclarations = getImportDeclarations(identifier, moduleName);
    return Boolean(importDeclarations === null || importDeclarations === void 0 ? void 0 : importDeclarations.some((importDeclaration) => importDeclaration.specifiers.some((specifier) => isImportSpecifier(specifier) &&
        specifier.imported.name === identifier.name &&
        specifier.local.name === identifier.name)));
}
exports.isImportedFrom = isImportedFrom;
function getRawText(node) {
    if (utils_1.ASTUtils.isIdentifier(node)) {
        return node.name;
    }
    if (isPropertyDefinition(node) ||
        isMethodDefinition(node) ||
        isProperty(node)) {
        return getRawText(node.key);
    }
    if (isLiteral(node)) {
        return String(node.value);
    }
    if (isTemplateElement(node)) {
        return node.value.raw;
    }
    if (isTemplateLiteral(node)) {
        return node.quasis[0].value.raw;
    }
    throw Error(`Unexpected \`node.type\` provided: ${node.type}`);
}
exports.getRawText = getRawText;
function getReplacementText(node, text) {
    return isLiteral(node) ? `'${text}'` : `\`${text}\``;
}
exports.getReplacementText = getReplacementText;
// SECTION START:
// Equivalents of utils exported by TypeScript itself for its own AST
function isCallExpression(node) {
    return node.type === utils_1.AST_NODE_TYPES.CallExpression;
}
exports.isCallExpression = isCallExpression;
function isMemberExpression(node) {
    return node.type === utils_1.AST_NODE_TYPES.MemberExpression;
}
exports.isMemberExpression = isMemberExpression;
function isIdentifierOrMemberExpression(node) {
    return utils_1.ASTUtils.isIdentifier(node) || isMemberExpression(node);
}
exports.isIdentifierOrMemberExpression = isIdentifierOrMemberExpression;
function isClassDeclaration(node) {
    return node.type === utils_1.AST_NODE_TYPES.ClassDeclaration;
}
exports.isClassDeclaration = isClassDeclaration;
function isPropertyDefinition(node) {
    return node.type === utils_1.AST_NODE_TYPES.PropertyDefinition;
}
exports.isPropertyDefinition = isPropertyDefinition;
function isPropertyOrMethodDefinition(node) {
    return isPropertyDefinition(node) || isMethodDefinition(node);
}
exports.isPropertyOrMethodDefinition = isPropertyOrMethodDefinition;
function isImportDefaultSpecifier(node) {
    return node.type === utils_1.AST_NODE_TYPES.ImportDefaultSpecifier;
}
exports.isImportDefaultSpecifier = isImportDefaultSpecifier;
function isImportNamespaceSpecifier(node) {
    return node.type === utils_1.AST_NODE_TYPES.ImportNamespaceSpecifier;
}
exports.isImportNamespaceSpecifier = isImportNamespaceSpecifier;
function isObjectExpression(node) {
    return node.type === utils_1.AST_NODE_TYPES.ObjectExpression;
}
exports.isObjectExpression = isObjectExpression;
function isArrayExpression(node) {
    return node.type === utils_1.AST_NODE_TYPES.ArrayExpression;
}
exports.isArrayExpression = isArrayExpression;
function isProperty(node) {
    return node.type === utils_1.AST_NODE_TYPES.Property;
}
exports.isProperty = isProperty;
function isProgram(node) {
    return node.type === utils_1.AST_NODE_TYPES.Program;
}
function isLiteral(node) {
    return node.type === utils_1.AST_NODE_TYPES.Literal;
}
exports.isLiteral = isLiteral;
function isTemplateElement(node) {
    return node.type === utils_1.AST_NODE_TYPES.TemplateElement;
}
exports.isTemplateElement = isTemplateElement;
function isTemplateLiteral(node) {
    return node.type === utils_1.AST_NODE_TYPES.TemplateLiteral;
}
exports.isTemplateLiteral = isTemplateLiteral;
function isImportDeclaration(node) {
    return node.type === utils_1.AST_NODE_TYPES.ImportDeclaration;
}
exports.isImportDeclaration = isImportDeclaration;
function isImportSpecifier(node) {
    return node.type === utils_1.AST_NODE_TYPES.ImportSpecifier;
}
exports.isImportSpecifier = isImportSpecifier;
/**
 * `ESTree` does not differentiate between different types of `Literals` at the `AST` level,
 * but it is a common thing to need to do, so this utility are here to
 * avoid repeated `typeof` checks on the node's value.
 */
function isStringLiteral(node) {
    return isLiteral(node) && typeof node.value === 'string';
}
exports.isStringLiteral = isStringLiteral;
function isMethodDefinition(node) {
    return node.type === utils_1.AST_NODE_TYPES.MethodDefinition;
}
exports.isMethodDefinition = isMethodDefinition;
function isSuper(node) {
    return node.type === utils_1.AST_NODE_TYPES.Super;
}
exports.isSuper = isSuper;
function isImplementsToken(token) {
    return token.type === utils_1.AST_TOKEN_TYPES.Keyword && token.value === 'implements';
}
exports.isImplementsToken = isImplementsToken;
// SECTION END:
// Equivalents of utils exported by TypeScript itself for its own AST
