import{_ as t,c as a,ak as s,o}from"./chunks/framework.AfHpRKMk.js";const r="/assets/treemap_results._8X-ZKqQ.png",f=JSON.parse(`{"title":"Searching with Teamscale","description":"An overview of how to search for code or files with Teamscale's search.","frontmatter":{"title":"Searching with Teamscale","description":"An overview of how to search for code or files with Teamscale's search."},"headers":[],"relativePath":"howto/unified-search/index.md","filePath":"howto/unified-search/index.md"}`),d={name:"howto/unified-search/index.md"};function i(c,e,n,h,l,m){return o(),a("div",null,[...e[0]||(e[0]=[s('<h1 id="searching-with-teamscale" tabindex="-1">Searching with Teamscale <a class="header-anchor" href="#searching-with-teamscale" aria-label="Permalink to &quot;Searching with Teamscale&quot;">​</a></h1><p>Teamscale comes with different ways to search for specific code, files, commits or issues. The search view can be opened by typing some search query in the search field in the top right corner of the UI. Additionally, selecting the &quot;Configure Search...&quot; option that appears when clicking into the mentioned field will also navigate to the search view.</p><h2 id="simple-search" tabindex="-1">Simple Search <a class="header-anchor" href="#simple-search" aria-label="Permalink to &quot;Simple Search&quot;">​</a></h2><p>The default mode of Teamscale&#39;s search is the simple search. In this mode, Teamscale takes the entered term from &quot;Query&quot; field, and searches the project(s) for this term. Note that it is possible to restrict the search to a specified project by selecting the target project from the dropdown menu in the top left. In addition, you can also select a path within the project to which the search should be limited in order to receive results for a specified part of the given project.</p><h3 id="results" tabindex="-1">Results <a class="header-anchor" href="#results" aria-label="Permalink to &quot;Results&quot;">​</a></h3><p>After entering a search term and, optionally, a code path, Teamscale searches the (specified) projects for the search term and presents four different result types:</p><table tabindex="0"><thead><tr><th>Type</th><th>Results</th></tr></thead><tbody><tr><td>Files</td><td>Any files whose names contain the search term.</td></tr><tr><td>Code</td><td>Code snippets that contain the search term.</td></tr><tr><td>Commits</td><td>Commits that contain the search term in the commit message</td></tr><tr><td>Issues &amp; Spec Items</td><td>Any issues &amp; spec items (e.g. Jira tickets or test cases) that contain the search term.</td></tr></tbody></table><p>Note that the search could also be configured to search for and present results of only one of these types by selecting the desired type from the dropdown next to the query field:</p><table tabindex="0"><thead><tr><th>Option</th><th>Result</th></tr></thead><tbody><tr><td>Everywhere</td><td>Apply search to files, code, commits, issues, requirements and tests.</td></tr><tr><td>- only files</td><td>Apply search to files only.</td></tr><tr><td>- only code</td><td>Apply search to code only.</td></tr><tr><td>- only commits</td><td>Apply search to commit messages only.</td></tr><tr><td>- only issues &amp; spec items</td><td>Apply search to issues, requirements and tests only.</td></tr><tr><td>Advanced code search</td><td>Apply advanced search to code.</td></tr></tbody></table><h2 id="advanced-code-search" tabindex="-1">Advanced Code Search <a class="header-anchor" href="#advanced-code-search" aria-label="Permalink to &quot;Advanced Code Search&quot;">​</a></h2><p>Teamscale further provides the so-called <strong>advanced code search</strong> that can be used to apply <strong>regex-search</strong> to selected code. Code can be selected like for the simple code search via selection of the desired project and path.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>We also provide a short <a href="https://www.youtube.com/watch?v=nVmjHNFuEoU" target="_blank" rel="noreferrer">demo on YouTube</a>.</p></div><p>To make the advanced code search mode even more powerful than basic regular expression matching, Teamscale additionally provides options to restrict the search. You can define set of <strong>token types</strong>, the code representation on which the search is applied. This way, you can restrict the search to code entities such as comments or literals. Currently, Teamscale supports searching for the following token types:</p><table tabindex="0"><thead><tr><th>Token Type</th><th>Example</th></tr></thead><tbody><tr><td>Literals</td><td>e.g., string literals like <code>&quot;foo&quot;</code> or <code>123</code></td></tr><tr><td>Keywords</td><td>e.g., reserved (language-specific) keywords like <code>private</code></td></tr><tr><td>Identifiers</td><td>e.g., variable names</td></tr><tr><td>Operators</td><td>e.g., <code>+</code>, <code>++</code>, <code>==</code> etc.</td></tr><tr><td>Delimiters</td><td>e.g., parentheses, braces or semicolons</td></tr><tr><td>Comments</td><td>e.g., commented out code or documentation</td></tr><tr><td>Specials</td><td>e.g., special language constructs like pragma directives (<code>#pragma</code> in C++)</td></tr><tr><td>Errors</td><td>e.g., illegal characters</td></tr><tr><td>Whitespaces</td><td>e.g., spaces, tabs and linebreaks</td></tr><tr><td>Synthetics</td><td>Synthetic tokens to represent language specific features, e.g., indents in Python</td></tr></tbody></table><p>Per default, the <code>All</code> option will be selected to include all different types of tokens in the search. However, <em>excluding</em> certain types of tokens from the search might be the more interesting use case for selecting token types, e.g., to exclude comments from a <em>code</em> search. For this, you can simply deselect the non-required tokens in the list. In case of comments, there is also an option &quot;All except comments&quot; that excludes comments from the search.</p><h3 id="results-1" tabindex="-1">Results <a class="header-anchor" href="#results-1" aria-label="Permalink to &quot;Results&quot;">​</a></h3><p>The results of the advanced code search are displayed in two ways: in a treemap indicating the matches in the code base and in a match list below.</p><p><img src="'+r+'" alt="Search Treemap" width="1306" height="855" data-zoom="true"></p><p>The treemap represent the selected code scope with every rectangle representing one specific file with size of a rectangle relating to a file&#39;s included lines of code. The results of the advanced code search are displayed by coloring the different files, with the color intensity referring the count of matches within a file, i.e. the darker the color the more matches Teamscale found in a file. In addition, it is possible to hover the different rectangles to show the match count and concrete file name. It is also possible to directly navigate to the affected file via this perspective.</p><p>Below the match treemap, Teamscale lists the found matches together with the file in which the match was found. Note that a match shows the complete code that was matched with the entered regular expression.</p><h3 id="embedded-flag-expressions" tabindex="-1">Embedded Flag Expressions <a class="header-anchor" href="#embedded-flag-expressions" aria-label="Permalink to &quot;Embedded Flag Expressions&quot;">​</a></h3><p>By default, the advanced code search uses case-sensitive, single line regex matching. However, the search can be configured to use the following modes by adding embedded flag expressions, in this case Java regex modifiers, to the regex:</p><table tabindex="0"><thead><tr><th>Mode</th><th>Description</th></tr></thead><tbody><tr><td>case-insensitive</td><td>By default, regex search is case-sensitive. Case-insensitive matching is enabled via the embedded flag expression <code>(?i)</code>.</td></tr><tr><td>multiline</td><td>By default, multiline mode is disabled. Hence, <code>^</code> and <code>$</code> match at the beginning/end of file. If multiline mode is enabled via the embedded flag expression <code>(?i)</code>, <code>^</code> and <code>$</code> match just after or just before, respectively, a line terminator or the end of the file.</td></tr><tr><td>DOTALL</td><td>By default &quot;.&quot; does not match the line terminator. Embedded flag expression <code>(?s)</code> turns on DOTALL mode where &quot;.&quot; also matches the line terminator.</td></tr></tbody></table>',23)])])}const u=t(d,[["render",i]]);export{f as __pageData,u as default};
