import{_ as a,c as t,ak as n,o}from"./chunks/framework.AfHpRKMk.js";const u=JSON.parse('{"title":"Shadow Instance","description":"","frontmatter":{"title":"Shadow Instance"},"headers":[],"relativePath":"howto/updating-teamscale/shadow-instance/index.md","filePath":"howto/updating-teamscale/shadow-instance/index.md"}'),s={name:"howto/updating-teamscale/shadow-instance/index.md"};function i(r,e,c,l,d,h){return o(),t("div",null,[...e[0]||(e[0]=[n('<h1 id="how-to-set-up-a-shadow-instance" tabindex="-1">How to Set up a Shadow Instance <a class="header-anchor" href="#how-to-set-up-a-shadow-instance" aria-label="Permalink to &quot;How to Set up a Shadow Instance&quot;">​</a></h1><p>Re-analyzing a Teamscale project can take some time if you analyze a lot of data (code, findings, coverage, ...). When <a href="./../../updating-teamscale/">updating a Teamscale instance</a> to a new feature version, you have to re-analyze all your projects to take advantage of all new features and bug fixes. On large instances, re-analyzing all projects may take up to several days.</p><p>Therefore, it is inadvisable to just shut down your running Teamscale instance and then start a fresh one, as this will mean a longer downtime where Teamscale cannot be used.</p><p>Instead, we recommend you run two instances in parallel during updates: the production instance and a <em>shadow instance</em>. This allows your users to still access the old version of Teamscale while the new one is still analyzing.</p><p>In the simplest case, you can just set up a <em>shadow instance</em> running on another port on the same server as the production instance (see file <code>config/teamscale.properties</code>). As soon as the new instance has finished re-analyzing the projects, the old instance can be shut down and the port of the new instance can be set to match the old one.</p><p>If you want zero downtime, you can use a tool like NGINX and <a href="./../../configuring-reverse-proxy/#nginx">configure it as a reverse proxy</a>.</p><p>In a <strong>Docker</strong>-based setup, you can use our <a href="https://github.com/cqse/teamscale-docker-deployment/" target="_blank" rel="noreferrer">template GitHub repository</a> to quickly set up a production and shadow instance including a reverse proxy for zero-downtime deployments.</p><h2 id="feature-version-updates-with-a-shadow-instance" tabindex="-1">Feature Version Updates with a Shadow Instance <a class="header-anchor" href="#feature-version-updates-with-a-shadow-instance" aria-label="Permalink to &quot;Feature Version Updates with a Shadow Instance&quot;">​</a></h2><ol><li><p>Perform a <a href="./../../handling-backups/">full backup export</a> of the configuration and external data via the <em>Backup</em> view of the <em>Admin</em> perspective.</p></li><li><p>Create a new shadow instance with the new feature version. Copy the config files from the previous version to the <code>config</code> folder of the newly created instance. Under Windows, do the same for the files in the <code>windows</code> folder. You might need to adjust the configuration if the format changed. This will be described at the download site of Teamscale if required.</p></li><li><p>Now you should have an empty Teamscale instance. Login as <code>admin</code> using the default password <code>admin</code>.</p></li><li><p>Import the backup ZIP file into this instance via the <em>Backup</em> view of the <em>Admin</em> perspective.</p></li><li><p>If you were using the default settings during backup import, the instance will now be in <a href="./../../../reference/admin-settings/server-settings/#shadow-mode">Shadow Mode</a> which means that no external events, such as notification emails or voting to other systems will happen.</p></li><li><p>You may have to delete the default administrative user (<code>admin</code>) after importing the backup as it is always created when starting Teamscale on an empty storage directory.</p></li><li><p>Wait for the analysis to complete.</p></li><li><p><em>Optional</em>: Before switching from the old production instance to the shadow instance, we recommend you perform a short instance comparison to compare the analysis results of the two instances and check for unexpected changes or inconsistencies. For this, create a new instance comparison in the shadow instance under <em>Admin</em> &gt; <em>Instance Comparison</em>.</p></li></ol><p>During the time it took Teamscale to reanalyze all projects, users might have changed dashboards, their settings, issue queries, etc. Furthermore, external analysis data (coverage, build results, external findings, …) might have been uploaded to the old production instance. We don’t want to lose all these changes when we switch over to the new Teamscale version. So before the switch we have to transfer this delta in Teamscale’s data over to the shadow instance, but without reanalyzing all projects.</p><ol start="9"><li><p>To switch the two instances, first enable Shadow Mode in the production instance.</p></li><li><p>Export a full backup of the old production instance again.</p></li><li><p>Import this backup into the shadow instance but check the backup import option called <em>Skip new projects and only update global data and data of existing projects (except project configuration)</em>.</p></li></ol><p>The effects of this are:</p><ul><li>All global data in the new production instance is updated to match the old production instance (i.e. users, dashboards, account settings, …).</li><li>external analysis data and settings of each project are updated to match the old production instance (e.g. issue queries, finding tolerations, …).</li><li>The projects are not reanalyzed.</li></ul><ol start="12"><li><p>After the backup was imported successfully, perform the switch of the instances in your reverse proxy right away (you don’t have to wait for any further analysis work to complete). Thus, the users see no interruption in their normal usage of Teamscale and keep all their data.</p></li><li><p>Disable the Shadow Mode in the staging instance now to make Teamscale send notifications and votes again.</p></li></ol>',14)])])}const m=a(s,[["render",i]]);export{u as __pageData,m as default};
