import{_ as h,c,ak as r,O as i,z as o,b as e,x as t,L as l,o as p}from"./chunks/framework.AfHpRKMk.js";const T=JSON.parse('{"title":"Teamscale Java Profiler","description":"","frontmatter":{"pageClass":"wider-content"},"headers":[],"relativePath":"reference/coverage-profilers/teamscale-java-profiler/index.md","filePath":"reference/coverage-profilers/teamscale-java-profiler/index.md"}'),u={name:"reference/coverage-profilers/teamscale-java-profiler/index.md"},g={id:"via-installer",tabindex:"-1"};function f(m,a,k,y,E,v){const s=l("PluginTabsTab"),n=l("PluginTabs"),d=l("Badge");return p(),c("div",null,[a[8]||(a[8]=r('<h1 id="teamscale-java-profiler" tabindex="-1">Teamscale Java Profiler <a class="header-anchor" href="#teamscale-java-profiler" aria-label="Permalink to &quot;Teamscale Java Profiler&quot;">​</a></h1><p>The <a href="https://github.com/cqse/teamscale-jacoco-agent" target="_blank" rel="noreferrer">Teamscale Java Profiler</a> records coverage in a JVM process and uploads it to Teamscale at regular intervals. This simplifies profiling of tests in long-running environments, such as deployments running in an application server, Kubernetes cluster, as well as <a href="./../../../howto/setting-up-profiler-tga/manual-tests/#recording-test-coverage-for-manual-tests/">manual tests</a>. In addition, it offers the following advantages:</p><ul><li>configuration managed in Teamscale</li><li>ability to record <a href="./../../../glossary/#testwise-coverage">testwise coverage</a></li><li>directly uploads coverage to Teamscale</li><li>centralized monitoring of <a href="./../../../reference/ui/project/coverage-profilers/">running profilers</a> in Teamscale</li></ul><p>This page serves to give a broad overview of the Teamscale Java Profiler and its options. If you want to set up Test Gap Analysis (TGA) or Test Impact Analysis (TIA), please have a look at our tutorials (<a href="./../../../tutorial/setting-up-tga-java/">TGA</a>/<a href="./../../../tutorial/tia-java/">TIA</a>) and <a href="./../../../howto/setting-up-profiler-tga/java/">how-to pages</a> pages.</p><hr><nav class="table-of-contents"><ul><li><a href="#prerequisites">Prerequisites</a><ul><li><a href="#memory">Memory</a></li><li><a href="#commit-info">Commit Info</a></li></ul></li><li><a href="#download-installation">Download &amp; Installation</a><ul><li><a href="#installation">Installation</a></li></ul></li><li><a href="#options">Options</a><ul><li><a href="#configuration-options">Configuration Options</a></li><li><a href="#advanced-options">Advanced Options</a></li><li><a href="#path-format">Path format</a></li><li><a href="#teamscale-specific-proxy-options">Teamscale-Specific Proxy Options</a></li><li><a href="#file-storage-upload">File Storage Upload</a></li></ul></li><li><a href="#testwise-coverage-recording">Testwise Coverage Recording</a></li><li><a href="#docker-kubernetes">Docker &amp; Kubernetes</a></li><li><a href="#troubleshooting">Troubleshooting</a></li></ul></nav><h2 id="prerequisites" tabindex="-1">Prerequisites <a class="header-anchor" href="#prerequisites" aria-label="Permalink to &quot;Prerequisites&quot;">​</a></h2><h3 id="memory" tabindex="-1">Memory <a class="header-anchor" href="#memory" aria-label="Permalink to &quot;Memory&quot;">​</a></h3><p>The profiler needs a small amount of additional memory to store coverage data. If your JVM is configured to only use very little memory, you might have to increase this limit in order for the profiler to function properly. How much memory is needed depends on how much code is being analyzed and thus on how you configure the profiler.</p><h3 id="commit-info" tabindex="-1">Commit Info <a class="header-anchor" href="#commit-info" aria-label="Permalink to &quot;Commit Info&quot;">​</a></h3><p>Teamscale always associates coverage reports to a specific code commit as otherwise the reported covered/uncovered lines don&#39;t make sense. So, if you want to set up an automated coverage upload to Teamscale, it is necessary to provide the currently checked out git revision to the profiler.</p><p>To upload the coverage to the correct commit in Teamscale, add a <code>git.properties</code> file to your jar/war. Depending on your environment there are multiple options:</p>',12)),i(n,null,{default:o(()=>[i(s,{label:"Maven"},{default:o(()=>[...a[0]||(a[0]=[e("p",null,"Just add the following plugin to your build:",-1),e("div",{class:"language-xml vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"xml"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    <"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugins"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"		<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugin"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"groupId"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">io.github.git-commit-id</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"groupId"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"artifactId"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">git-commit-id-maven-plugin</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"artifactId"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"version"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">9.0.1</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"version"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"executions"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"execution"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"id"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">get-the-git-infos</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"id"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goals"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"						<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goal"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">revision</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goal"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goals"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"phase"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">initialize</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"phase"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"execution"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"executions"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"configuration"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"generateGitPropertiesFile"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">true</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"generateGitPropertiesFile"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"configuration"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"		</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugin"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    </"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugins"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")])])])],-1)])]),_:1}),i(s,{label:"Gradle"},{default:o(()=>[...a[1]||(a[1]=[e("p",null,[t("You can achieve this by applying the "),e("a",{href:"https://plugins.gradle.org/plugin/com.gorylenko.gradle-git-properties",target:"_blank",rel:"noreferrer"},"gradle-git-properties plugin"),t(", as shown in the following example:")],-1),e("div",{class:"language-groovy vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"groovy"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"plugins {")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    id "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"com.gorylenko.gradle-git-properties"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," version "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"2.4.2"')]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),i(s,{label:"Other"},{default:o(()=>[...a[2]||(a[2]=[e("p",null,[t("In case you are not using Git with Maven or Gradle you can also generate the "),e("code",null,"git.properties"),t(" file in your build. This file needs to contain a "),e("code",null,"git.commit.id"),t(" property corresponding to the respective code revision the current application was built from:")],-1),e("div",{class:"language-properties vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"properties"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.commit.id"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=6f735064d5a125d35a546675ee61a5f4a0f840aa")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# When you intend to upload to Artifactory also add the following")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.branch"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=master")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.commit.time"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=1593781474000")])])])],-1),e("p",null,"The file needs to be packaged into the jar or war file of your application.",-1)])]),_:1})]),_:1}),a[9]||(a[9]=r('<p>You can also <a href="./advanced-setup/#multi-project-upload">upload coverage to multiple Teamscale projects</a>.</p><h2 id="download-installation" tabindex="-1">Download &amp; Installation <a class="header-anchor" href="#download-installation" aria-label="Permalink to &quot;Download &amp; Installation&quot;">​</a></h2><p>You can download the latest version of the Teamscale Java Profiler directly from <a href="https://github.com/cqse/teamscale-jacoco-agent/releases" target="_blank" rel="noreferrer">Github</a> or use our <a href="https://hub.docker.com/r/cqse/teamscale-jacoco-agent/tags/" target="_blank" rel="noreferrer">Docker Distribution</a>.</p><h3 id="installation" tabindex="-1">Installation <a class="header-anchor" href="#installation" aria-label="Permalink to &quot;Installation&quot;">​</a></h3><p>This section describes the basic steps to install the profiler successfully in most environments.</p><div class="tip custom-block"><p class="custom-block-title">Installation - Special Cases</p><p>For additional setup steps (e.g. in case you are using an application server) please have a look at our <a href="./advanced-setup/">advanced setup</a> page.</p></div>',6)),e("h4",g,[a[3]||(a[3]=t("Via Installer ",-1)),i(d,{text:"recommended",type:"tip"}),a[4]||(a[4]=t()),a[5]||(a[5]=e("a",{class:"header-anchor",href:"#via-installer","aria-label":'Permalink to "Via Installer <Badge text="recommended" type="tip"/>"'},"​",-1))]),a[10]||(a[10]=r('<p>Unzip the downloaded zip file into any folder. <strong>All files contained in the zip file are required for the profiler to work.</strong></p><p>Run the following command:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./installer</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> install</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> https://your.teamscale.url</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> your-build-user-name</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> your-access-token</span></span></code></pre></div><p>This will install the profiler to <code>/opt/teamscale-profiler/java</code> and will attach it to all Java applications.</p><p>Then for each application where you currently use the Teamscale Java Profiler:</p><ol><li><a href="./../../../howto/setting-up-profiler-tga/java/#set-up-a-profiler-configuration">Create a profiler configuration within Teamscale</a></li><li>Set the <code>TEAMSCALE_JAVA_PROFILER_CONFIG_ID=my-configuration-id</code> environment variable for the Java process that runs your system under test (e.g., the application server or systemd service).</li><li>Restart the application and verify that the profiler is shown in Teamscale under <a href="./../../ui/project/coverage-profilers/#running-profilers">Running Profilers</a></li><li>Perform some actions in the system under test and shut it down</li><li>Verify that new coverage was uploaded to Teamscale, which can be checked in the <a href="./../../ui/project/project/#external-uploads">External Uploads View</a></li></ol><h4 id="manual-installation" tabindex="-1">Manual installation <a class="header-anchor" href="#manual-installation" aria-label="Permalink to &quot;Manual installation&quot;">​</a></h4><p>If using our recommended installer is not possible, e.g. because you don&#39;t have the permission to run it on the target system, you can configure the profiler on your application&#39;s JVM directly by adding the following JVM parameter:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">    -javaagent:path/to/teamscale-jacoco-agent.jar</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">=OPTIONS</span></span></code></pre></div><p>Where</p><ul><li><code>path/to/teamscale-jacoco-agent.jar</code> is the path to the Jar file of the Teamscale Java Profiler (inside the <code>lib</code> folder of the downloaded zip)</li><li><code>OPTIONS</code> are one or more comma-separated options for the profiler in the format <code>key1=value1,key2=value2</code> and so on.</li></ul><p>Example:</p><div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-javaagent:path/to/teamscale-jacoco-agent.jar</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">=config-id=Config_Name,teamscale-server-url=https://localhost:8080,teamscale-user=user,teamscale-access-token=123456token</span></span></code></pre></div><div class="danger custom-block"><p class="custom-block-title">The Order of the Command-Line Arguments Matters</p><p>The <code>-javaagent</code> option <strong>must</strong> be specified <strong>before</strong> the <code>-jar</code> option!</p></div><h2 id="options" tabindex="-1">Options <a class="header-anchor" href="#options" aria-label="Permalink to &quot;Options&quot;">​</a></h2><h3 id="configuration-options" tabindex="-1">Configuration Options <a class="header-anchor" href="#configuration-options" aria-label="Permalink to &quot;Configuration Options&quot;">​</a></h3><p>The following options are available for the Teamscale Java Profiler:</p><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>config-id</code></td><td>A profiler configuration ID as defined in Teamscale. This allows to centrally manage the profiler configuration in <a href="./../../ui/project/coverage-profilers/">Teamscale&#39;s UI</a>. Alternatively you can also set the <code>TEAMSCALE_JAVA_PROFILER_CONFIG_ID</code> environment variable to that value.</td></tr><tr><td><code>config-file</code></td><td>A file which contains one or more of the previously named options as <code>key=value</code> entries, separated by line breaks. The file may also contain comments starting with <code>#</code>. Alternatively, you can set the <code>TEAMSCALE_JAVA_PROFILER_CONFIG_FILE</code> environment variable to that value.</td></tr><tr><td><code>includes</code></td><td>Include patterns for classes. Separate multiple patterns with a semicolon. This may speed up the profiled application and reduce the size of the output XML. These patterns are matched against the Java class names. E.g., to match all classes in package <code>com.yourcompany</code> and <code>com.yourotherpackage</code> and all their subpackages you can use <code>*com.yourcompany.*;*com.yourotherpackage.*</code>. (the initial star before each package name is a precaution in case your classes are nested inside e.g. a <code>src</code> folder, which might be interpreted as a part of the package name. We recommend always using this form).Make sure to include <strong>all</strong> relevant application code but no external libraries.</td></tr><tr><td><code>excludes</code></td><td>Exclude patterns for classes. Same syntax as the <code>includes</code> parameter.</td></tr><tr><td><code>mode</code></td><td>Which coverage collection mode to use. Can be either <code>normal</code> or <code>testwise</code>. Default is <code>normal</code>. When using the <code>testwise</code> mode, please have a look at our <a href="./testwise-coverage-recording/">testwise coverage recording page</a>.</td></tr><tr><td><code>debug</code></td><td><code>true</code>, <code>false</code> or a path to which the logs should be written to. Default is <code>false</code>. This option turns on debug mode. The logs will be shown in <a href="./../../ui/project/coverage-profilers/">Teamscale</a> or in the file provided by the path.</td></tr><tr><td><code>interval</code></td><td>The interval in minutes between uploads of the current coverage to Teamscale (Default is 480, i.e. 8 hours). If set to 0 coverage is only dumped at JVM shutdown.</td></tr><tr><td><code>teamscale-server-url</code></td><td>The HTTP(S) URL of the Teamscale instance to which coverage should be uploaded.</td></tr><tr><td><code>teamscale-project</code></td><td>The project alias or ID within Teamscale to which the coverage belongs. If not specified, the <code>teamscale.project</code> property must be specified via the <code>git.properties</code> file in at least one of the profiled JARs/WARs/EARs.</td></tr><tr><td><code>teamscale-user</code></td><td>The username used to authenticate against Teamscale. The user account must have the &quot;Perform External Uploads&quot; permission on the given project.</td></tr><tr><td><code>teamscale-access-token</code></td><td>The <a href="./../../../glossary/#access-key">access key</a> of the user.</td></tr><tr><td><code>teamscale-partition</code></td><td>The <a href="./../../../glossary/#partition">partition within Teamscale</a> to upload coverage to.</td></tr><tr><td><code>teamscale-revision</code></td><td>The source control revision (e.g. SVN revision or Git hash) that has been used to build the system under test. Teamscale uses this to map the coverage to the corresponding source code. For an alternative see <code>git-properties-jar</code>.</td></tr><tr><td><code>teamscale-repository</code></td><td>The repository id in your Teamscale project which Teamscale should use to look up the revision, if given. Not setting this option will lead to a lookup in all repositories in the Teamscale project.</td></tr><tr><td><code>teamscale-commit</code></td><td>The commit (Format: <code>branch:timestamp</code>) which has been used to build the system under test. Teamscale uses this to map the coverage to the corresponding source code. Thus, this must be the exact code commit from the VCS that was deployed. For an alternative see <code>git-properties-jar</code>.</td></tr><tr><td><code>teamscale-message</code></td><td>The commit message shown within Teamscale for the coverage upload. Default is &quot;Agent coverage upload&quot;</td></tr><tr><td><code>validate-ssl</code></td><td>Can be used to disable SSL validation (not recommended). Defaults to true.</td></tr><tr><td><code>http-server-port</code></td><td>The port at which the profiler should start an HTTP server that listens for commands. Have a look at the profilers <a href="./advanced-setup/#rest-api">REST API</a>.</td></tr></tbody></table><h3 id="advanced-options" tabindex="-1">Advanced Options <a class="header-anchor" href="#advanced-options" aria-label="Permalink to &quot;Advanced Options&quot;">​</a></h3><p>In most cases, the above list of options is sufficient, but there are some more options to support niche use-cases:</p><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>out</code></td><td>The path to a writable directory where the generated coverage XML files will be stored (for details, please see the <a href="#path-format">path format section</a>). Defaults to the subdirectory <code>coverage</code> inside the profilers installation directory.</td></tr><tr><td><code>class-dir</code></td><td>The path under which all class files of the profiled application are stored. Normally, this is inferred by the profiler automatically. For some application, profiling performance may improve if you specify it explicitly. May be a directory or a Jar/War/Ear/... file. Separate multiple paths with a semicolon. You may also supply one or more <code>.txt</code> files with classpath entries separated by newlines (for details, please see the <a href="#path-format">path format section</a>).</td></tr><tr><td><code>dump-on-exit</code></td><td>Whether a coverage report should be written on JVM shutdown. Default is <code>true</code>.</td></tr><tr><td><code>duplicates</code></td><td>Defines how JaCoCo handles duplicate class files. This is by default set to <code>WARN</code> to make the initial setup of the tool as easy as possible. However, this should be set to <code>FAIL</code> for productive use if possible. In special cases you can also set it to <code>IGNORE</code> to print no warnings. See the special section on <a href="./troubleshooting/#warning-ignoring-duplicate-non-identical-class-file-for-class">duplicates</a>.</td></tr><tr><td><code>ignore-uncovered-classes</code></td><td>Whether classes without any recorded coverage should be ignored when generating the XML coverage report. Since Teamscale assumes classes not contained in the report to have no coverage at all, this can reduce report sizes for large systems. Default is <code>false</code>.</td></tr><tr><td><code>upload-metadata</code></td><td>Paths to files that should also be included in uploaded zips. Separate multiple paths with a semicolon. You can use this to include useful metadata about the deployed application with the coverage, e.g. its version number.</td></tr><tr><td><code>obfuscate-security-related-outputs</code></td><td>Boolean value determining if security critical information such as access keys are obfuscated when printing them to the console or into the <a href="./troubleshooting/#how-can-i-find-my-log-files-in-case-teamscale-does-not-show-logs">log</a>. Default is <code>true</code>.</td></tr><tr><td><code>teamscale-revision-manifest-jar</code></td><td>As an alternative to <code>git-properties-jar</code> the profiler accepts the repository revision provided in the given jar/war&#39;s <code>META-INF/MANIFEST.MF</code> file. The revision must be supplied as a main attribute called <code>Revision</code> (preferred) or as an attribute called <code>Git_Commit</code>, which belongs to an entry called <code>Git</code>.</td></tr><tr><td><code>teamscale-commit-manifest-jar</code></td><td>As an alternative to <code>git-properties-jar</code> the profiler accepts values supplied via <code>Branch</code> and <code>Timestamp</code> entries in the given jar/war&#39;s <code>META-INF/MANIFEST.MF</code> file. Expects a path as argument.</td></tr><tr><td><code>git-properties-jar</code></td><td>Path to the jar containing a <a href="#commit-info">git.properties</a> file with Commit Infos. If nothing is configured, the profiler automatically searches all loaded Jar/War/Ear/... files for a <code>git.properties</code> file.</td></tr><tr><td><code>search-git-properties-recursively</code></td><td>Specifies whether to search for git.properties files recursively in folders or archive (jar, war, ear, aar) files. Default is <code>true</code>.</td></tr><tr><td><code>git-properties-commit-date-format</code></td><td>The Java data pattern <code>git.commit.time</code> is encoded with in <code>git.properties</code>. Defaults to <code>yyyy-MM-dd&#39;T&#39;HH:mm:ssZ</code></td></tr><tr><td><code>sap-nwdi-applications</code></td><td>Needed when profiling in a SAP NetWeaver Development Infrastructure. It must be a semicolon separated list of applications. Each application is specified as a fully qualified classname (referred to as marker class) and a Teamscale project alias or ID separated by a colon. The marker class must be guaranteed to be executed when the application is running and is unique amongst the other deployed applications. E.g. <code>com.company.app1.Main:app1alias;com.company.app2.Starter:ts-app2-id</code>. The coverage is uploaded to master at the timestamp of the last modification date of the given marker class.</td></tr><tr><td><code>logging-config</code></td><td>Path to a <a href="https://logback.qos.ch/manual/index.html" target="_blank" rel="noreferrer">logback</a> configuration XML file. Use this to change the logging behaviour of the profiler. Some sample configurations are provided with the profiler in the <code>logging</code> folder, e.g. to enable debug logging or log directly to the console (for details, please see the <a href="./troubleshooting/#how-can-i-find-my-log-files-in-case-teamscale-does-not-show-logs">logging config section</a>).</td></tr></tbody></table><h3 id="path-format" tabindex="-1">Path format <a class="header-anchor" href="#path-format" aria-label="Permalink to &quot;Path format&quot;">​</a></h3><p>All paths supplied to the profiler can be absolute or relative to the working directory. Furthermore, paths may contain glob patterns with <code>*</code>, <code>**</code> and <code>?</code>.</p><h3 id="teamscale-specific-proxy-options" tabindex="-1">Teamscale-Specific Proxy Options <a class="header-anchor" href="#teamscale-specific-proxy-options" aria-label="Permalink to &quot;Teamscale-Specific Proxy Options&quot;">​</a></h3><p>The profiler respects the standard JVM system properties <code>http(s).proxyHost/Port</code> if you set those for your application. If the profiler should use different proxy settings than your application, you can also configure a proxy server via the profiler&#39;s options. These options will be prioritized over the JVM proxy settings.</p><p>If no or not all profiler proxy options are provided the profiler will fall back to the system properties of the JVM.</p><p>The following options can be set in the profiler configuration:</p><table tabindex="0"><thead><tr><th>Option</th><th>Description</th></tr></thead><tbody><tr><td><code>proxy-https-host</code>/<code>proxy-http-host</code></td><td>The host name of the proxy server.</td></tr><tr><td><code>proxy-https-port</code>/<code>proxy-http-port</code></td><td>The port of the proxy server.</td></tr><tr><td><code>proxy-https-user</code>/<code>proxy-http-user</code></td><td>The username for the proxy server.</td></tr><tr><td><code>proxy-https-password</code>/<code>proxy-http-password</code></td><td>The password for the proxy user.</td></tr><tr><td><code>proxy-password-file</code></td><td>Path to a file that contains the password for proxy server authentication. This file may only contain the password and nothing else.</td></tr></tbody></table><p>If you don&#39;t want to set these settings inside the configuration of the profiler, you can also set special proxy JVM properties when starting your profiled application. These properties are identical to the JVM proxy flags with the addition of the <code>teamscale.</code> prefix. For example <code>-Dteamscale.https.proxyHost</code>. The result is the same as using the proxy-options in the configuration.</p><h3 id="file-storage-upload" tabindex="-1">File Storage Upload <a class="header-anchor" href="#file-storage-upload" aria-label="Permalink to &quot;File Storage Upload&quot;">​</a></h3><p>In case the Java Profiler is unable to directly upload coverage to Teamscale, you can also upload it to your file storage solution.</p>',31)),i(n,{sharedStateKey:"file_storage"},{default:o(()=>[i(s,{label:"Artifactory"},{default:o(()=>[...a[6]||(a[6]=[e("p",null,"In order to upload your coverage to Artifactory, the following options are available:",-1),e("table",{tabindex:"0"},[e("thead",null,[e("tr",null,[e("th",null,"Option"),e("th",null,"Description")])]),e("tbody",null,[e("tr",null,[e("td",null,[e("code",null,"artifactory-url")]),e("td",null,[t("the HTTP(S) url of the artifactory server to upload the reports to. The URL may include a subpath on the artifactory server, e.g. "),e("code",null,"https://artifactory.example.com/my-repo/my/subpath"),t(".")])]),e("tr",null,[e("td",null,[e("code",null,"artifactory-partition")]),e("td",null,"The partition name that is parsed later on via Teamscale Artifactory connector options.")]),e("tr",null,[e("td",null,[e("code",null,"artifactory-user")]),e("td",null,"The name of an artifactory user with write access.")]),e("tr",null,[e("td",null,[e("code",null,"artifactory-password")]),e("td",null,"The password of the artifactory user.")]),e("tr",null,[e("td",null,[e("code",null,"artifactory-api-key")]),e("td",null,[t("(alternative to "),e("code",null,"artifactory-user"),t(" and "),e("code",null,"artifactory-password"),t(") The "),e("a",{href:"https://www.jfrog.com/confluence/display/JFROG/User+Profile#UserProfile-APIKey",target:"_blank",rel:"noreferrer"},"API key"),t(" for artifactory from a user with write access.")])]),e("tr",null,[e("td",null,[e("code",null,"artifactory-path-suffix")]),e("td",null,"The path within the storage location between the default path and the uploaded artifact.")])])],-1),e("h5",{id:"the-standard-upload-schema",tabindex:"-1"},[t("The standard upload schema "),e("a",{class:"header-anchor",href:"#the-standard-upload-schema","aria-label":'Permalink to "The standard upload schema"'},"​")],-1),e("p",null,"The artifactory uploads will be organized in a very specific schema, so Teamscale can later find them and process the reports.",-1),e("div",{class:"language- vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"}),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",null,"/ arbitraryly / many / directories / before / the / upload / root")]),t(`
`),e("span",{class:"line"},[e("span",null,"    / 'uploads'")]),t(`
`),e("span",{class:"line"},[e("span",null,"    / <branch name> ")]),t(`
`),e("span",{class:"line"},[e("span",null,"    / <commit timestamp (Java long)>[-<commit hash>]?")]),t(`
`),e("span",{class:"line"},[e("span",null,"    / <upload partition> ")]),t(`
`),e("span",{class:"line"},[e("span",null,"    / <artifact type> ")]),t(`
`),e("span",{class:"line"},[e("span",null,"    / none / or / some / intermediate / directories /")]),t(`
`),e("span",{class:"line"},[e("span",null,"    / <Zip archive file>")])])])],-1),e("p",null,[t("The following options must be set in the "),e("a",{href:"./../../connector-options/#artifactory-connector-options"},"Teamscale Artifactory Connector"),t(" to import reports in Artifactory:")],-1),e("ul",null,[e("li",null,[t("Path Search Pattern: "),e("code",null,"uploads/**"),t(" or "),e("code",null,"**/uploads/**"),t(" when directories before the upload root are present")]),e("li",null,[t("Branch Extraction Pattern: "),e("code",null,"uploads\\/([^/]+)\\/\\d+(?:-[abcdef0-9]+)?\\/[^/]+\\/[^/]+\\/.*")]),e("li",null,[t("Timestamp Extraction Pattern: "),e("code",null,"uploads\\/[^/]+\\/(\\d+)(?:-[abcdef0-9]+)?\\/[^/]+\\/[^/]+\\/.*")]),e("li",null,[t("Timestamp Interpretation: "),e("code",null,"timestamp:millis")]),e("li",null,[t("Prefix Extraction Pattern: "),e("code",null,"uploads\\/[^/]+\\/\\d+(?:-[abcdef0-9]+)?\\/([^/]+\\/[^/]+\\/.*)")]),e("li",null,[t("Partition Pattern (expert option): "),e("code",null,"([^/]+)\\/[^/]+\\/.*")]),e("li",null,[t("Analysis report mapping (expert option): "),e("code",null,"**/jacoco/**->JACOCO")])],-1)])]),_:1}),i(s,{label:"Azure"},{default:o(()=>[...a[7]||(a[7]=[e("p",null,"To upload your coverage to Azure instead of directly to Teamscale, you can use the following options:",-1),e("table",{tabindex:"0"},[e("thead",null,[e("tr",null,[e("th",null,"Option"),e("th",null,"Description")])]),e("tbody",null,[e("tr",null,[e("td",null,[e("code",null,"azure-url")]),e("td",null,[t("HTTPS URL to an azure file storage. Must be in the following format: "),e("code",null,"https://<account>.file.core.windows.net<share>/(<path>)</pre>"),t(". The "),e("code",null,"<path>"),t(" is optional; note, that in the case that the given path does not yet exists at the given share, it will be created.")])]),e("tr",null,[e("td",null,[e("code",null,"azure-key")]),e("td",null,"The access key to the azure file storage. This key is bound to the account, not the share.")])])],-1)])]),_:1})]),_:1}),a[11]||(a[11]=r('<h2 id="testwise-coverage-recording" tabindex="-1">Testwise Coverage Recording <a class="header-anchor" href="#testwise-coverage-recording" aria-label="Permalink to &quot;Testwise Coverage Recording&quot;">​</a></h2><p>You can use the Teamscale Java Profiler to record testwise coverage. For more information on that, please have a look at our <a href="./testwise-coverage-recording/">dedicated subpage</a>.</p><h2 id="docker-kubernetes" tabindex="-1">Docker &amp; Kubernetes <a class="header-anchor" href="#docker-kubernetes" aria-label="Permalink to &quot;Docker &amp; Kubernetes&quot;">​</a></h2><p>Have a look at our how-to guide if you want to set up the profiler for <a href="./../../../howto/setting-up-profiler-tga/java-with-docker/">Docker</a> or <a href="./../../../howto/setting-up-profiler-tga/java-with-kubernetes/">Kubernetes</a></p><h2 id="troubleshooting" tabindex="-1">Troubleshooting <a class="header-anchor" href="#troubleshooting" aria-label="Permalink to &quot;Troubleshooting&quot;">​</a></h2><p>In case you encounter any problems, please have a look at our <a href="./troubleshooting/">Troubleshooting</a> page.</p>',6))])}const w=h(u,[["render",f]]);export{T as __pageData,w as default};
