/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.index.admin.instance_comparison.comparison.EInstanceComparisonSummary;
import com.teamscale.index.admin.instance_comparison.comparison.GlobalComparisonResult;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.ProjectComparisonResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS)
@IndexValueClass
public abstract sealed class InstanceComparisonResultBase
implements Serializable
permits ProjectComparisonResult, GlobalComparisonResult {
    private static final long serialVersionUID = 1L;
    protected static final String CONTRIBUTOR_PROPERTY = "contributor";
    protected static final String ONLY_IN_LOCAL_INSTANCE_PROPERTY = "onlyInLocalInstance";
    protected static final String ONLY_IN_REMOTE_INSTANCE_PROPERTY = "onlyInRemoteInstance";
    protected static final String DIFFS_PROPERTY = "diffs";
    @JsonProperty(value="contributor")
    private final String contributor;
    @JsonProperty(value="onlyInLocalInstance")
    protected final List<InstanceComparisonDiffEntryBase<?>> onlyInLocalInstance;
    @JsonProperty(value="onlyInRemoteInstance")
    protected final List<InstanceComparisonDiffEntryBase<?>> onlyInRemoteInstance;
    @JsonProperty(value="diffs")
    protected final List<InstanceComparisonDiffEntryBase<?>> diffs;

    protected InstanceComparisonResultBase(String contributor, List<InstanceComparisonDiffEntryBase<?>> onlyInLocalInstance, List<InstanceComparisonDiffEntryBase<?>> onlyInRemoteInstance, List<InstanceComparisonDiffEntryBase<?>> diffs) {
        this.contributor = contributor;
        this.onlyInLocalInstance = onlyInLocalInstance;
        this.onlyInRemoteInstance = onlyInRemoteInstance;
        this.diffs = diffs;
    }

    public abstract String getProject();

    public String getContributor() {
        return this.contributor;
    }

    public List<InstanceComparisonDiffEntryBase<?>> getOnlyInLocalInstance() {
        return this.onlyInLocalInstance;
    }

    public List<InstanceComparisonDiffEntryBase<?>> getOnlyInRemoteInstance() {
        return this.onlyInRemoteInstance;
    }

    public List<InstanceComparisonDiffEntryBase<?>> getDiffs() {
        return this.diffs;
    }

    public boolean isEmpty() {
        return this.onlyInLocalInstance.isEmpty() && this.onlyInRemoteInstance.isEmpty() && this.diffs.isEmpty();
    }

    public EInstanceComparisonSummary getSummary() {
        return Stream.of(this.onlyInLocalInstance, this.onlyInRemoteInstance, this.diffs).flatMap(Collection::stream).map(InstanceComparisonDiffEntryBase::getSummary).max(Enum::compareTo).orElse(EInstanceComparisonSummary.NO_DIFFERENCES);
    }
}

