/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionParameterType;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionParameterType;
import com.teamscale.index.admin.instance_comparison.option.IInstanceComparisonAcceptableDeviationsOption;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="instance-comparison-findings", name="Findings", type=EOptionType.SERVER, category=EOptionCategory.INSTANCE_COMPARISON, orderingHint=100)
@IndexValueClass(containedInBackup=true)
public class InstanceComparisonFindingOption
implements IInstanceComparisonAcceptableDeviationsOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "instance-comparison-findings";
    @JsonProperty(value="generalAcceptedDeviation")
    @OptionFieldDescription(name="Accepted Deviation for all Findings", description="How large the deviation of the local findings for each check may be compared to the remote findings count for the check. The specification is in decimal numbers.")
    public double generalAcceptedDeviation = 0.01;
    @JsonProperty(value="acceptedDeviations")
    @OptionFieldDescription(name="Acceptable deviations for a category", description="How large the deviation of the local findings for a specific category may be compared to the remote findings count for the category. The key can be an ANT pattern to match multiple checks. The specification is in decimal numbers.")
    @OptionParameterType(value=EOptionParameterType.PAIRLIST_STRING_NUMERIC)
    public PairList<String, Number> acceptedDeviations = new PairList();

    @Override
    public InstanceComparisonContributionBase.AcceptedComparisonDeviations getAcceptedComparisonDeviations() {
        return new InstanceComparisonContributionBase.AcceptedComparisonDeviations(this.generalAcceptedDeviation, Collections.emptyMap(), this.getAcceptableDeviations());
    }

    private PairList<Pattern, Double> getAcceptableDeviations() {
        return this.acceptedDeviations.map(key -> AntPatternUtils.convertPattern((String)key.trim(), (boolean)false), Number::doubleValue);
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        if (this.generalAcceptedDeviation < 0.0) {
            return "Acceptable deviation must be a number greater than or equal 0";
        }
        String validationResult = this.acceptedDeviations.stream().map(InstanceComparisonFindingOption::validate).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        return StringUtils.isEmpty((String)validationResult) ? null : validationResult;
    }

    private static String validate(Pair<String, Number> pair) {
        String key = (String)pair.getFirst();
        if (StringUtils.isEmpty((String)key)) {
            return "Acceptable deviation key must not be empty.";
        }
        try {
            AntPatternUtils.convertPatternSafe((String)key, (boolean)false);
        }
        catch (ConQATException e) {
            return String.format("Acceptable deviation key \"%s\" must be a valid ANT Pattern.", key);
        }
        if (pair.getSecond() == null || ((Number)pair.getSecond()).doubleValue() <= 0.0) {
            return String.format("Acceptable deviation of \"%s\" must be a number greater than 0.", key);
        }
        return null;
    }
}

