/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionParameterType;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionParameterType;
import com.teamscale.index.admin.instance_comparison.option.IInstanceComparisonAcceptableDeviationsOption;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="instance-comparison-metrics", name="Metrics", type=EOptionType.SERVER, category=EOptionCategory.INSTANCE_COMPARISON, orderingHint=200)
@IndexValueClass(containedInBackup=true)
public class InstanceComparisonMetricOption
implements IInstanceComparisonAcceptableDeviationsOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "instance-comparison-metrics";
    @JsonProperty(value="acceptedDeviations")
    @OptionFieldDescription(name="Acceptable deviations for a metric", description="How large the deviation of the local metric may be compared to the remote metric. The specification is in decimal numbers.")
    @OptionParameterType(value=EOptionParameterType.PAIRLIST_STRING_NUMERIC)
    public PairList<String, Number> acceptedDeviations = PairList.fromPairs((Pair)Pair.createPair((Object)"File Size Assessment", (Object)0.02), (Pair[])new Pair[]{Pair.createPair((Object)"Longest Method Length", (Object)0.02), Pair.createPair((Object)"Method Length Assessment", (Object)0.02), Pair.createPair((Object)"Nesting Depth Assessment", (Object)0.02), Pair.createPair((Object)"Cyclomatic Complexity Assessment", (Object)0.02), Pair.createPair((Object)"Maximum Nesting Depth", (Object)0.02), Pair.createPair((Object)"Maximum Cyclomatic Complexity", (Object)0.02), Pair.createPair((Object)"Clone Coverage", (Object)0.02), Pair.createPair((Object)"Cross Component Clone Coverage", (Object)0.02), Pair.createPair((Object)"Intra Component Clone Coverage", (Object)0.02), Pair.createPair((Object)"Line Coverage", (Object)0.02), Pair.createPair((Object)"Method Coverage", (Object)0.02), Pair.createPair((Object)"MC/DC Coverage", (Object)0.02), Pair.createPair((Object)"Branch Coverage", (Object)0.02), Pair.createPair((Object)"Comment Completeness Assessment", (Object)0.02), Pair.createPair((Object)"Comment Completeness Assessment for Methods", (Object)0.02), Pair.createPair((Object)"Comment Completeness Assessment for Attributes", (Object)0.02), Pair.createPair((Object)"Comment Completeness Assessment for Types", (Object)0.02), Pair.createPair((Object)"Longest Clone", (Object)0.02), Pair.createPair((Object)"Assessment", (Object)0.02), Pair.createPair((Object)"Spec Item Coverage", (Object)0.02), Pair.createPair((Object)"Code Reference Coverage", (Object)0.02)});

    @Override
    public InstanceComparisonContributionBase.AcceptedComparisonDeviations getAcceptedComparisonDeviations() {
        return new InstanceComparisonContributionBase.AcceptedComparisonDeviations(0.0, this.getAcceptableDeviations(), (PairList<Pattern, Double>)PairList.emptyPairList());
    }

    private Map<String, Double> getAcceptableDeviations() {
        return CollectionUtils.map((Map)this.acceptedDeviations.toMap(), String::trim, Number::doubleValue);
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String validationResult = this.acceptedDeviations.stream().map(InstanceComparisonMetricOption::validate).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        return StringUtils.isEmpty((String)validationResult) ? null : validationResult;
    }

    private static String validate(Pair<String, Number> pair) {
        String key = (String)pair.getFirst();
        if (StringUtils.isEmpty((String)key)) {
            return "Acceptable deviation key must not be empty.";
        }
        if (pair.getSecond() == null || ((Number)pair.getSecond()).doubleValue() <= 0.0) {
            return String.format("Acceptable deviation of \"%s\" must be a number greater than 0.", key);
        }
        return null;
    }
}

