/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.index.blacklisting.BranchAgnosticFindingBlacklistIndex;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.EFindingBlacklistUpdateType;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistEventIndex;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.blacklisting.FindingExclusionApprovalOption;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ExcludedExternalFindingProcessor
extends ChangeProcessorAnalysisStep {
    private static final Set<EAnalysisTool> TOOLS_WITHOUT_APPROVAL_WORKFLOW = Set.of(EAnalysisTool.FORTIFY);
    private static final Set<EAnalysisTool> TOOLS_WITH_PRIORITY = Set.of(EAnalysisTool.FORTIFY);
    @DeltaSource(value=TrackedFindingsByIdIndex.class)
    private KeyDelta findingsDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TrackedFindingsByIdIndex trackedFindingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex schemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingBlacklistIndex findingBlacklistIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, skipDeltaCreation=true)
    private BranchAgnosticFindingBlacklistIndex branchAgnosticFindingBlacklistIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingBlacklistEventIndex findingBlacklistEventIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ProjectOptionIndex projectOptionIndex;

    public void execute() throws Exception {
        ExternalFindings findings = this.getExternallyToleratedFindings();
        if (findings.toleratedFindings.isEmpty() && findings.untoleratedFindings.isEmpty() && findings.falsePositiveFindings.isEmpty()) {
            return;
        }
        HashSet<String> allMarkedFindingIds = new HashSet<String>(this.findingBlacklistIndex.getAllFindingIds());
        if (!findings.untoleratedFindings.isEmpty()) {
            this.handleNoLongerMarkedFindings(findings, allMarkedFindingIds);
        }
        if (!findings.toleratedFindings.isEmpty() || !findings.falsePositiveFindings.isEmpty()) {
            this.handleNewlyMarkedFindings(findings, allMarkedFindingIds);
        }
    }

    private void handleNewlyMarkedFindings(ExternalFindings findings, Set<String> allMarkedFindingIds) throws StorageException {
        FindingBlacklistInfosAndEvents dto = this.createBlacklistInfos(findings, allMarkedFindingIds);
        if (dto.events.isEmpty()) {
            return;
        }
        this.findingBlacklistEventIndex.storeEvents(dto.events);
        this.branchAgnosticFindingBlacklistIndex.setIfNewer(dto.infos);
        this.findingBlacklistIndex.setBlacklistInfos(dto.infos);
    }

    private FindingBlacklistInfosAndEvents createBlacklistInfos(ExternalFindings findings, Set<String> allMarkedFindingIds) throws StorageException {
        List<TrackedFinding> newlyFalsePositiveFindings = findings.falsePositiveFindings.stream().filter(f -> !allMarkedFindingIds.contains(f.getId())).toList();
        List<TrackedFinding> newlyToleratedFindings = findings.toleratedFindings.stream().filter(f -> !allMarkedFindingIds.contains(f.getId())).toList();
        List<TrackedFinding> existingFalsePositiveFindings = findings.falsePositiveFindings.stream().filter(f -> allMarkedFindingIds.contains(f.getId())).toList();
        List<TrackedFinding> existingToleratedFindings = findings.toleratedFindings.stream().filter(f -> allMarkedFindingIds.contains(f.getId())).toList();
        ArrayList<TrackedFinding> allFindings = new ArrayList<TrackedFinding>();
        allFindings.addAll(newlyFalsePositiveFindings);
        allFindings.addAll(newlyToleratedFindings);
        allFindings.addAll(existingFalsePositiveFindings);
        allFindings.addAll(existingToleratedFindings);
        CodeScopeAware<Map<String, FindingTypeDescription>> findingTypeDescriptions = this.getFindingTypeDescriptions(allFindings);
        PairList infos = new PairList();
        ArrayList<FindingBlacklistEvent> events = new ArrayList<FindingBlacklistEvent>();
        FindingExclusionApprovalOption approvalOption = FindingExclusionApprovalOption.getInstance(this.projectOptionIndex);
        this.addBlacklistInfosAndEvents(newlyFalsePositiveFindings, EFindingBlacklistType.FALSE_POSITIVE, findingTypeDescriptions, approvalOption, (PairList<String, FindingBlacklistInfo>)infos, events);
        this.addBlacklistInfosAndEvents(newlyToleratedFindings, EFindingBlacklistType.TOLERATION, findingTypeDescriptions, approvalOption, (PairList<String, FindingBlacklistInfo>)infos, events);
        this.addBlacklistInfosAndEventsPreservingApproval(existingFalsePositiveFindings, findingTypeDescriptions, (PairList<String, FindingBlacklistInfo>)infos);
        this.addBlacklistInfosAndEventsPreservingApproval(existingToleratedFindings, findingTypeDescriptions, (PairList<String, FindingBlacklistInfo>)infos);
        return new FindingBlacklistInfosAndEvents((PairList<String, FindingBlacklistInfo>)infos, events);
    }

    private void addBlacklistInfosAndEvents(List<TrackedFinding> findings, EFindingBlacklistType blacklistType, CodeScopeAware<Map<String, FindingTypeDescription>> findingTypeDescriptions, FindingExclusionApprovalOption approvalOption, PairList<String, FindingBlacklistInfo> infos, List<FindingBlacklistEvent> events) throws StorageException {
        for (TrackedFinding finding : findings) {
            FindingBlacklistEvent event;
            EAnalysisTool tool = ExcludedExternalFindingProcessor.getTool(finding, findingTypeDescriptions);
            if (tool.isInternal() || !TOOLS_WITH_PRIORITY.contains(tool) && (event = this.findingBlacklistEventIndex.getEvent(finding.getId())) != null && event.getType() == EFindingBlacklistUpdateType.REMOVE) continue;
            String toolName = tool.getReadableName();
            String rationale = ExcludedExternalFindingProcessor.createRationale(blacklistType, toolName);
            FindingBlacklistInfo.IApprovalState approvalState = this.determineApprovalState(finding, tool, approvalOption, toolName, rationale);
            FindingBlacklistInfo info = new FindingBlacklistInfo(finding.getId(), this.getSchedulingCommit().getTimestamp(), toolName, rationale, blacklistType, approvalState, true);
            infos.add((Object)info.getFindingId(), (Object)info);
            FindingBlacklistEvent event2 = FindingBlacklistEvent.createAddedEvent(info.getFindingId(), info.getRationale(), info.getUser(), finding.getLocation().getUniformPath(), info);
            events.add(event2);
        }
    }

    private void addBlacklistInfosAndEventsPreservingApproval(List<TrackedFinding> findings, CodeScopeAware<Map<String, FindingTypeDescription>> findingTypeDescriptions, PairList<String, FindingBlacklistInfo> infos) throws StorageException {
        if (findings.isEmpty()) {
            return;
        }
        List<String> findingIds = findings.stream().map(TrackedFinding::getId).toList();
        List<FindingBlacklistInfo> existingInfos = this.findingBlacklistIndex.getBlacklistInfos(findingIds);
        Map<String, FindingBlacklistInfo> existingInfoMap = existingInfos.stream().collect(Collectors.toMap(FindingBlacklistInfo::getFindingId, info -> info));
        for (TrackedFinding finding : findings) {
            FindingBlacklistInfo existingInfo;
            EAnalysisTool tool = ExcludedExternalFindingProcessor.getTool(finding, findingTypeDescriptions);
            if (tool.isInternal() || !TOOLS_WITH_PRIORITY.contains(tool) || (existingInfo = existingInfoMap.get(finding.getId())) == null) continue;
            FindingBlacklistInfo info2 = new FindingBlacklistInfo(finding.getId(), existingInfo.getTimestamp(), existingInfo.getUser(), existingInfo.getRationale(), existingInfo.getType(), existingInfo.getApprovalState(), existingInfo.isToleratedExternally());
            infos.add((Object)info2.getFindingId(), (Object)info2);
        }
    }

    private static String createRationale(EFindingBlacklistType blacklistType, String toolName) {
        if (blacklistType == EFindingBlacklistType.FALSE_POSITIVE) {
            return "Marked as False Positive in external tool " + toolName;
        }
        return "Tolerated in external tool " + toolName;
    }

    private FindingBlacklistInfo.IApprovalState determineApprovalState(TrackedFinding finding, EAnalysisTool tool, FindingExclusionApprovalOption approvalOption, String toolName, String rationale) {
        boolean useApprovalWorkflow;
        boolean toolSupportsApprovalWorkflow = !TOOLS_WITHOUT_APPROVAL_WORKFLOW.contains(tool);
        boolean approvalWorkflowConfiguredForFinding = approvalOption.shouldUseApprovalWorkflow(finding);
        boolean bl = useApprovalWorkflow = toolSupportsApprovalWorkflow && approvalWorkflowConfiguredForFinding;
        if (useApprovalWorkflow) {
            return new FindingBlacklistInfo.IApprovalState.Pending();
        }
        return new FindingBlacklistInfo.IApprovalState.Approved(toolName, this.getSchedulingCommit().getTimestamp(), rationale);
    }

    private CodeScopeAware<Map<String, FindingTypeDescription>> getFindingTypeDescriptions(List<TrackedFinding> newlyToleratedFindings) throws StorageException {
        CodeScopeAware typeIdsByCodeScope = CodeScopeAware.empty();
        for (TrackedFinding finding : newlyToleratedFindings) {
            ((Set)typeIdsByCodeScope.getOrComputeValue(finding.getCodeScopeName(), ignored -> new HashSet())).add(finding.getTypeId());
        }
        return this.schemaIndex.getFindingTypeDescriptions(typeIdsByCodeScope);
    }

    private static EAnalysisTool getTool(TrackedFinding finding, CodeScopeAware<Map<String, FindingTypeDescription>> findingTypeDescriptions) {
        return ((FindingTypeDescription)((Map)findingTypeDescriptions.getValue(finding.getCodeScopeName())).get(finding.getTypeId())).getTool();
    }

    private void handleNoLongerMarkedFindings(ExternalFindings findings, Set<String> allMarkedFindingIds) throws StorageException {
        HashSet noLongerToleratedFindingIds = CollectionUtils.intersectionSet(allMarkedFindingIds, (Collection[])new Collection[]{findings.untoleratedFindings.stream().map(TrackedFinding::getId).toList()});
        List<FindingBlacklistInfo> blacklistInfos = this.findingBlacklistIndex.getBlacklistInfos(new ArrayList<String>(noLongerToleratedFindingIds));
        List<FindingBlacklistInfo> infosToRemove = blacklistInfos.stream().filter(FindingBlacklistInfo::isToleratedExternally).toList();
        if (!infosToRemove.isEmpty()) {
            this.findingBlacklistIndex.removeFromBlacklist(infosToRemove.stream().map(FindingBlacklistInfo::getFindingId).toList());
            PairList infos = (PairList)infosToRemove.stream().map(i -> Pair.createPair((Object)i.getFindingId(), (Object)i.getTimestamp())).collect(PairList.toPairList());
            this.branchAgnosticFindingBlacklistIndex.removeIfNewer((PairList<String, Long>)infos);
        }
    }

    private ExternalFindings getExternallyToleratedFindings() throws StorageException {
        HashSet<String> changedFindings = new HashSet<String>(this.findingsDelta.getAddedOrChangedKeysAsStrings());
        changedFindings.addAll(this.findingBlacklistEventIndex.getAllFindingIds());
        List<TrackedFinding> findings = this.trackedFindingsIndex.getFindings(new ArrayList<String>(changedFindings));
        Map<Object, List<TrackedFinding>> findingsByFalsePositiveProperty = findings.stream().filter(Objects::nonNull).filter(f -> f.getProperty("Marked as False Positive externally") != null).collect(Collectors.groupingBy(f -> f.getProperty("Marked as False Positive externally")));
        Map<Object, List<TrackedFinding>> findingsByToleratedProperty = findings.stream().filter(Objects::nonNull).filter(f -> f.getProperty("Tolerated Externally") != null).collect(Collectors.groupingBy(f -> f.getProperty("Tolerated Externally")));
        List<TrackedFinding> trackedFindings = ExcludedExternalFindingProcessor.getFindingsThatShouldBeRemovedFromExclusion(findingsByFalsePositiveProperty, findingsByToleratedProperty);
        return new ExternalFindings(findingsByFalsePositiveProperty.getOrDefault(Boolean.TRUE, (List<TrackedFinding>)CollectionUtils.emptyList()), findingsByToleratedProperty.getOrDefault(Boolean.TRUE, (List<TrackedFinding>)CollectionUtils.emptyList()), trackedFindings);
    }

    private static List<TrackedFinding> getFindingsThatShouldBeRemovedFromExclusion(Map<Object, List<TrackedFinding>> findingsByFalsePositiveProperty, Map<Object, List<TrackedFinding>> findingsByToleratedProperty) {
        List<TrackedFinding> findingsThatAreNotTolerated = findingsByToleratedProperty.getOrDefault(Boolean.FALSE, (List<TrackedFinding>)CollectionUtils.emptyList());
        List<TrackedFinding> findingsThatAreNotFalsePositives = findingsByFalsePositiveProperty.getOrDefault(Boolean.FALSE, (List<TrackedFinding>)CollectionUtils.emptyList());
        return new ArrayList<TrackedFinding>(CollectionUtils.intersectionSet(findingsThatAreNotTolerated, (Collection[])new Collection[]{findingsThatAreNotFalsePositives}));
    }

    private record ExternalFindings(List<TrackedFinding> falsePositiveFindings, List<TrackedFinding> toleratedFindings, List<TrackedFinding> untoleratedFindings) {
    }

    private record FindingBlacklistInfosAndEvents(PairList<String, FindingBlacklistInfo> infos, List<FindingBlacklistEvent> events) {
    }
}

