/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

@Index(name="finding-blacklist-events", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED}, valueClasses={FindingBlacklistEvent.class})
public class FindingBlacklistEventIndex
implements IProjectIndex {
    private final ValueIndex<FindingBlacklistEvent> delegate;

    public FindingBlacklistEventIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void storeEvents(Collection<FindingBlacklistEvent> events) throws StorageException {
        PairList values = (PairList)events.stream().map(e -> new Pair((Object)e.getFindingId(), e)).collect(PairList.toPairList());
        this.delegate.setValues(values);
    }

    public @Nullable FindingBlacklistEvent getEvent(String findingId) throws StorageException {
        return (FindingBlacklistEvent)this.delegate.getValue(findingId);
    }

    public List<String> getAllFindingIds() throws StorageException {
        return this.delegate.getAllKeys();
    }
}

