/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.core;

import com.teamscale.index.code_clones.core.Clone;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

public class CloneClass {
    private final int normalizedLength;
    private final Set<Clone> clones = new LinkedHashSet<Clone>();

    public CloneClass(int normalizedLength) {
        this.normalizedLength = normalizedLength;
    }

    public int getNormalizedLength() {
        return this.normalizedLength;
    }

    public @NonNull Set<Clone> getClones() {
        return CollectionUtils.asUnmodifiable(this.clones);
    }

    public int size() {
        return this.clones.size();
    }

    public void add(@NonNull Clone clone) {
        boolean cloneIsInOtherClass;
        boolean bl = cloneIsInOtherClass = clone.getCloneClass() != this && clone.getCloneClass() != null;
        if (cloneIsInOtherClass) {
            clone.getCloneClass().remove(clone);
        }
        this.clones.add(clone);
        clone.setCloneClass(this);
    }

    public void remove(Clone clone) {
        if (this.clones.remove(clone)) {
            clone.setCloneClass(null);
        }
    }

    public String toString() {
        return "CloneClass{normalizedLength=" + this.normalizedLength + ", clones=" + String.valueOf(this.clones) + "}";
    }

    public boolean isValidIntraComponentClass() {
        Set components = this.clones.stream().map(Clone::getComponent).collect(Collectors.toSet());
        return components.size() == 1 && !components.contains(null);
    }
}

