/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.suffixtree;

import com.teamscale.index.code_clones.suffixtree.SuffixTreeHashTable;
import java.util.List;

public class SuffixTree {
    protected final int INFTY;
    protected final List<?> word;
    protected int numNodes = 0;
    protected final int[] nodeWordBegin;
    protected final int[] nodeWordEnd;
    protected final int[] suffixLink;
    protected final SuffixTreeHashTable nextNode;
    protected int[] nodeChildFirst;
    protected int[] nodeChildNext;
    protected int[] nodeChildNode;
    private int currentNode = 0;
    private int refWordBegin = 0;
    private int explicitNode;

    public SuffixTree(List<?> word) {
        int size;
        this.word = word;
        this.INFTY = size = word.size();
        int expectedNodes = 2 * size;
        this.nodeWordBegin = new int[expectedNodes];
        this.nodeWordEnd = new int[expectedNodes];
        this.suffixLink = new int[expectedNodes];
        this.nextNode = new SuffixTreeHashTable(expectedNodes);
        this.createRootNode();
        for (int i = 0; i < size; ++i) {
            this.update(i);
            this.canonize(i + 1);
        }
    }

    private void createRootNode() {
        this.numNodes = 1;
        this.nodeWordBegin[0] = 0;
        this.nodeWordEnd[0] = 0;
        this.suffixLink[0] = -1;
    }

    private void update(int charPos) {
        int lastNode = 0;
        while (!this.testAndSplit(charPos, this.word.get(charPos))) {
            int newNode;
            ++this.numNodes;
            this.nodeWordBegin[newNode] = charPos;
            this.nodeWordEnd[newNode] = this.INFTY;
            this.nextNode.put(this.explicitNode, this.word.get(charPos), newNode);
            if (lastNode != 0) {
                this.suffixLink[lastNode] = this.explicitNode;
            }
            lastNode = this.explicitNode;
            this.currentNode = this.suffixLink[this.currentNode];
            this.canonize(charPos);
        }
        if (lastNode != 0) {
            this.suffixLink[lastNode] = this.currentNode;
        }
    }

    private boolean testAndSplit(int refWordEnd, Object nextCharacter) {
        if (this.currentNode < 0) {
            return true;
        }
        if (refWordEnd <= this.refWordBegin) {
            if (this.nextNode.get(this.currentNode, nextCharacter) < 0) {
                this.explicitNode = this.currentNode;
                return false;
            }
            return true;
        }
        int next = this.nextNode.get(this.currentNode, this.word.get(this.refWordBegin));
        if (nextCharacter.equals(this.word.get(this.nodeWordBegin[next] + refWordEnd - this.refWordBegin))) {
            return true;
        }
        this.explicitNode = this.numNodes++;
        this.nodeWordBegin[this.explicitNode] = this.nodeWordBegin[next];
        this.nodeWordEnd[this.explicitNode] = this.nodeWordBegin[next] + refWordEnd - this.refWordBegin;
        this.nextNode.put(this.currentNode, this.word.get(this.refWordBegin), this.explicitNode);
        int n = next;
        this.nodeWordBegin[n] = this.nodeWordBegin[n] + (refWordEnd - this.refWordBegin);
        this.nextNode.put(this.explicitNode, this.word.get(this.nodeWordBegin[next]), next);
        return false;
    }

    private void canonize(int refWordEnd) {
        if (this.currentNode == -1) {
            this.currentNode = 0;
            ++this.refWordBegin;
        }
        if (refWordEnd <= this.refWordBegin) {
            return;
        }
        int next = this.nextNode.get(this.currentNode, this.word.get(this.refWordBegin));
        while (this.nodeWordEnd[next] - this.nodeWordBegin[next] <= refWordEnd - this.refWordBegin) {
            this.refWordBegin += this.nodeWordEnd[next] - this.nodeWordBegin[next];
            this.currentNode = next;
            if (refWordEnd <= this.refWordBegin) break;
            next = this.nextNode.get(this.currentNode, this.word.get(this.refWordBegin));
        }
    }

    protected void ensureChildLists() {
        if (this.nodeChildFirst == null || this.nodeChildFirst.length < this.numNodes) {
            this.nodeChildFirst = new int[this.numNodes];
            this.nodeChildNext = new int[this.numNodes];
            this.nodeChildNode = new int[this.numNodes];
            this.nextNode.extractChildLists(this.nodeChildFirst, this.nodeChildNext, this.nodeChildNode);
        }
    }

    protected void _dumpDebugInfos() {
        System.err.println("Number of nodes created: " + this.numNodes);
        System.err.println("Hash table infos: ");
        this.nextNode._printDebugInfo();
    }

    protected String _dumpAsDOT(String separationChar, boolean includeSuffixLinks) {
        int i;
        this.ensureChildLists();
        StringBuilder sb = new StringBuilder();
        sb.append("digraph G {\n");
        for (i = 0; i < this.numNodes; ++i) {
            sb.append("  n" + i + ";\n");
        }
        for (i = 0; i < this.numNodes; ++i) {
            int e = this.nodeChildFirst[i];
            while (e >= 0) {
                sb.append("  n" + i + " -> n" + this.nodeChildNode[e] + " [label=\"");
                String sep = "";
                for (int j = this.nodeWordBegin[this.nodeChildNode[e]]; j < this.nodeWordEnd[this.nodeChildNode[e]]; ++j) {
                    sb.append(sep);
                    sb.append(this.word.get(j).toString());
                    sep = separationChar;
                }
                sb.append("\"];\n");
                e = this.nodeChildNext[e];
            }
        }
        if (includeSuffixLinks) {
            for (i = 1; i < this.numNodes; ++i) {
                if (this.nodeChildFirst[i] < 0) continue;
                sb.append("  n" + i + " -> n" + this.suffixLink[i] + " [color=red,constraint=false];\n");
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public boolean containsWord(List<?> find) {
        int node = 0;
        int findSize = find.size();
        int i = 0;
        while (i < findSize) {
            int next = this.nextNode.get(node, find.get(i));
            if (next < 0) {
                return false;
            }
            for (int j = this.nodeWordBegin[next]; j < this.nodeWordEnd[next] && i < findSize; ++i, ++j) {
                if (this.word.get(j).equals(find.get(i))) continue;
                return false;
            }
            node = next;
        }
        return true;
    }

    public static class Sentinel {
        private final int hash = (int)(Math.random() * 2.147483647E9);

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return "$";
        }
    }
}

