/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_ownership;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.code_ownership.CodeOwnershipData;
import com.teamscale.index.code_ownership.CodeOwnershipIndex;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileHistoryEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogFileUtils;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CodeOwnershipSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CommitDescriptorIndex commitDescriptorIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ElementHistoryIndex historyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryLogIndex repositoryLogIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryLogFileIndex repositoryLogFileIndex;
    @DeltaSource(value=RepositoryLogFileIndex.class)
    private KeyDelta unusedDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CodeOwnershipIndex currentOwnershipIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private CodeOwnershipIndex oldOwnershipIndex;

    public void execute() throws StorageException {
        RepositoryLogEntryAggregate logEntry = Objects.requireNonNull((RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(this.getSchedulingCommit()));
        if (!logEntry.getCommitTypes().contains((Object)ECommitType.CODE_COMMIT)) {
            return;
        }
        List<RepositoryLogFileEntry> entries = this.repositoryLogFileIndex.getEntriesByCommitAndEntryTypes(this.getSchedulingCommit(), EnumSet.of(UniformPath.EType.CODE, UniformPath.EType.ARCHITECTURE));
        List<RepositoryLogFileHistoryEntry> augmentedRepositoryLogFiles = RepositoryLogFileUtils.augmentWithHistoryInformation(entries, this.historyIndex);
        boolean isMergeCommit = this.isScheduledForMergeCommit();
        ArrayList<String> pathsToDelete = new ArrayList<String>();
        PairList updatedValues = new PairList();
        ArrayList<RepositoryLogFileHistoryEntry> movedOrCopiedEntries = new ArrayList<RepositoryLogFileHistoryEntry>();
        for (RepositoryLogFileHistoryEntry entry : augmentedRepositoryLogFiles) {
            switch (entry.getChangeType()) {
                case ADD: 
                case EDIT: {
                    updatedValues.add((Object)entry.getUniformPath().toStringAsMigrationFrontier(), (Object)CodeOwnershipSynchronizer.handleAddedOrEditedFile(logEntry, isMergeCommit));
                    break;
                }
                case MOVE: {
                    pathsToDelete.add(entry.getOriginPath());
                    movedOrCopiedEntries.add(entry);
                    break;
                }
                case COPY: {
                    movedOrCopiedEntries.add(entry);
                    break;
                }
                case DELETE: {
                    pathsToDelete.add(entry.getUniformPath().toStringAsMigrationFrontier());
                }
            }
        }
        updatedValues.addAll(this.collectOwnerShipsForCopiedOrMovedFiles(movedOrCopiedEntries, logEntry, isMergeCommit));
        this.currentOwnershipIndex.removeCodeOwnershipData(pathsToDelete);
        this.currentOwnershipIndex.addCodeOwnershipData((PairList<String, CodeOwnershipData>)updatedValues, CodeOwnershipData::merge);
    }

    private boolean isScheduledForMergeCommit() throws StorageException {
        ParentedCommitDescriptor commit = this.commitDescriptorIndex.getCommit(this.getSchedulingCommit());
        return commit != null && commit.isMergeCommit();
    }

    private static CodeOwnershipData handleAddedOrEditedFile(RepositoryLogEntryAggregate logEntry, boolean isMergeCommit) {
        return CodeOwnershipData.fromAuthor(logEntry.getAuthor(), logEntry.getTimestamp(), isMergeCommit);
    }

    private PairList<String, CodeOwnershipData> collectOwnerShipsForCopiedOrMovedFiles(List<RepositoryLogFileHistoryEntry> movedEntries, RepositoryLogEntryAggregate logEntry, boolean isMergeCommit) throws StorageException {
        PairList uniformPathsAndOwnership = new PairList();
        List originPaths = CollectionUtils.map(movedEntries, ElementHistoryEntry::getOriginPath);
        List<CodeOwnershipData> ownershipDataForOrigin = this.oldOwnershipIndex.getCodeOwnershipData(originPaths);
        CodeOwnershipData ownershipDataForCurrentCommit = CodeOwnershipData.fromAuthor(logEntry.getAuthor(), logEntry.getTimestamp(), isMergeCommit);
        for (int i = 0; i < ownershipDataForOrigin.size(); ++i) {
            CodeOwnershipData codeOwnershipData = ownershipDataForOrigin.get(i);
            String uniformPath = movedEntries.get(i).getUniformPath().toStringAsMigrationFrontier();
            if (codeOwnershipData == null) {
                uniformPathsAndOwnership.add((Object)uniformPath, (Object)CodeOwnershipSynchronizer.handleAddedOrEditedFile(logEntry, isMergeCommit));
                continue;
            }
            uniformPathsAndOwnership.add((Object)uniformPath, (Object)CodeOwnershipData.merge(codeOwnershipData, ownershipDataForCurrentCommit));
        }
        return uniformPathsAndOwnership;
    }
}

