/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.ECommentCategory;
import com.teamscale.index.comment_analysis.classification.ICommentClassifier;
import java.util.HashMap;
import java.util.Map;

public class CommentClassificationCache {
    private final Map<Long, ECommentCategory> cache = new HashMap<Long, ECommentCategory>();

    public ECommentCategory classifyComment(ICommentClassifier classifier, Comment comment) {
        long hash = CommentClassificationCache.hashComment(comment);
        ECommentCategory cachedClassification = this.cache.get(hash);
        if (cachedClassification != null) {
            return cachedClassification;
        }
        ECommentCategory classification = classifier.getClassification(comment);
        this.cache.put(hash, classification);
        return classification;
    }

    private static long hashComment(Comment comment) {
        return XXHashUtils.xxhash64((String)(comment.getLanguage().toString() + "-" + comment.getElementUniformPath() + "-" + comment.getRawCommentText()));
    }
}

