/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentClassificationAnalysisBase;
import com.teamscale.index.comment_analysis.CommentClassificationCache;
import com.teamscale.index.comment_analysis.ECommentCategory;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class CommentMetricAnalysis
extends CommentClassificationAnalysisBase {
    public static final String COMMENT_CHARACTER_COUNT_RATIO = "comment-chars";
    public static final String COMMENT_CHARACTER_COUNT_TYPE = "comment-chars-type";
    public static final String CODE_COUNT = "code-chars";
    public static final String COPYRIGHT_COUNT = "comment-copyright-chars";
    public static final String HEADER_COUNT = "comment-header-chars";
    public static final String INTERFACE_COUNT = "comment-interface-chars";
    public static final String INLINE_COUNT = "comment-inline-chars";
    public static final String SECTION_COUNT = "comment-section-chars";
    public static final String TASK_COUNT = "comment-task-chars";
    public static final String COMMENTED_OUT_CODE_COUNT = "commented-code-chars";
    private CounterSet<ECommentCategory> commentDistribution;
    private int commentCharacterCount;
    private final Map<String, PairList<String, Serializable>> metricValues = new HashMap<String, PairList<String, Serializable>>();
    private final boolean commentTypeMetricsEnabled;
    private final boolean commentRatioMetricEnabled;

    public CommentMetricAnalysis(boolean commentTypeMetricsEnabled, boolean commentRatioMetricEnabled) {
        this.commentTypeMetricsEnabled = commentTypeMetricsEnabled;
        this.commentRatioMetricEnabled = commentRatioMetricEnabled;
        if (commentRatioMetricEnabled) {
            this.metricValues.put(COMMENT_CHARACTER_COUNT_RATIO, (PairList<String, Serializable>)new PairList());
            this.metricValues.put(CODE_COUNT, (PairList<String, Serializable>)new PairList());
        }
        if (commentTypeMetricsEnabled) {
            this.metricValues.put(COMMENT_CHARACTER_COUNT_TYPE, (PairList<String, Serializable>)new PairList());
            this.metricValues.put(COMMENTED_OUT_CODE_COUNT, (PairList<String, Serializable>)new PairList());
            this.metricValues.put(COPYRIGHT_COUNT, (PairList<String, Serializable>)new PairList());
            this.metricValues.put(HEADER_COUNT, (PairList<String, Serializable>)new PairList());
            this.metricValues.put(INLINE_COUNT, (PairList<String, Serializable>)new PairList());
            this.metricValues.put(INTERFACE_COUNT, (PairList<String, Serializable>)new PairList());
            this.metricValues.put(SECTION_COUNT, (PairList<String, Serializable>)new PairList());
            this.metricValues.put(TASK_COUNT, (PairList<String, Serializable>)new PairList());
        }
    }

    @Override
    protected void setUpElementAnalysis() {
        this.commentDistribution = new CounterSet();
        this.commentCharacterCount = 0;
    }

    private static int getCodeCharacterCount(List<IToken> tokens) {
        int totalCharacterCount = 0;
        for (IToken token : tokens) {
            totalCharacterCount += StringUtils.removeWhitespace((String)token.getText()).length();
        }
        return totalCharacterCount;
    }

    @Override
    protected void analyzeComments(List<Comment> comments, TokenElementInfo element, List<IToken> tokens, CommentClassificationCache classificationCache) throws ConQATException {
        if (!CommentMetricAnalysis.isSupportedLanguage(element.getLanguage())) {
            return;
        }
        super.analyzeComments(comments, element, tokens, classificationCache);
    }

    @Override
    protected void analyzeComment(Comment comment, ECommentCategory category) {
        this.commentCharacterCount += CommentMetricAnalysis.getCommentLength(comment.getText());
        this.commentDistribution.inc((Object)category, CommentMetricAnalysis.getCommentLength(comment.getText()));
    }

    private static int getCommentLength(String comment) {
        return StringUtils.removeWhitespace((String)comment).length();
    }

    @Override
    protected void completeElementAnalysis(List<IToken> tokens, TokenElementInfo element) {
        int codeCharacterCount;
        if (CommentMetricAnalysis.isSupportedLanguage(element.getLanguage())) {
            codeCharacterCount = CommentMetricAnalysis.getCodeCharacterCount(tokens);
        } else {
            String uniformPath = element.getUniformPath();
            if (UniformPathUtils.isArchitectureFile((String)uniformPath)) {
                codeCharacterCount = 0;
            } else {
                codeCharacterCount = element.getText().length();
                this.commentCharacterCount = CommentMetricAnalysis.calculateCommentCountLanguageIndependent(tokens);
            }
        }
        if (this.commentRatioMetricEnabled) {
            this.addMetricValue(element, COMMENT_CHARACTER_COUNT_RATIO, this.commentCharacterCount);
            this.addMetricValue(element, CODE_COUNT, codeCharacterCount);
        }
        if (this.commentTypeMetricsEnabled) {
            this.addMetricValue(element, COMMENT_CHARACTER_COUNT_TYPE, this.commentCharacterCount);
            this.addMetricValue(element, COPYRIGHT_COUNT, ECommentCategory.COPYRIGHT);
            this.addMetricValue(element, HEADER_COUNT, ECommentCategory.HEADER);
            this.addMetricValue(element, INTERFACE_COUNT, ECommentCategory.INTERFACE);
            this.addMetricValue(element, INLINE_COUNT, ECommentCategory.INLINE);
            this.addMetricValue(element, SECTION_COUNT, ECommentCategory.SECTION);
            this.addMetricValue(element, TASK_COUNT, ECommentCategory.TASK);
            this.addMetricValue(element, COMMENTED_OUT_CODE_COUNT, ECommentCategory.CODE);
        }
    }

    private void addMetricValue(TokenElementInfo element, String metric, int value) {
        this.metricValues.get(metric).add((Object)element.getUniformPath(), (Object)value);
    }

    private void addMetricValue(TokenElementInfo element, String metric, ECommentCategory commentCategory) {
        this.metricValues.get(metric).add((Object)element.getUniformPath(), (Object)this.commentDistribution.getValue((Object)commentCategory));
    }

    private static int calculateCommentCountLanguageIndependent(List<IToken> tokens) {
        int commentCount = 0;
        for (IToken token : tokens) {
            if (token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) continue;
            commentCount += CommentMetricAnalysis.getCommentLength(token.getText());
        }
        return commentCount;
    }

    public Map<String, PairList<String, Serializable>> getMetricValues() {
        return this.metricValues;
    }

    public List<String> getPartitions() {
        return this.metricValues.keySet().stream().toList();
    }
}

