/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.google.common.collect.ImmutableList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.util.tokens.TokenStreamTransformationPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;

public class DataflowAnalysisTransformationPatterns {
    private static final Map<ELanguage, List<TokenStreamTransformationPattern>> DEFAULT_PATTERNS_BY_LANGUAGE = Map.of(ELanguage.JAVA, DataflowAnalysisTransformationPatterns.createPatternsFromStringsIgnoringErrors(List.of("JAVA#assert $a : $b;#{ if (!($a)) { throw new java.lang.AssertionError($b); } }", "JAVA#assert $a;#     { if (!($a)) { throw new java.lang.AssertionError(); } }")), ELanguage.CS, DataflowAnalysisTransformationPatterns.createPatternsFromStringsIgnoringErrors(List.of("CS#$a1.HasValue#              ($a1 != null && $a1.HasValue)", "CS#$a1.GetValueOrDefault()#   ($a1 ? $a1.Value : DUMMY)", "CS#$a1.GetValueOrDefault($a2)#($a1 ? $a1.Value : $a2)")));
    private static final Pattern USER_DEFINED_TRANSFORMATION_SPLIT_PATTERN = Pattern.compile("##");
    private static final Logger LOGGER = LogManager.getLogger();

    public static ImmutableList<TokenStreamTransformationPattern> getDefaultTransformationPatterns(ELanguage language) {
        return DataflowAnalysisTransformationPatterns.getDefaultTransformationPatterns(Set.of(language));
    }

    public static ImmutableList<TokenStreamTransformationPattern> getDefaultTransformationPatterns(Set<ELanguage> languages) {
        ArrayList<TokenStreamTransformationPattern> defaultTransformationPatterns = new ArrayList<TokenStreamTransformationPattern>();
        for (ELanguage language : languages) {
            List<TokenStreamTransformationPattern> defaultTransformationPatternsForLanguage = DEFAULT_PATTERNS_BY_LANGUAGE.get(language);
            if (defaultTransformationPatternsForLanguage == null) continue;
            defaultTransformationPatterns.addAll(defaultTransformationPatternsForLanguage);
        }
        return ImmutableList.copyOf(defaultTransformationPatterns);
    }

    public static List<String> buildJavaTransformations(List<String> customAsserts, boolean usingJUnitAsserts, int jUnitVersion) {
        ArrayList<String> transformations = new ArrayList<String>();
        for (String assertName : customAsserts) {
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.JAVA, null, assertName, "($a, $b);", "!($a)", transformations);
        }
        if (usingJUnitAsserts) {
            String cls = jUnitVersion == 4 ? "Assert" : "Assertions";
            String patternWithMessage = jUnitVersion == 4 ? "($b, $a);" : "($a, $b);";
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.JAVA, cls, "assertNotNull", patternWithMessage, "$a == null", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.JAVA, cls, "assertNull", patternWithMessage, "$a != null", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.JAVA, cls, "assertTrue", patternWithMessage, "!($a)", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.JAVA, cls, "assertFalse", patternWithMessage, "$a", transformations);
        }
        return transformations;
    }

    public static List<String> buildCsTransformations(List<String> customAsserts, boolean usingCSAsserts) {
        ArrayList<String> transformations = new ArrayList<String>();
        for (String assertName : customAsserts) {
            DataflowAnalysisTransformationPatterns.addTransformation(ELanguage.CS, assertName + "($a);", "{ if (!($a)) { throw new AssertFailedException(); } }", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, null, assertName, "($a, $b);", "!($a)", transformations);
        }
        if (usingCSAsserts) {
            String cls = "Assert";
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, cls, "IsNotNull", "($a, $b);", "$a == null", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, cls, "IsNull", "($a, $b);", "$a != null", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, cls, "IsTrue", "($a, $b);", "!($a)", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, cls, "IsFalse", "($a, $b);", "$a", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, cls, "NotNull", "($a, $b);", "$a == null", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, cls, "Null", "($a, $b);", "$a != null", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, cls, "True", "($a, $b);", "!($a)", transformations);
            DataflowAnalysisTransformationPatterns.addXUnitAssertTransformation(ELanguage.CS, cls, "False", "($a, $b);", "$a", transformations);
        }
        return transformations;
    }

    private static void addXUnitAssertTransformation(ELanguage language, String className, String name, String patternWithMessage, String ifCondition, List<String> transformations) {
        String pattern = "($a);";
        String replacementWithMessage = DataflowAnalysisTransformationPatterns.assertionForLanguage(language, ifCondition, "$b");
        String replacement = DataflowAnalysisTransformationPatterns.assertionForLanguage(language, ifCondition, null);
        ArrayList<Object> prefixes = new ArrayList<Object>();
        prefixes.add("");
        if (className != null) {
            prefixes.add(className + ".");
        }
        for (String string : prefixes) {
            DataflowAnalysisTransformationPatterns.addTransformation(language, string + name + patternWithMessage, replacementWithMessage, transformations);
            DataflowAnalysisTransformationPatterns.addTransformation(language, string + name + pattern, replacement, transformations);
        }
    }

    private static String assertionForLanguage(ELanguage language, String ifCondition, String message) {
        switch (language) {
            case JAVA: {
                if (message == null) {
                    return "{ if (" + ifCondition + ") { throw new java.lang.AssertionError(); } }";
                }
                return "{ String __teamscale_generated_assertion_message = " + message + "; if (" + ifCondition + ") { throw new java.lang.AssertionError(__teamscale_generated_assertion_message); } }";
            }
            case CS: {
                if (message == null) {
                    return "{ if (" + ifCondition + ") { throw new AssertFailedException(); } }";
                }
                return "{ string __teamscale_generated_assertion_message = " + message + "; if (" + ifCondition + ") { throw new AssertFailedException(__teamscale_generated_assertion_message); } }";
            }
        }
        throw new UnsupportedOperationException("Missing support for language: " + String.valueOf(language));
    }

    public static List<String> parseUserDefinedTransformations(String userDefinedTransformations) {
        ArrayList<String> transformations = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)userDefinedTransformations)) {
            transformations.addAll(Arrays.asList(USER_DEFINED_TRANSFORMATION_SPLIT_PATTERN.split(userDefinedTransformations)));
        }
        return transformations;
    }

    private static void addTransformation(ELanguage language, String searchPattern, String replacementPattern, List<String> transformations) {
        transformations.add(DataflowAnalysisTransformationPatterns.getStringRepresentationForTokenTransformation(language, searchPattern, replacementPattern));
    }

    public static TokenStreamTransformationPattern createPatternFromString(String transformation) throws ConQATException {
        String[] parts = transformation.split("#");
        if (parts.length != 3) {
            throw new ConQATException("Malformed token transformation: " + transformation + "\nEach token transformation must have exactly 3 parts separated by #");
        }
        return new TokenStreamTransformationPattern(parts[1].trim(), parts[2].trim(), ELanguage.valueOf((String)parts[0].trim()));
    }

    private static List<TokenStreamTransformationPattern> createPatternsFromStringsIgnoringErrors(List<String> transformations) {
        ArrayList<TokenStreamTransformationPattern> patterns = new ArrayList<TokenStreamTransformationPattern>();
        for (String transformation : transformations) {
            try {
                patterns.add(DataflowAnalysisTransformationPatterns.createPatternFromString(transformation));
            }
            catch (ConQATException e) {
                LOGGER.error("Could not parse token-transformation pattern {}. Skipping the pattern.", (Object)transformation, (Object)e);
            }
        }
        return patterns;
    }

    public static String getStringRepresentationForTokenTransformation(ELanguage language, String searchPattern, String replacementPattern) {
        return String.valueOf(language) + "#" + searchPattern + "#" + replacementPattern;
    }
}

