/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.configuration.tools.CppcheckConfigurationBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.Set;

public class CppcheckPremiumConfiguration
extends CppcheckConfigurationBase {
    public static final String CPPCHECK_MAPPINGS_TSV = "premium/check-mappings.tsv";
    public static final String VERSION_FILE = "premium/version.txt";
    public static final String DEFAULT_ENABLED_CHECKS_FOR_C_REGEX = ".*";
    @ConfigExposed(name="Cppcheck Premium: Enabled Checks for C", description="Regex filter for cppcheck check names that can be run on C code (all checks are executed for C++ code). Checks are executed if the corresponding rule is selected in the analysis profile.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public CodeScopeAware<String> enabledChecksForCRegex = CodeScopeAware.defaultCodeScopeWithValue((Object)".*");

    public CppcheckPremiumConfiguration() {
        super(EAnalysisTool.CPPCHECK_PREMIUM);
        this.declareCodeScopeAware();
    }

    @Override
    protected String getCppCheckMappingsFile() {
        return CPPCHECK_MAPPINGS_TSV;
    }

    @Override
    protected EAnalysisTool getAnalysisTool() {
        return EAnalysisTool.CPPCHECK_PREMIUM;
    }

    @Override
    protected CodeScopeAware<String> getEnabledChecksForCRegex() {
        return this.enabledChecksForCRegex;
    }

    @Override
    protected Set<ELanguage> getSupportedLanguageForCheck(String checkId) {
        if (checkId.startsWith("premium-misra-cpp-") || checkId.startsWith("premium-autosar-") || checkId.startsWith("premium-cert-") && checkId.endsWith("cpp")) {
            return Set.of(ELanguage.CPP, ELanguage.CPP_MS_CLI);
        }
        if (checkId.startsWith("premium-misra-c-") || checkId.startsWith("premium-cert-") && checkId.endsWith("c")) {
            return Set.of(ELanguage.C);
        }
        return LanguageGroups.C_CPP_AND_MS_CLI;
    }

    @Override
    protected String getDescriptionPath() {
        return "cppcheck/premium";
    }
}

