/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.configuration.DataflowAnalysisTransformationPatterns;
import com.teamscale.index.dataflow.CfgConstructorResult;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowHeuristicFactory;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDataFlowHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.CppDataFlowHeuristic;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.preprocessor.PreprocessorFactory;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenStreamTransformationPattern;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class CFGConstructor {
    private static final String[] PREPROCESSOR_CONDITION_PREFIXES = new String[]{"#if", "#else", "#endif"};
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<TokenStreamTransformationPattern> tokenTransformations;

    public CFGConstructor(List<TokenStreamTransformationPattern> tokenTransformations) throws ConQATException {
        this.tokenTransformations = tokenTransformations;
    }

    public CfgConstructorResult computeCfgForElement(TokenElementInfo element) throws ConQATException {
        if (!ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage()) || !DataFlowHeuristicFactory.supportsLanguage(element.getLanguage())) {
            return null;
        }
        Object entities = EnumSet.of(ELanguage.CS, ELanguage.ABAP, ELanguage.JAVA).contains(element.getLanguage()) ? CFGConstructor.parseWithOwnPreprocessing(element, this.tokenTransformations) : element.getShallowEntitiesWithPreprocessorTokens();
        List<ControlFlowGraph> graphs = CFGConstructor.getControlFlowGraphs(element.getLanguage(), element.getUniformPath(), entities, false);
        return new CfgConstructorResult((List<ShallowEntity>)entities, graphs);
    }

    private static List<ShallowEntity> parseWithOwnPreprocessing(TokenElementInfo element, List<TokenStreamTransformationPattern> tokenTransformations) throws ConQATException {
        UnmodifiableList<IToken> tokens = element.getTokens();
        List<Object> filteredTokens = new ArrayList<IToken>();
        for (IToken token : tokens) {
            if (token.getType() == ETokenType.PREPROCESSOR_DIRECTIVE && !CFGConstructor.isPreprocessorConditionToken(token)) continue;
            filteredTokens.add(token);
        }
        ArrayList<TokenStreamTransformationPattern> filteredTokenTransformations = new ArrayList<TokenStreamTransformationPattern>();
        filteredTokenTransformations.addAll((Collection<TokenStreamTransformationPattern>)DataflowAnalysisTransformationPatterns.getDefaultTransformationPatterns(element.getLanguage()));
        filteredTokenTransformations.addAll(CollectionUtils.filter(tokenTransformations, transformation -> transformation.getLanguage() == element.getLanguage()));
        filteredTokens = TokenStreamTransformationPattern.applyPatterns(filteredTokens, filteredTokenTransformations);
        try {
            Optional preprocessor = PreprocessorFactory.createLocalPreprocessor((ELanguage)element.getLanguage());
            if (preprocessor.isPresent()) {
                filteredTokens = ((IPreprocessor)preprocessor.get()).preprocess(element.getUniformPath(), filteredTokens);
            }
            return ShallowParserFactory.createParser((ELanguage)element.getLanguage()).parseTopLevel(filteredTokens);
        }
        catch (ShallowParserException e) {
            throw new ConQATException("Shallow parsing element " + element.getUniformPath() + " failed", (Throwable)e);
        }
    }

    public static List<ControlFlowGraph> getControlFlowGraphs(ELanguage language, String uniformPath, List<ShallowEntity> entities, boolean includeCppLambdasNotNestedInMethods) throws ConQATException {
        IDataFlowHeuristic heuristic = DataFlowHeuristicFactory.createDataFlowHeuristic(language);
        HashSet<VariableWrite> fileScopeVariables = new HashSet<VariableWrite>();
        PairList<String, List<ShallowEntity>> executables = heuristic.extractExecutables(uniformPath, entities);
        if (includeCppLambdasNotNestedInMethods && heuristic instanceof CppDataFlowHeuristic) {
            executables.addAll(CppDataFlowHeuristic.extractLambdasNotNestedInMethods(entities));
        }
        executables = CFGConstructor.filterValidExecutables(executables, uniformPath);
        ArrayList<ControlFlowGraph> graphs = new ArrayList<ControlFlowGraph>();
        for (int i = 0; i < executables.size(); ++i) {
            String executableName = (String)executables.getFirst(i);
            List executableEntities = (List)executables.getSecond(i);
            Optional<ControlFlowGraph> graph = CFGConstructor.createGraph(language, uniformPath, entities, heuristic, fileScopeVariables, executableEntities, executableName);
            if (!graph.isPresent()) continue;
            if (CFGConstructor.graphSharesNodesWithNestedOrLamdaGraphs(graph.get())) {
                LOGGER.error("Control flow graph creation failed for method {} in {}:{}. CFG is linked to inner CFGs. Skipping this method.", (Object)executableName, (Object)uniformPath, (Object)((ShallowEntity)executableEntities.getFirst()).getStartLine());
                continue;
            }
            fileScopeVariables.addAll(graph.get().getDefinedGlobalVariables());
            CFGConstructor.insertCfgIntoGraphs(graphs, graph.get());
        }
        return graphs;
    }

    private static boolean graphSharesNodesWithNestedOrLamdaGraphs(ControlFlowGraph outerGraph) {
        HashMap<ControlFlowNode, ControlFlowGraph> nodeToGraphMap = new HashMap<ControlFlowNode, ControlFlowGraph>();
        ArrayDeque<ControlFlowGraph> cfgsToProcess = new ArrayDeque<ControlFlowGraph>(List.of(outerGraph));
        HashSet<ControlFlowGraph> seenGraphs = new HashSet<ControlFlowGraph>();
        while (!cfgsToProcess.isEmpty()) {
            ControlFlowGraph graph = (ControlFlowGraph)cfgsToProcess.pop();
            if (!seenGraphs.add(graph)) continue;
            for (ControlFlowNode node : graph.listDepthFirst()) {
                cfgsToProcess.addAll((Collection<ControlFlowGraph>)node.getLambdas());
                if (nodeToGraphMap.containsKey(node) && nodeToGraphMap.get(node) != graph) {
                    return true;
                }
                nodeToGraphMap.put(node, graph);
            }
        }
        return false;
    }

    private static PairList<String, List<ShallowEntity>> filterValidExecutables(PairList<String, List<ShallowEntity>> executables, String uniformPath) {
        PairList result = new PairList();
        for (int i = 0; i < executables.size(); ++i) {
            String executableName = (String)executables.getFirst(i);
            List executableEntities = (List)executables.getSecond(i);
            if (CFGConstructor.containsPreprocessorConditions(executableEntities)) {
                LOGGER.info("Ignoring method " + executableName + " in file " + uniformPath + " because it contains preprocessor conditions");
                continue;
            }
            if (CFGConstructor.containsIncompleteEntities(executableEntities)) {
                LOGGER.warn("Ignoring method " + executableName + " in file " + uniformPath + " because it could not be parsed correctly.");
                continue;
            }
            result.add((Object)executableName, (Object)executableEntities);
        }
        return result;
    }

    private static Optional<ControlFlowGraph> createGraph(ELanguage language, String uniformPath, List<ShallowEntity> entities, IDataFlowHeuristic heuristic, Set<VariableWrite> fileScopeVariables, List<ShallowEntity> executableEntities, String executableName) throws Error {
        String messagePrefix = "Error while processing " + executableName + " in " + uniformPath + ": ";
        try {
            DataFlowContext context = CFGConstructor.createDataFlowContext(uniformPath, entities, language, fileScopeVariables);
            Optional<ControlFlowGraph> graph = heuristic.createControlFlow(executableEntities, executableName, context);
            graph.ifPresent(controlFlowGraph -> controlFlowGraph.setInfiniteLoopNodes(context.getInfiniteLoopNodes()));
            return graph;
        }
        catch (Exception e) {
            LOGGER.error(messagePrefix + "An error occurred while trying to construct a CFG for function '" + executableName + "' in element " + uniformPath + ". This function will be ignored. Exception message: " + e.getMessage(), (Throwable)e);
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new Error("Memory Error while computing CFG for function '" + executableName + "' in element " + uniformPath, e);
        }
        catch (AssertionError e) {
            LOGGER.error(messagePrefix + "Assertion error while computing CFG for function '" + executableName + "' in element " + uniformPath, (Throwable)((Object)e));
        }
        return Optional.empty();
    }

    private static void insertCfgIntoGraphs(List<ControlFlowGraph> graphs, ControlFlowGraph graph) {
        if (graph.isInitializerCode()) {
            graphs.add(0, graph);
        } else {
            graphs.add(graph);
        }
    }

    private static DataFlowContext createDataFlowContext(String uniformPath, List<ShallowEntity> entities, ELanguage language, Set<VariableWrite> fileScopeVariables) throws ConQATException {
        DataFlowContext context = new DataFlowContext(uniformPath, language, entities);
        for (VariableWrite variable : fileScopeVariables) {
            context.getDefUseHeuristic().addToFileScope(variable.getChangedVariable());
        }
        return context;
    }

    private static boolean containsIncompleteEntities(List<ShallowEntity> entities) {
        return ShallowEntityTraversalUtils.findIncompleteEntity(entities) != null;
    }

    private static boolean containsPreprocessorConditions(List<ShallowEntity> entities) {
        for (ShallowEntity entity : entities) {
            for (IToken token : entity.includedTokens()) {
                if (!CFGConstructor.isPreprocessorConditionToken(token)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPreprocessorConditionToken(IToken token) {
        return token.getType() == ETokenType.PREPROCESSOR_DIRECTIVE && StringUtils.startsWithOneOf((String)token.getText(), (String[])PREPROCESSOR_CONDITION_PREFIXES);
    }
}

