/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodCallIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.abap.AbapMethodCallRecognizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

public class MethodCallIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MethodIndex methodIndex;
    @DeltaSource(value=MethodIndex.class)
    private KeyDelta methodDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="method-calls")
    private MethodCallIndex callIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    private final SetMap<String, String> methodLookup = new SetMap();

    public void execute() throws StorageException {
        for (String methodSignature : this.methodIndex.getAllMethods()) {
            this.methodLookup.add((Object)MethodIndex.getMethodName(methodSignature), (Object)methodSignature);
        }
        List<String> addedOrChangedMethods = MethodIndex.getMethodKeysFromDelta(this.methodDelta.getAddedOrChangedKeysAsStrings());
        List<String> deletedMethods = MethodIndex.getMethodKeysFromDelta(this.methodDelta.getDeletedKeysAsStrings());
        List<String> methodsToUpdate = this.getMethodsToUpdate(deletedMethods, addedOrChangedMethods);
        PairList<String, ArrayList<String>> updatedValues = this.computeUpdatedValues(methodsToUpdate);
        this.callIndex.updateMethodCalls(updatedValues.toMap(), deletedMethods);
    }

    private PairList<String, ArrayList<String>> computeUpdatedValues(List<String> methodsToUpdate) throws StorageException {
        PairList result = new PairList();
        List<String> uniformPaths = this.methodIndex.getFilesForMethods(methodsToUpdate);
        Map<String, TokenElementInfo> elementInfoMap = this.collectTokenElementInfosForPaths(uniformPaths);
        for (int i = 0; i < methodsToUpdate.size(); ++i) {
            ShallowEntity methodEntity;
            String method = methodsToUpdate.get(i);
            String uniformPath = uniformPaths.get(i);
            if (uniformPath == null || (methodEntity = MethodCallIndexSynchronizer.getMethodEntityFor(method, uniformPath, elementInfoMap)) == null) continue;
            Set<String> calledMethods = this.collectMethodCalls(methodEntity, uniformPath);
            result.add((Object)method, new ArrayList<String>(calledMethods));
        }
        return result;
    }

    private static ShallowEntity getMethodEntityFor(String method, String uniformPath, Map<String, TokenElementInfo> elementInfoMap) {
        TokenElementInfo tokenElement = elementInfoMap.get(uniformPath);
        if (tokenElement == null) {
            LOGGER.debug("Failed to access token element for method: " + method);
            return null;
        }
        if (tokenElement.getShallowEntitiesWithPreprocessorTokens() == null) {
            LOGGER.debug("Token element has no shallowEntities: " + uniformPath);
            return null;
        }
        ShallowEntity methodEntity = MethodCallIndexSynchronizer.lookupMethodByName(ShallowEntityTraversalUtils.listEntitiesOfType(tokenElement.getShallowEntitiesWithPreprocessorTokens(), (EShallowEntityType)EShallowEntityType.METHOD), StringUtils.getLastPart((String)method, (char)'.'));
        if (methodEntity == null) {
            methodEntity = MethodCallIndexSynchronizer.lookupMethodByName(ShallowEntityTraversalUtils.listEntitiesOfType(tokenElement.getShallowEntitiesWithPreprocessorTokens(), (EShallowEntityType)EShallowEntityType.METHOD), StringUtils.getLastPart((String)method, (char)'#'));
        }
        if (methodEntity == null) {
            LOGGER.debug("Could not find method entity for method: " + method);
        }
        return methodEntity;
    }

    private Map<String, TokenElementInfo> collectTokenElementInfosForPaths(List<String> uniformPaths) throws StorageException {
        List<String> nonNullPaths = uniformPaths.stream().filter(path -> path != null).distinct().collect(Collectors.toList());
        List<TokenElementInfo> tokenElements = this.contentIndex.getTokenElements(nonNullPaths, true);
        HashMap<String, TokenElementInfo> pathToElementInfo = new HashMap<String, TokenElementInfo>();
        for (int i = 0; i < nonNullPaths.size(); ++i) {
            if (tokenElements.get(i) == null) continue;
            pathToElementInfo.put(nonNullPaths.get(i), tokenElements.get(i));
        }
        return pathToElementInfo;
    }

    private Set<String> collectMethodCalls(ShallowEntity methodEntity, String uniformPath) {
        HashSet<String> calledMethods = new HashSet<String>();
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singleton(methodEntity), (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            Optional methodCallInfo = AbapMethodCallRecognizer.parse((List)statement.includedTokens());
            if (!methodCallInfo.isPresent()) continue;
            calledMethods.addAll(this.lookupMethodCall((AbapMethodCallRecognizer.MethodCallInfo)methodCallInfo.get(), uniformPath));
        }
        return calledMethods;
    }

    private Set<String> lookupMethodCall(AbapMethodCallRecognizer.MethodCallInfo methodCallInfo, String callerUniformPath) {
        HashSet<String> calledMethods = new HashSet<String>();
        Set resolvedMethods = (Set)this.methodLookup.getCollection((Object)methodCallInfo.getMethodName().toLowerCase());
        if (resolvedMethods == null) {
            return calledMethods;
        }
        if (methodCallInfo.isStaticCall() && !methodCallInfo.getMethodContainerName().isEmpty()) {
            for (String resolvedMethod : resolvedMethods) {
                if (!resolvedMethod.endsWith(methodCallInfo.getMethodContainerName() + "." + methodCallInfo.getMethodName())) continue;
                calledMethods.add(resolvedMethod);
                break;
            }
        } else if (methodCallInfo.isFormCall()) {
            Set targetsInSameFile = CollectionUtils.filterToSet((Collection)resolvedMethods, potentialTarget -> potentialTarget.startsWith(callerUniformPath + "#"));
            if (!targetsInSameFile.isEmpty()) {
                calledMethods.addAll(targetsInSameFile);
            } else {
                calledMethods.addAll(resolvedMethods);
            }
        } else {
            calledMethods.addAll(resolvedMethods);
        }
        return calledMethods;
    }

    private static ShallowEntity lookupMethodByName(Collection<ShallowEntity> methods, String name) {
        for (ShallowEntity method : methods) {
            if (method.getSubtype().equals("start-of-selection") && (name.equals(method.getName()) || "start-of-selection".equals(name) || "START-OF-SELECTION".equals(name))) {
                return method;
            }
            if (!name.equals(method.getName()) || !method.getSubtype().equals("method implementation") && !method.getSubtype().equals("form") && !method.getSubtype().equals("function")) continue;
            return method;
        }
        return null;
    }

    private List<String> getMethodsToUpdate(List<String> deletedMethods, List<String> modifiedMethods) throws StorageException {
        HashSet<String> result = new HashSet<String>(modifiedMethods);
        result.addAll(this.getInverseCalls(deletedMethods));
        result.addAll(this.getInverseCalls(modifiedMethods));
        CollectionUtils.removeAll(result, deletedMethods);
        return new ArrayList<String>(result);
    }

    private Set<String> getInverseCalls(List<String> methodIds) throws StorageException {
        Set methodNames = methodIds.stream().map(id -> StringUtils.getLastPart((String)id, (String)".")).collect(Collectors.toSet());
        List<String> allMethodIds = methodNames.stream().flatMap(name -> ((Set)this.methodLookup.getCollectionOrEmpty(name)).stream()).distinct().collect(Collectors.toList());
        allMethodIds.addAll(methodIds);
        return this.callIndex.getUnionOfCallersOfMethods(allMethodIds);
    }
}

