/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.javascript;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.javascript.TsConfig;
import com.teamscale.index.dependencies.javascript.TsConfigPathsIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

public class TsConfigPathsSynchronizer
extends ChangeProcessorAnalysisStep {
    public static final String TSCONFIG_JSON_FILE_NAME = "tsconfig.json";
    public static final String JSCONFIG_JSON_FILE_NAME = "jsconfig.json";
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta delta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex inputIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TsConfigPathsIndex pathsIndex;

    public void execute() throws StorageException {
        List<String> addedOrChangedTsConfigFiles = TsConfigPathsSynchronizer.filterTsConfigFiles(this.delta.getAddedOrChangedKeysAsStrings());
        List<String> deletedTsConfigFiles = TsConfigPathsSynchronizer.filterTsConfigFiles(this.delta.getDeletedKeysAsStrings());
        this.pathsIndex.removeConfigs(deletedTsConfigFiles);
        try {
            PairList values = new PairList();
            for (String newFile : addedOrChangedTsConfigFiles) {
                String fileContent = this.inputIndex.getTokenElement(newFile).getText();
                TsConfig tsConfig = TsConfigPathsSynchronizer.deserializeTsConfig(fileContent);
                values.add((Object)newFile, (Object)tsConfig);
            }
            this.pathsIndex.setConfigs((PairList<String, TsConfig>)values);
        }
        catch (ConQATException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    static TsConfig deserializeTsConfig(String fileContent) throws JsonSerializationException {
        return (TsConfig)JsonUtils.deserializeFromJson((String)fileContent, TsConfig.class);
    }

    private static List<String> filterTsConfigFiles(List<String> addedOrChangedKeysAsStrings) {
        return CollectionUtils.filter(addedOrChangedKeysAsStrings, TsConfigPathsSynchronizer::isTsOrJsConfigFile);
    }

    private static boolean isTsOrJsConfigFile(String uniformPath) {
        String elementName = UniformPathUtils.getElementName((String)uniformPath);
        return elementName.equals(TSCONFIG_JSON_FILE_NAME) || elementName.equals(JSCONFIG_JSON_FILE_NAME);
    }
}

