/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.UploadRejectedException;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.StoreAnalysisResultsInExternalStorageTrigger;
import com.teamscale.index.external.input.external_storage.migration.StorageBackendMigrationException;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.ClusterByTimestamp;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitAndPartition;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitCluster;
import com.teamscale.index.external.input.external_storage.migration.migrators.ExternalAnalysisResultsMigratorProvider;
import com.teamscale.index.external.input.external_storage.migration.migrators.IExternalAnalysisResultsMigrator;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisPartitionInfo;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisShortStatusInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StorageBackendMigrationTrigger
extends PrivilegedTriggerBase {
    public static final String MIGRATION_SCHEDULING_REASON = "External analysis data is being migrated.";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String INTERNAL_MIGRATION_USER = "internal-migration";

    public void execute() throws Exception {
        JobParameter parameter = (JobParameter)this.jobDescriptor.getParameterObject(JobParameter.class);
        InternalProjectId projectId = parameter.projectId();
        ExternalStorageBackend targetStorage = parameter.externalStorage();
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)projectId);
        ExternalAnalysisStatusIndex statusIndex = (ExternalAnalysisStatusIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        ExternalAnalysisImportSessionManager sessionManager = ExternalAnalysisImportSessionManager.createMigrationSessionManager(this.indexLayer, projectId);
        ListMap<String, CommitAndPartition> uploadCommitsByBranch = StorageBackendMigrationTrigger.getExternalUploadCommitsByBranch((ProjectStorageSystem)projectStorageSystem);
        RepositoryRevisionIndex repositoryRevisionIndex = (RepositoryRevisionIndex)projectStorageSystem.openProjectIndex(RepositoryRevisionIndex.class, null);
        ListMap<String, CommitCluster> clusteredCommitsByBranch = ClusterByTimestamp.clusterCommits(uploadCommitsByBranch, repositoryRevisionIndex, LOGGER);
        for (CommitCluster commitCluster : (List)clusteredCommitsByBranch.getValues()) {
            this.migrateCommitCluster(commitCluster, projectId, targetStorage, (ProjectStorageSystem)projectStorageSystem, statusIndex, sessionManager);
        }
        StoreAnalysisResultsInExternalStorageTrigger.schedule(projectId, this.indexLayer, MIGRATION_SCHEDULING_REASON);
    }

    private void migrateCommitCluster(CommitCluster commitCluster, InternalProjectId projectId, ExternalStorageBackend targetStorage, ProjectStorageSystem projectStorageSystem, ExternalAnalysisStatusIndex statusIndex, ExternalAnalysisImportSessionManager sessionManager) {
        try {
            HashMap<String, ExternalAnalysisImportInfos> importInfosByPartition = new HashMap<String, ExternalAnalysisImportInfos>();
            for (CommitAndPartition commitAndPartition : commitCluster.commits()) {
                ExternalAnalysisImportInfos importInfos = importInfosByPartition.computeIfAbsent(commitAndPartition.partition(), partition -> new ExternalAnalysisImportInfos());
                importInfos.addAll(StorageBackendMigrationTrigger.migrateResults(commitAndPartition, projectStorageSystem));
            }
            for (Map.Entry entry : importInfosByPartition.entrySet()) {
                String partition2 = (String)entry.getKey();
                ExternalAnalysisImportInfos importInfos = (ExternalAnalysisImportInfos)entry.getValue();
                ExternalAnalysisSessionInfo session = this.createUploadSession(commitCluster, projectId, partition2, targetStorage);
                StorageBackendMigrationTrigger.storeUploadSession(session, importInfos, sessionManager);
            }
            StorageBackendMigrationTrigger.updateUploadedStatus(commitCluster, statusIndex, true);
        }
        catch (Exception e) {
            StorageBackendMigrationTrigger.updateUploadedStatus(commitCluster, statusIndex, false);
            LOGGER.atError().withThrowable((Throwable)e).log("Could not process upload commit for {}. Skipping and processing next batch.", (Object)commitCluster.toString());
        }
    }

    private static void updateUploadedStatus(CommitCluster commitCluster, ExternalAnalysisStatusIndex statusIndex, boolean successful) {
        try {
            statusIndex.runWithLock(lockedIndexAccess -> {
                ExternalAnalysisStatusInfo oldStatus = lockedIndexAccess.getStatus(commitCluster.storageTargetCommit());
                ExternalAnalysisStatusInfo newStatus = ExternalAnalysisStatusInfo.copy(oldStatus, () -> new ExternalAnalysisStatusInfo(commitCluster.storageTargetCommit(), true, DateTimeUtils.millisNow(), true));
                newStatus.addProcessingStep(new ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus.UPLOADED, successful, true));
                lockedIndexAccess.updateStatusWithKnownOldStatus(oldStatus, newStatus);
            });
        }
        catch (StorageException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to store status for commit cluster '{}'.", (Object)commitCluster);
        }
    }

    private ExternalAnalysisSessionInfo createUploadSession(CommitCluster commitCluster, InternalProjectId projectId, String partition, ExternalStorageBackend targetStorage) throws StorageException {
        CommitDescriptor targetCommit = commitCluster.storageTargetCommit();
        ExternalAnalysisImportSessionManager sessionManager = ExternalAnalysisImportSessionManager.createMigrationSessionManager(this.indexLayer, projectId);
        LOGGER.trace("Creating session info ...");
        try {
            return (ExternalAnalysisSessionInfo)LOGGER.traceExit((Object)sessionManager.createSession(new ExternalAnalysisImportSessionManager.SessionCreationParameters(targetStorage, partition, "Auto-migrated upload", null, INTERNAL_MIGRATION_USER, targetCommit.toUnresolvedCommitDescriptor(), null)));
        }
        catch (UploadRejectedException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static void storeUploadSession(ExternalAnalysisSessionInfo session, ExternalAnalysisImportInfos importInfos, ExternalAnalysisImportSessionManager sessionManager) throws StorageException {
        LOGGER.trace("Storing session '{}' for next upload trigger. Contained import infos: {}", (Object)session.getSessionId(), (Object)importInfos.getInfos().size());
        if (!session.isOpen()) {
            LOGGER.error("Session was already closed before upload: {}.", (Object)session.getSessionId());
            return;
        }
        sessionManager.storeImportInfosForSession(session, importInfos);
        sessionManager.commitSession(session.getSessionId());
        if (!sessionManager.markSessionAsScheduled(session.getSessionId())) {
            LOGGER.error("Session was unexpectedly already scheduled for upload: {}.", (Object)session.getSessionId());
        }
    }

    private static ExternalAnalysisImportInfos migrateResults(CommitAndPartition commitAndPartition, ProjectStorageSystem projectStorageSystem) throws StorageException {
        LOGGER.trace("Migrating results for {}", (Object)commitAndPartition);
        ExternalAnalysisResultIndex externalAnalysisResultIndex = (ExternalAnalysisResultIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisResultIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commitAndPartition.commit()));
        List<String> allElementPaths = externalAnalysisResultIndex.getAllElementPaths(commitAndPartition.partition());
        List<ExternalAnalysisResults> analysisResults = externalAnalysisResultIndex.getAnalysisResults(commitAndPartition.partition(), allElementPaths);
        ExternalAnalysisImportInfos importInfos = new ExternalAnalysisImportInfos();
        for (int i = 0; i < analysisResults.size(); ++i) {
            String currentPath = allElementPaths.get(i);
            ExternalAnalysisResults resultsForCurrentPath = analysisResults.get(i);
            Set<IExternalAnalysisResultsMigrator> migrators = ExternalAnalysisResultsMigratorProvider.getMigratorsFor(resultsForCurrentPath.getCanonicalTypeNames());
            LOGGER.trace("Using migrators: {}", migrators);
            for (IExternalAnalysisResultsMigrator migrator : migrators) {
                try {
                    importInfos.addAll(migrator.migrate(resultsForCurrentPath, currentPath));
                }
                catch (StorageBackendMigrationException e) {
                    LOGGER.error("Unable to migrate partition {} in commit {}", (Object)commitAndPartition.partition(), (Object)commitAndPartition.commit(), (Object)e);
                }
            }
        }
        return importInfos;
    }

    private static ListMap<String, CommitAndPartition> getExternalUploadCommitsByBranch(ProjectStorageSystem projectStorageSystem) throws StorageException {
        LOGGER.traceEntry("Reading external upload commits by branch...", new Supplier[0]);
        ListMap uploadCommitsByBranch = (ListMap)((ExternalAnalysisStatusIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisStatusIndex.class, null)).computeWithLock(StorageBackendMigrationTrigger::computeExternalUploadCommitsByBranch);
        return (ListMap)LOGGER.traceExit((Object)uploadCommitsByBranch);
    }

    private static ListMap<String, CommitAndPartition> computeExternalUploadCommitsByBranch(ExternalAnalysisStatusIndex.LockedIndexAccess statusIndex) throws StorageException {
        List<ExternalAnalysisPartitionInfo> externalUploadPartitions = statusIndex.getPartitionInfos();
        LOGGER.trace("Found external upload partitions: {}", externalUploadPartitions);
        ListMap uploadCommitsByBranch = new ListMap();
        for (ExternalAnalysisPartitionInfo partitionInfo : externalUploadPartitions) {
            String partition = partitionInfo.getName();
            PairList<CommitDescriptor, ExternalAnalysisShortStatusInfo> commitsForPartition = statusIndex.getCommitsForPartition(partition);
            UnmodifiableList relevantCommits = commitsForPartition.filter((commit, status) -> status.isUpload() && !status.isStoredExternally()).getFirstList();
            uploadCommitsByBranch.addAll(relevantCommits.stream().map(commit -> new CommitAndPartition((CommitDescriptor)commit, partition)).collect(Collectors.groupingBy(commitAndPartition -> commitAndPartition.commit().getBranchName(), Collectors.toList())));
        }
        return uploadCommitsByBranch;
    }

    public record JobParameter(InternalProjectId projectId, ExternalStorageBackend externalStorage) {
    }
}

