/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration.commit_clustering;

import com.google.common.collect.Iterables;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitAndPartition;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record CommitCluster(CommitDescriptor storageTargetCommit, @Nullable String storageTargetRevision, List<CommitAndPartition> commits) {
    public Set<CommitDescriptor> extractCommitDescriptors() {
        return this.commits.stream().map(CommitAndPartition::commit).collect(Collectors.toSet());
    }

    private List<String> extractPartitions() {
        return this.commits.stream().map(CommitAndPartition::partition).distinct().sorted().toList();
    }

    @Override
    public String toString() {
        if (this.commits.isEmpty()) {
            return "CommitCluster[]";
        }
        StringBuilder sb = new StringBuilder("CommitCluster for " + String.valueOf(this.storageTargetCommit) + " (" + this.storageTargetRevision + "): ");
        if (this.commits.size() == 1) {
            CommitAndPartition commitAndPartition = (CommitAndPartition)Iterables.getOnlyElement(this.commits);
            sb.append(commitAndPartition.commit().toString()).append(", partition: ").append(commitAndPartition.partition());
        } else {
            sb.append("[").append(this.commits.getFirst().commit().toString()).append(" - ").append(((CommitAndPartition)Iterables.getLast(this.commits)).commit().toString()).append("], partitions: ").append(this.extractPartitions());
        }
        return sb.toString();
    }
}

