/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.index.configuration.tools.AnalysisToolsContributor;
import jakarta.ws.rs.InternalServerErrorException;
import java.util.List;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.error.ExceptionUtils;

public class ToolAvailabilityCheckTrigger
extends MaintenanceTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws Exception {
        if (!EFeatureToggle.CHECK_AVAILABILITY_OF_ALL_TOOLS_ON_STARTUP.isEnabled()) {
            return;
        }
        ToolAvailabilityCheckTrigger.runToolAvailabilityCheckTrigger(this.indexLayer.openGlobalStorageSystem());
    }

    public static String runToolAvailabilityCheckTrigger(GlobalStorageSystem storageSystem) {
        List configs;
        try {
            configs = new AnalysisToolsContributor().createAllConfigurations(storageSystem);
        }
        catch (ProjectConfigurationException e) {
            throw new InternalServerErrorException("Failed to create analysis tool configurations", (Throwable)e);
        }
        StringJoiner result = new StringJoiner("\n");
        for (AnalysisConfigurationBase config : configs) {
            ToolConfigurationBase toolConfigurationBase;
            if (!(config instanceof ToolConfigurationBase) || !(toolConfigurationBase = (ToolConfigurationBase)config).getTool().isInternal()) continue;
            String info = "Checking availability of tool: " + String.valueOf(toolConfigurationBase.getTool());
            result.add(info);
            LOGGER.info(info);
            try {
                toolConfigurationBase.validateTools();
                info = "Successfully executed tool: " + String.valueOf(toolConfigurationBase.getTool());
                result.add(info);
                LOGGER.info(info);
            }
            catch (ProjectConfigurationException | RuntimeException e) {
                String error = "Failed to execute tool: " + String.valueOf(toolConfigurationBase.getTool());
                result.add(error);
                result.add(ExceptionUtils.getStacktraceAsString((Throwable)e));
                LOGGER.error(error, e);
            }
        }
        return result.toString();
    }
}

