/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.findings.CppIncludeHandler;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public record ClangTidyOutsourcedAnalysisRequestParameters(@JsonProperty(value="globalCompilerArguments") @NonNull List<String> globalCompilerArguments, @JsonProperty(value="selectedChecks") @NonNull Map<ELanguage, String> selectedChecksPerLanguage, @JsonProperty(value="clangTidyOptions") @NonNull Map<String, String> clangTidyOptions, @JsonProperty(value="subjectPaths") @NonNull List<AnalysisSubjectInformation> analysisSubjectInfos, @JsonProperty(value="fileInfos") @NonNull Map<String, String> fileContentHashes) implements Serializable
{
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SELECTED_CHECKS_PARAMETER_NAME = "selectedChecks";
    private static final String CLANG_TIDY_OPTIONS_PARAMETER_NAME = "clangTidyOptions";
    private static final String FILE_CONTENT_HASHES_PARAMETER_NAME = "fileInfos";
    private static final String GLOBAL_COMPILER_ARGUMENTS_PARAMETER_NAME = "globalCompilerArguments";
    private static final String CLANG_TIDY_SUBJECTS_PARAMETER_NAME = "subjectPaths";

    public boolean verifyConsistency() {
        Set languages = this.analysisSubjectInfos.stream().map(AnalysisSubjectInformation::language).collect(Collectors.toSet());
        Set languagesWithNonEmptySelectedChecks = this.selectedChecksPerLanguage.entrySet().stream().filter(entry -> !((String)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet difference = CollectionUtils.differenceSet(languages, (Collection[])new Collection[]{languagesWithNonEmptySelectedChecks});
        if (!difference.isEmpty()) {
            LOGGER.error("No checks selected for languages " + String.valueOf(languages));
            return false;
        }
        return true;
    }

    @IndexValueClass
    public record AnalysisSubjectInformation(@JsonProperty(value="uniformPath") @NonNull String uniformPath, @JsonProperty(value="language") @NonNull ELanguage language, @JsonProperty(value="relevantIncludedPaths") @NonNull Set<CppIncludeHandler.IncludeFile> includedPaths, @JsonProperty(value="localCompilerArguments") @NonNull List<String> localCompilerArguments) implements Serializable
    {
        private static final String UNIFORM_PATH_PARAMETER = "uniformPath";
        private static final String LANGUAGE_PARAMETER = "language";
        private static final String CLANG_TIDY_INCLUDED_PATHS_PARAMETER_NAME = "relevantIncludedPaths";
        private static final String LOCAL_COMPILER_ARGUMENTS_PARAMETER_NAME = "localCompilerArguments";
    }
}

