/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.phpstan;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.lang.Markdown;
import org.conqat.lib.commons.options.CommandLineBase;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.string.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PHPStanRulesExtractor
extends CommandLineBase<Exception> {
    private static final Path CHECK_DESCRIPTIONS_DIRECTORY = Path.of("server/com.teamscale.index/check-descriptions/phpstan/", new String[0]);
    private static final Path CHECK_MAPPINGS_DIRECTORY = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/phpstan/", new String[0]);
    private static final Pattern RULE_EXTRACTION_PATTERN = Pattern.compile("PHPStan(\\\\\\w+)+");
    private Path htmlFile;

    public static void main(String[] args) throws Exception {
        PHPStanRulesExtractor.execute(PHPStanRulesExtractor::new, (String[])args);
    }

    @Option(shortName=102, longName="file", description="The HTML file obtained by loading: 'https://phpstan.org/error-identifiers#gbi-'")
    public void setHtmlFile(String path) {
        this.htmlFile = Path.of(path, new String[0]);
    }

    protected void run() throws Exception {
        Document parsed = Jsoup.parse((Path)this.htmlFile);
        Elements identifierElements = parsed.body().select("h2[id^='gbi-']");
        try (CheckMappingsFile checkMappingsFile = new CheckMappingsFile(CHECK_MAPPINGS_DIRECTORY);){
            for (Element identifierElement : identifierElements) {
                String partialId = StringUtils.stripSuffix((String)identifierElement.text(), (String)"#").trim();
                String id = "phpstan." + partialId;
                PHPStanRulesExtractor.writeCheckDescriptions(id, partialId, identifierElement.nextElementSibling());
                checkMappingsFile.mappingsById.computeIfAbsent(id, ignored -> new CheckMappingsFile.CheckMapping(id, "PHPStan: " + partialId, "Correctness", "Possible Bugs", "TODO", "", ""));
            }
        }
    }

    private static void writeCheckDescriptions(String id, String partialId, Element rulesElement) throws IOException {
        List<String> rules = PHPStanRulesExtractor.extractRules(rulesElement);
        Files.writeString(CHECK_DESCRIPTIONS_DIRECTORY.resolve(id + ".md"), (CharSequence)PHPStanRulesExtractor.buildCheckDescription(partialId, rules), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    @Markdown
    private static String buildCheckDescription(String id, List<String> rules) {
        String rule = StringUtils.pluralize((String)"rule", (int)rules.size());
        String template = "This check includes the following PHPStan %s:\n%s\n\nReferences:\n  - [PHPStan - Error Identifier: %s](https://phpstan.org/error-identifiers/%s)\n";
        return template.formatted(rule, rules.stream().map(text -> "  - " + text).collect(Collectors.joining("\n")), id, id);
    }

    private static List<String> extractRules(Element rulesElement) {
        if (rulesElement == null || !rulesElement.tagName().equals("ul")) {
            return Collections.emptyList();
        }
        ArrayList<String> rules = new ArrayList<String>();
        for (Element child : rulesElement.children()) {
            String text;
            Matcher matcher = RULE_EXTRACTION_PATTERN.matcher(child.text());
            if (!matcher.find() || (text = matcher.group(0).trim()).isEmpty()) continue;
            rules.add(text);
        }
        return rules;
    }

    private static class CheckMappingsFile
    implements AutoCloseable {
        private static final UnmodifiableList<String> HEADER_ENTRIES = CollectionUtils.asUnmodifiable(List.of("ID in Tool", "Readable Name", "Category", "Group", "Default Enablement", "Comments", "Upstream URL"));
        private final Path location;
        private final SortedMap<String, CheckMapping> mappingsById = new TreeMap<String, CheckMapping>();

        private CheckMappingsFile(Path directory) throws IOException {
            this.location = directory.resolve("check-mappings.tsv");
            if (Files.exists(this.location, new LinkOption[0])) {
                try (Stream<String> stream = Files.lines(this.location, StandardCharsets.UTF_8);){
                    this.mappingsById.putAll(stream.skip(1L).map(CheckMapping::fromTsv).collect(Collectors.toMap(CheckMapping::idInTool, Function.identity())));
                }
            }
        }

        @Override
        public void close() throws IOException {
            Files.writeString(this.location, (CharSequence)(String.join((CharSequence)"\t", HEADER_ENTRIES) + "\n"), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.write(this.location, (Iterable<? extends CharSequence>)CollectionUtils.asIterable(() -> this.mappingsById.values().stream().map(CheckMapping::toTsv).iterator()), StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }

        record CheckMapping(String idInTool, String readableName, String category, String group, String defaultEnablement, String comments, String upstreamUrl) {
            private static final Pattern TSV_SEPARATOR = Pattern.compile("\\t");

            public static CheckMapping fromTsv(String tsv) {
                Iterator parts = Stream.concat(TSV_SEPARATOR.splitAsStream(tsv), Stream.generate(() -> "")).iterator();
                return new CheckMapping((String)parts.next(), (String)parts.next(), (String)parts.next(), (String)parts.next(), (String)parts.next(), (String)parts.next(), (String)parts.next());
            }

            public String toTsv() {
                return String.join((CharSequence)"\t", this.idInTool, this.readableName, this.category, this.group, this.defaultEnablement, this.comments, this.upstreamUrl);
            }
        }
    }
}

