/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap.metadata;

import com.teamscale.index.gitbridge.abap.metadata.IAbapGitMetaDataWriter;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.lib.commons.string.StringUtils;

abstract class AbapGitMetaDataWriterBase
implements IAbapGitMetaDataWriter {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("hh:mm:ss").withZone(ZoneId.systemDefault());
    private final String serializer;

    protected AbapGitMetaDataWriterBase() {
        this.serializer = null;
    }

    protected AbapGitMetaDataWriterBase(String serializer) {
        this.serializer = serializer;
    }

    protected AbapGitMetaDataWriterBase(EAbapObjectType objectType) {
        this(String.format("LCL_OBJECT_%s", objectType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(AbapFileMetadata metadata, OutputStream outputStream) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try (XMLStreamWriter writer = outputFactory.createXMLStreamWriter(outputStream);){
            writer.writeStartDocument();
            writer.writeStartElement("abapGit");
            writer.writeAttribute("version", "v1.0.0");
            if (this.serializer != null) {
                writer.writeAttribute("serializer", this.serializer);
                writer.writeAttribute("serializer_version", "v1.0.0");
            }
            writer.writeStartElement("asx:abap");
            writer.writeAttribute("xmlns:asx", "http://www.sap.com/abapxml");
            writer.writeAttribute("version", "1.0");
            writer.writeStartElement("asx:values");
            this.write(metadata, writer);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
    }

    protected abstract void write(AbapFileMetadata var1, XMLStreamWriter var2) throws XMLStreamException;

    protected void writeLeaf(XMLStreamWriter writer, String field, String content) throws XMLStreamException {
        if (content == null) {
            LOGGER.debug("Could not write meta data for {} field because content was null", (Object)field);
            return;
        }
        writer.writeStartElement(field);
        writer.writeCharacters(content);
        writer.writeEndElement();
    }

    protected void writeLeaf(XMLStreamWriter writer, String field, boolean content) throws XMLStreamException {
        this.writeLeaf(writer, field, content ? "X" : "");
    }

    protected void writeDateLeaf(XMLStreamWriter writer, String field, long date) throws XMLStreamException {
        this.writeLeaf(writer, field, AbapGitMetaDataWriterBase.asDateString(date));
    }

    private static String asDateString(long date) {
        if (date == 0L) {
            return "0000-00-00";
        }
        return DATE_FORMATTER.format(Instant.ofEpochMilli(date));
    }

    protected void writeTimeLeaf(XMLStreamWriter writer, String field, long date) throws XMLStreamException {
        this.writeLeaf(writer, field, AbapGitMetaDataWriterBase.asTimeString(date));
    }

    private static String asTimeString(long date) {
        return TIME_FORMATTER.format(Instant.ofEpochMilli(date));
    }

    protected String extractFileName(AbapFileMetadata metadata) {
        return StringUtils.getFirstPart((String)StringUtils.getLastPart((String)metadata.getFilePath(), (String)"/"), (String)".").replace("!", "/").toUpperCase();
    }
}

