/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.merge_request.comments.ReviewCommentResolutionReasonParameters;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class ReviewCommentResolutionReasonProvider {
    private final ReviewCommentResolutionReasonParameters parameters;

    public ReviewCommentResolutionReasonProvider(ReviewCommentResolutionReasonParameters parameters) {
        this.parameters = parameters;
    }

    public String getText(String mainFindingId) throws StorageException {
        return ReviewCommentResolutionReasonProvider.getText(mainFindingId, this.parameters, false);
    }

    public String getMarkdownText(String mainFindingId) throws StorageException {
        return ReviewCommentResolutionReasonProvider.getText(mainFindingId, this.parameters, true);
    }

    private static String getText(String mainFindingId, ReviewCommentResolutionReasonParameters parameters, boolean includeLinks) throws StorageException {
        TrackedFinding finding = parameters.trackedFindingsByIdIndex.getFinding(mainFindingId);
        if (finding == null) {
            return "The finding was resolved by an update to the code.";
        }
        CommitDescriptor deathCommit = finding.getDeathCommit();
        if (deathCommit != null) {
            return ReviewCommentResolutionReasonProvider.createResolvedByCommitText(parameters, deathCommit, includeLinks);
        }
        FindingBlacklistInfo findingBlacklistInfo = parameters.findingBlacklistIndex.getBlacklistInfo(mainFindingId);
        if (findingBlacklistInfo != null) {
            return ReviewCommentResolutionReasonProvider.createResolvedByBlacklistingText(findingBlacklistInfo, parameters);
        }
        return "This finding was aggregated with other similar findings into a new comment.";
    }

    private static String createResolvedByCommitText(ReviewCommentResolutionReasonParameters parameters, CommitDescriptor deathCommit, boolean includeLinks) throws StorageException {
        TeamscaleCommitLinkProvider linkProvider = new TeamscaleCommitLinkProvider(parameters.baseUrl, parameters.publicProjectId, deathCommit.toUnresolvedCommitDescriptor());
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)parameters.logIndex.getEntry(deathCommit);
        StringBuilder sb = new StringBuilder("Resolved in commit ");
        sb.append(logEntry.getRevision());
        if (includeLinks) {
            sb.append(" [(view in Teamscale)](").append(linkProvider.createCommitDetailsLink()).append(")");
        }
        return sb.toString();
    }

    private static String createResolvedByBlacklistingText(FindingBlacklistInfo findingBlacklistInfo, ReviewCommentResolutionReasonParameters parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(switch (findingBlacklistInfo.getType()) {
            default -> throw new MatchException(null, null);
            case EFindingBlacklistType.TOLERATION -> "Tolerated ";
            case EFindingBlacklistType.FALSE_POSITIVE -> "Marked as false positive ";
        });
        parameters.userAliasLookup.resolveUser(findingBlacklistInfo.getUser()).ifPresent(value -> sb.append("by ").append(value.getFullName()));
        if (!StringUtils.isEmpty((String)findingBlacklistInfo.getRationale())) {
            sb.append(": ").append(findingBlacklistInfo.getRationale());
        }
        if (!findingBlacklistInfo.getApprovalState().resolved()) {
            sb.append("\n\n").append("This is subject to review.");
        }
        return sb.toString();
    }
}

