/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import com.teamscale.index.migration.ClassNameMigrator;
import com.teamscale.index.migration.v116_dashboards.V116EProjectPermission;
import com.teamscale.index.migration.v116_dashboards.V116ESubjectType;
import com.teamscale.index.migration.v116_dashboards.V116InternalProjectId;
import com.teamscale.index.migration.v116_dashboards.V116ProjectIdBase;
import com.teamscale.index.migration.v116_dashboards.V116ProjectRole;
import com.teamscale.index.migration.v116_dashboards.V116PublicProjectId;
import com.teamscale.index.migration.v116_dashboards.V116RoleBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrationVersion175EditRetrosPermission
implements IPointwiseStorageMigrator {
    private static final String PERMISSION_INDEX_NAME = "permissions";
    private final ClassNameMigrator permissionClassNameMigrator = new ClassNameMigrator();

    public MigrationVersion175EditRetrosPermission() {
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ESubjectType", V116ESubjectType.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.InternalProjectId", V116InternalProjectId.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.PublicProjectId", V116PublicProjectId.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ProjectIdBase", V116ProjectIdBase.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.ProjectRole", V116ProjectRole.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.EProjectPermission", V116EProjectPermission.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.RoleBase", V116RoleBase.class);
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V175;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public String getStoreName() {
        return PERMISSION_INDEX_NAME;
    }

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        if (!StringUtils.bytesToString((byte[])key).startsWith("PROJECT_ROLE#")) {
            return PairList.from((Object)key, (Object)value);
        }
        V116ProjectRole projectRole = (V116ProjectRole)this.permissionClassNameMigrator.deserialize(LZ4Utils.decompress((byte[])value));
        projectRole.getPermissions().remove((Object)V116EProjectPermission.EDIT_RETROSPECTIVES);
        return PairList.from((Object)key, (Object)LZ4Utils.compress((byte[])this.permissionClassNameMigrator.serialize(projectRole)));
    }
}

