/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.naming;

import com.teamscale.index.naming.ENamingConventionTokenClass;
import com.teamscale.index.naming.NamingConventionAnalyzer;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class PhpNamingConventionAnalyzer
extends NamingConventionAnalyzer {
    private static final UnmodifiableSet<String> PHP_MAGIC_FUNCTIONS = CollectionUtils.asUnmodifiable(Set.of("__construct", "__destruct", "__call", "__callStatic", "__get", "__set", "__isset", "__unset", "__sleep", "__wakeup", "__toString", "__invoke", "__set_state", "__clone", "__debugInfo"));

    public PhpNamingConventionAnalyzer() {
        super(ELanguage.PHP);
    }

    @Override
    protected void checkMethodParameters(TokenElementInfo element, ShallowEntity entity) {
        List variableTokens = ShallowParsingUtils.extractVariableNameTokens((List)TokenStreamUtils.tokensBetween((List)entity.ownStartTokens(), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN));
        for (IToken token : variableTokens) {
            this.checkTokenName(element, token, ENamingConventionTokenClass.METHOD_PARAMETERS);
        }
    }

    @Override
    protected boolean isIgnoredMethodType(ShallowEntity entity) {
        return entity.getName() != null && StringUtils.containsOneOf((String)entity.getName(), PHP_MAGIC_FUNCTIONS);
    }

    @Override
    protected void checkStatement(TokenElementInfo element, ShallowEntity entity) {
        if (!entity.getSubtype().equals("local variable")) {
            super.checkStatement(element, entity);
            return;
        }
        for (IToken token : ShallowParsingUtils.extractVariableNameTokens((List)entity.includedTokens())) {
            if (PhpNamingConventionAnalyzer.isGlobal(entity) && this.isConstant(entity)) {
                this.checkTokenName(element, token, ENamingConventionTokenClass.CONSTANTS);
                continue;
            }
            if (PhpNamingConventionAnalyzer.isGlobal(entity)) {
                this.checkTokenName(element, token, ENamingConventionTokenClass.GLOBAL_VARIABLES);
                continue;
            }
            this.checkTokenName(element, token, ENamingConventionTokenClass.LOCAL_VARIABLES);
        }
    }
}

