/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.testwise_coverage;

import com.teamscale.commons.utils.StringPool;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.TestInfoContainer;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestInfo;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestParameter;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestwiseCoverageReport;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public interface TestInfoContainerBuilder {
    public void build(TestwiseCoverageReport var1) throws StorageException, ReportParserException;

    default public TestInfoContainer createTestwiseCoverageInfo(TestInfo test, CoverageInfoRetriever coverageInfoRetriever, boolean partOfPartialReport, @Nullable String executionUnit) {
        Object testPath = test.uniformPath.trim();
        if (executionUnit != null) {
            testPath = StringUtils.stripPrefix((String)executionUnit, (String)(UniformPath.EType.EXECUTION_UNIT.getPrefix() + UniformPathUtils.SEPARATOR)) + UniformPathUtils.SEPARATOR + (String)testPath;
        }
        testPath = TestInfoContainerBuilder.appendParameters((String)testPath, test.parameters);
        UniformPath testExecutionPath = TestUniformPathUtils.escapeAndConvertToTestExecutionUniformPath((String)testPath);
        TestInfoContainer testwiseCoverageInfo = coverageInfoRetriever.createTestwiseCoverageInfo(StringPool.intern((String)testExecutionPath.toString()));
        testwiseCoverageInfo.setPartOfPartialReport(partOfPartialReport);
        testwiseCoverageInfo.setTestLocations(test.testLocations);
        return testwiseCoverageInfo;
    }

    @VisibleForTesting
    public static String appendParameters(String testPath, @Nullable List<TestParameter> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return testPath;
        }
        return testPath + "[" + parameters.stream().map(TestParameter::toString).collect(Collectors.joining(", ")) + "]";
    }
}

