/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.index.CommitAssociationIndexBase;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.issue_reference.CodeToReferenceMappingSynchronizerBase;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public abstract class RepositoryCommitMappingSynchronizerBase
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryLogIndex repositoryLogIndex;
    @DeltaSource(value=RepositoryLogIndex.class)
    private KeyDelta delta;

    protected abstract SetMap<CommitDescriptor, String> processLogEntries(List<RepositoryLogEntryAggregate> var1) throws ConQATException;

    public void execute() throws ConQATException {
        SetMap<CommitDescriptor, String> commitsToIds;
        List<RepositoryLogEntryAggregate> logEntries = this.getRelevantLogEntries();
        if (!logEntries.isEmpty() && !(commitsToIds = this.processLogEntries(logEntries)).isEmpty()) {
            this.storeMapping(commitsToIds);
        }
    }

    private @NonNull List<RepositoryLogEntryAggregate> getRelevantLogEntries() throws StorageException {
        List<CommitDescriptor> commits = CommitAssociationIndexBase.deltaToCommits((KeyDelta)this.delta).stream().filter(commit -> !PreCommitUtils.isPrecommitBranch((String)commit.getBranchName())).toList();
        if (commits.isEmpty()) {
            return List.of();
        }
        return this.repositoryLogIndex.getEntries(commits).stream().filter(Objects::nonNull).filter(RepositoryCommitMappingSynchronizerBase::shouldBeMappedToIds).toList();
    }

    private static boolean shouldBeMappedToIds(RepositoryLogEntryAggregate entry) {
        return !entry.getRevision().startsWith("EA:") && !entry.getAuthor().equals("Teamscale import");
    }

    protected SetMap<CommitDescriptor, String> mapCommitsToIssueIds(Collection<RepositoryLogEntryAggregate> logEntries, Pattern pattern) throws ConQATException {
        SetMap commitsToIds = new SetMap();
        if (pattern.pattern().isEmpty()) {
            return commitsToIds;
        }
        for (RepositoryLogEntryAggregate entry : logEntries) {
            String message = entry.getMessage();
            if (StringUtils.isEmpty((String)message)) continue;
            Matcher matcher = pattern.matcher(message);
            CodeToReferenceMappingSynchronizerBase.getGroupMatches(matcher).keySet().stream().map(this::transform).forEach(issueId -> commitsToIds.add((Object)entry.getCommit(), issueId));
        }
        return commitsToIds;
    }

    protected abstract void storeMapping(SetMap<CommitDescriptor, String> var1) throws StorageException;

    protected String transform(String id) {
        return id.toUpperCase();
    }
}

