/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem.multiversion;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.filesystem.FileSystemFilesRetriever;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemCommit;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemRepositoryConnectorDescriptor;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public final class MultiVersionFileSystemFilesRetriever
extends FileSystemFilesRetriever {
    public MultiVersionFileSystemFilesRetriever(@NonNull ServerOptionIndex serverOptionIndex, @NonNull ConnectorConfiguration connectorConfiguration) {
        super(serverOptionIndex, connectorConfiguration);
    }

    @Override
    protected Optional<String> getInputDirectory(ConnectorConfiguration connectorConfiguration) throws RepositoryException {
        String inputDirectory = Objects.requireNonNull(connectorConfiguration.getOptionValue("Input directory"));
        String defaultBranchName = Objects.requireNonNull(connectorConfiguration.getOptionValue("Default branch name"));
        List<String> directoryNames = MultiVersionFileSystemRepositoryConnectorDescriptor.getRevisionDirectoryNames(new File(inputDirectory));
        if (directoryNames.isEmpty()) {
            return Optional.empty();
        }
        List allCommits = CollectionUtils.mapWithException(directoryNames, name -> new MultiVersionFileSystemCommit((String)name, defaultBranchName));
        List filteredCommits = CollectionUtils.filter((Collection)allCommits, commit -> defaultBranchName.equals(commit.getBranchName()));
        if (filteredCommits.isEmpty()) {
            return Optional.empty();
        }
        MultiVersionFileSystemCommit latestCommit = (MultiVersionFileSystemCommit)Collections.max(filteredCommits);
        return Optional.of(StringUtils.ensureEndsWith((String)inputDirectory, (String)"/") + latestCommit.getDirectoryName());
    }
}

