/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.NonNull;

public class PlatformRepositoryIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="owner")
    private final @NonNull String owner;
    @JsonProperty(value="repo")
    private final @NonNull String repo;

    public PlatformRepositoryIdentifier(@NonNull String owner, @NonNull String repo) {
        this.owner = owner;
        this.repo = repo;
    }

    public static PlatformRepositoryIdentifier fromRepositoryName(String repositoryName) {
        String[] parts = repositoryName.split("/");
        CCSMAssert.isTrue((parts.length == 2 ? 1 : 0) != 0, () -> "Invalid repository name '" + repositoryName + "': not in the form '[^/]+/[^/]+'.");
        return new PlatformRepositoryIdentifier(parts[0], parts[1]);
    }

    public static <X extends Exception> PlatformRepositoryIdentifier fromRepositoryName(String repositoryName, Function<String, X> exceptionFactory) throws X {
        String[] parts = repositoryName.split("/");
        if (parts.length != 2) {
            throw (Exception)exceptionFactory.apply("Invalid repository name '" + repositoryName + "': Expected name cannot be empty and must contain exactly one slash.");
        }
        return new PlatformRepositoryIdentifier(parts[0], parts[1]);
    }

    public static <X extends Exception> PlatformRepositoryIdentifier fromMergeRequest(MergeRequestIdentifier mergeRequestIdentifier, Function<String, X> exceptionFactory) throws X {
        return PlatformRepositoryIdentifier.fromRepositoryName(mergeRequestIdentifier.repositoryName(), exceptionFactory);
    }

    public String asRepositoryName() {
        return this.owner + "/" + this.repo;
    }

    public String asNormalizedRepositoryName() {
        return this.owner.toLowerCase() + "/" + this.repo.toLowerCase();
    }

    public @NonNull String getOwner() {
        return this.owner;
    }

    public @NonNull String getRepo() {
        return this.repo;
    }

    public String toString() {
        return this.asRepositoryName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlatformRepositoryIdentifier)) {
            return false;
        }
        PlatformRepositoryIdentifier that = (PlatformRepositoryIdentifier)o;
        return this.asNormalizedRepositoryName().equals(that.asNormalizedRepositoryName());
    }

    public int hashCode() {
        return Objects.hash(this.asNormalizedRepositoryName());
    }
}

