/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.google.common.primitives.Ints;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.CollectionOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.BadgesConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.IBadgeConfigurationEntry;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgesConfiguration;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfiguration;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.merge_request.comments.RepositoryPathMapper;
import com.teamscale.index.merge_request.testcoverage.LineCoverageChange;
import com.teamscale.index.merge_request.testcoverage.TestCoverageDeltaInfo;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.ExternalUploadsVotingCondition;
import com.teamscale.index.repository.git.common.TestingIntegrationRequirementsChecker;
import com.teamscale.index.repository.git.common.VoteSupportingGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.WebHookBasedGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.voting_info.LineCoverageVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.TestGapVotingInfo;
import com.teamscale.index.requirements_tracing.merge_request.ImpactedSpecItemsDelta;
import com.teamscale.index.requirements_tracing.merge_request.MergeRequestImpactedSpecItemsCalculator;
import com.teamscale.index.requirements_tracing.merge_request.MergeRequestImpactedSpecItemsCalculatorIndexes;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.wia.SpecItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.IncludeExcludePatternSupportBase;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.FindingDelta;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class VotingConnectorUtils {
    public static ImpactedSpecItemsDelta determineImpactedSpecItemDelta(MergeBaseInfo mergeBaseInfo, CommitDescriptor sourceCommit, String repositoryIdentifier, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
        MergeRequestImpactedSpecItemsCalculatorIndexes mergeRequestImpactedSpecItemsCalculatorIndexes = new MergeRequestImpactedSpecItemsCalculatorIndexes(sourceCommit, mergeBaseInfo, projectStorageSystem, globalStorageSystem, parallelTaskExecutor);
        WorkItemHistoryIndexAggregation<SpecItem> specItemHistoryIndex = mergeRequestImpactedSpecItemsCalculatorIndexes.getSpecItemHistoryIndex();
        if (!mergeRequestImpactedSpecItemsCalculatorIndexes.specItemReferencesPresentInCodeBase() || specItemHistoryIndex.getAllIds().isEmpty()) {
            return new ImpactedSpecItemsDelta();
        }
        List<String> affectedUniformPaths = VotingConnectorUtils.getAffectedUniformPaths(sourceCommit, mergeBaseInfo, repositoryIdentifier, projectStorageSystem);
        MergeRequestImpactedSpecItemsCalculator mergeRequestImpactedSpecItemsCalculator = new MergeRequestImpactedSpecItemsCalculator(mergeRequestImpactedSpecItemsCalculatorIndexes, affectedUniformPaths);
        return mergeRequestImpactedSpecItemsCalculator.calculateDelta();
    }

    private static List<String> getAffectedUniformPaths(CommitDescriptor sourceCommit, MergeBaseInfo mergeBaseInfo, String repositoryIdentifier, ProjectStorageSystem projectStorageSystem) throws StorageException {
        List<RepositoryLogFileEntry> logFileEntries = MergeRequestUtils.determineRepositoryLogFileEntriesInMergeRequest((RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null), (RepositoryLogFileIndex)projectStorageSystem.openProjectIndex(RepositoryLogFileIndex.class, null), mergeBaseInfo);
        List<String> affectedUniformPaths = logFileEntries.stream().map(RepositoryLogFileEntry::getUniformPath).map(UniformPath::toStringAsMigrationFrontier).distinct().collect(Collectors.toList());
        RepositoryOriginalPathIndex originalPathIndex = (RepositoryOriginalPathIndex)projectStorageSystem.openProjectIndex(RepositoryOriginalPathIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)sourceCommit));
        RepositoryOriginalPathIndex.RepositoryOriginalPathView originalPathView = originalPathIndex.createView(repositoryIdentifier);
        RepositoryPathMapper repositoryPathMapper = new RepositoryPathMapper(originalPathView, new HashSet<String>(affectedUniformPaths));
        affectedUniformPaths.removeIf(uniformPath -> !repositoryPathMapper.isKnownPath((String)uniformPath));
        return affectedUniformPaths;
    }

    public static boolean projectHasRequirementsConnector(MetaIndex metaIndex, Logger logger) {
        try {
            return ((ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class)).getConnectors().stream().map(ConnectorConfiguration::getRequirementsManagementToolType).anyMatch(Optional::isPresent);
        }
        catch (StorageException e) {
            logger.error("Error retrieving project configuration, assuming no requirements connector exists.", (Throwable)e);
            return false;
        }
    }

    public static FindingDelta filterFindingsOfOtherRepositories(ProjectStorageSystem projectStorageSystem, CommitDescriptor sourceCommit, MergeBaseInfo mergeBaseInfo, FindingDelta unfilteredFindingDelta, String repositoryId) throws StorageException {
        CommitDescriptor startCommit = mergeBaseInfo.getBranchPoint().orElse(mergeBaseInfo.getMergeBase());
        RepositoryPathMapper repositoryPathMapper = VotingConnectorUtils.createRepositoryPathMapper(projectStorageSystem, sourceCommit, startCommit, unfilteredFindingDelta, repositoryId);
        List<TrackedFinding> addedFindings = repositoryPathMapper.removeFindingsWithUnknownPaths(unfilteredFindingDelta.getAddedFindings());
        List<TrackedFinding> findingsInChangedCode = repositoryPathMapper.removeFindingsWithUnknownPaths(unfilteredFindingDelta.getFindingsInChangedCode());
        List<TrackedFinding> removedFindings = repositoryPathMapper.removeFindingsWithUnknownPaths(unfilteredFindingDelta.getRemovedFindings());
        return FindingDelta.create(addedFindings, findingsInChangedCode, removedFindings);
    }

    private static RepositoryPathMapper createRepositoryPathMapper(ProjectStorageSystem projectStorageSystem, CommitDescriptor sourceCommit, CommitDescriptor startCommit, FindingDelta unfilteredFindingDelta, String repositoryId) throws StorageException {
        RepositoryOriginalPathIndex sourceOriginalPathIndex = (RepositoryOriginalPathIndex)projectStorageSystem.openProjectIndex(RepositoryOriginalPathIndex.class, HistoryAccessOption.readTimestamp((String)sourceCommit.getBranchName(), (long)sourceCommit.getTimestamp()));
        RepositoryOriginalPathIndex.RepositoryOriginalPathView sourceOriginalPathView = sourceOriginalPathIndex.createView(repositoryId);
        RepositoryOriginalPathIndex startOriginalPathIndex = (RepositoryOriginalPathIndex)projectStorageSystem.openProjectIndex(RepositoryOriginalPathIndex.class, HistoryAccessOption.readTimestamp((String)startCommit.getBranchName(), (long)startCommit.getTimestamp()));
        RepositoryOriginalPathIndex.RepositoryOriginalPathView startOriginalPathView = startOriginalPathIndex.createView(repositoryId);
        HashSet<String> allUniformPaths = new HashSet<String>();
        allUniformPaths.addAll(CollectionUtils.map((Collection)unfilteredFindingDelta.getAddedFindings(), finding -> finding.getLocation().getUniformPath()));
        allUniformPaths.addAll(CollectionUtils.map((Collection)unfilteredFindingDelta.getFindingsInChangedCode(), finding -> finding.getLocation().getUniformPath()));
        allUniformPaths.addAll(CollectionUtils.map((Collection)unfilteredFindingDelta.getRemovedFindings(), finding -> finding.getLocation().getUniformPath()));
        return new RepositoryPathMapper(sourceOriginalPathView, startOriginalPathView, allUniformPaths);
    }

    public static boolean hasMergeRequestIntegrationEnabled(ProjectConfiguration projectConfiguration) {
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            if (!VoteSupportingGitRepositoryConnectorDescriptorBase.hasMergeRequestIntegrationEnabled(connector)) continue;
            return true;
        }
        return false;
    }

    public static IncludeExcludeAntPatternSupport getOnFileVoteIncludeExcludePatterns(ConnectorConfiguration connector) {
        String includeListString = connector.getOptionValue("Vote Include Patterns");
        String excludeListString = connector.getOptionValue("Vote Exclude Patterns");
        return VotingConnectorUtils.getIncludeExcludePatternSupport(includeListString, excludeListString, new IncludeExcludeAntPatternSupport());
    }

    public static IncludeExcludeRegexSupport getOnBranchVoteIncludeExcludePatterns(ConnectorConfiguration connector) {
        String includeListString = connector.getOptionValue("Included branches");
        String excludeListString = connector.getOptionValue("Excluded branches");
        return VotingConnectorUtils.getIncludeExcludePatternSupport(includeListString, excludeListString, new IncludeExcludeRegexSupport());
    }

    public static IncludeExcludeRegexSupport getBuildIncludeExcludePatterns(ConnectorConfiguration connector) {
        IncludeExcludeRegexSupport includeExcludePatternSupport = new IncludeExcludeRegexSupport();
        String includeListString = connector.getOptionValue("Included build jobs");
        String excludeListString = connector.getOptionValue("Excluded build jobs");
        VotingConnectorUtils.addIncludeExcludePattern(includeListString, excludeListString, includeExcludePatternSupport);
        return includeExcludePatternSupport;
    }

    private static <T extends IncludeExcludePatternSupportBase> T getIncludeExcludePatternSupport(String includeListString, String excludeListString, T includeExcludePatterns) {
        VotingConnectorUtils.addIncludeExcludePattern(includeListString, excludeListString, includeExcludePatterns);
        if (includeExcludePatterns.getIncludePatterns().isEmpty()) {
            includeExcludePatterns.addMatchAllIncludePattern();
        }
        return includeExcludePatterns;
    }

    private static <T extends IncludeExcludePatternSupportBase> void addIncludeExcludePattern(String includeListString, String excludeListString, T includeExcludePatternSupport) {
        if (!StringUtils.isEmpty((String)includeListString)) {
            CollectionOptionDescriptorBase.parseStringToListOfStrings((String)includeListString).forEach(arg_0 -> includeExcludePatternSupport.addIncludePattern(arg_0));
        }
        if (!StringUtils.isEmpty((String)excludeListString)) {
            CollectionOptionDescriptorBase.parseStringToListOfStrings((String)excludeListString).forEach(arg_0 -> includeExcludePatternSupport.addExcludePattern(arg_0));
        }
    }

    public static CommitVotingTriggerBase.EFindingsBadgePosition getFindingsBadgePosition(ConnectorConfiguration connector) {
        String optionValue = connector.getOptionValue("Findings badge position");
        if (optionValue == null) {
            return WebHookBasedGitRepositoryConnectorDescriptorBase.FINDINGS_BADGE_POSITION_DEFAULT;
        }
        return Enum.valueOf(CommitVotingTriggerBase.EFindingsBadgePosition.class, optionValue);
    }

    public static int getDetailedLineCommentsLimitForFindings(ConnectorConfiguration connector) {
        return VotingConnectorUtils.getDetailedLineCommentsLimit(connector, "Detailed Line Comments Limit for Findings");
    }

    public static int getDetailedLineCommentsLimitForTestGaps(ConnectorConfiguration connector) {
        return VotingConnectorUtils.getDetailedLineCommentsLimit(connector, "Limit for Test Gap Comments");
    }

    private static int getDetailedLineCommentsLimit(ConnectorConfiguration connector, String optionName) {
        String commentLimit = connector.getOptionValue(optionName);
        Optional<Integer> limit = Optional.ofNullable(commentLimit).map(Ints::tryParse);
        return limit.orElse(Integer.MAX_VALUE);
    }

    public static TestGapVotingInfo computeTestGapVotingInfo(ProjectStorageSystem projectStorageSystem, @Nullable ExternalUploadsVotingCondition externalUploadsVotingCondition, CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult = VotingConnectorUtils.checkTestGapVotingRequirements(projectStorageSystem, externalUploadsVotingCondition, schedulingParameters, input);
        return VotingConnectorUtils.computeTestGapVotingInfo(votingRequirementsCheckerResult, schedulingParameters, input);
    }

    public static TestGapVotingInfo computeTestGapVotingInfo(TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult, CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) {
        boolean ignoreYellowTestGaps = CcpIntegrationFeatureEnablements.isIgnoreYellowTestGapsForVotingEnabled(schedulingParameters.connector());
        if (input.testGapInfo == null || votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.TEST_GAP_VOTING_DISABLED) {
            return new TestGapVotingInfo(votingRequirementsCheckerResult, true, (List<AssessedTgaData.AssessedMethodData>)CollectionUtils.emptyList(), (List<AssessedTgaData.AssessedMethodData>)CollectionUtils.emptyList(), ignoreYellowTestGaps, input.mergeRequest.identifier);
        }
        Map<ETestGapState, List<AssessedTgaData.AssessedMethodData>> untestedMethodsByState = input.testGapInfo.untestedMethods().stream().collect(Collectors.groupingBy(AssessedTgaData.AssessedMethodData::getTestGapState));
        boolean hasChangedMethods = !input.testGapInfo.allChangedMethods().isEmpty();
        return new TestGapVotingInfo(votingRequirementsCheckerResult, hasChangedMethods, untestedMethodsByState.getOrDefault((Object)ETestGapState.UNTESTED_ADDITION, (List<AssessedTgaData.AssessedMethodData>)CollectionUtils.emptyList()), untestedMethodsByState.getOrDefault((Object)ETestGapState.UNTESTED_CHANGE, (List<AssessedTgaData.AssessedMethodData>)CollectionUtils.emptyList()), ignoreYellowTestGaps, input.mergeRequest.identifier);
    }

    public static LineCoverageVotingInfo computeLineCoverageVotingInfo(ProjectStorageSystem projectStorageSystem, @Nullable ExternalUploadsVotingCondition externalUploadsVotingCondition, CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult = VotingConnectorUtils.checkTestCoverageVotingRequirements(projectStorageSystem, externalUploadsVotingCondition, schedulingParameters, input);
        if (input.testCoverageDeltaInfo == null) {
            return new LineCoverageVotingInfo(votingRequirementsCheckerResult, true, 0.0, 100.0, Collections.emptyList(), input.mergeRequest.identifier);
        }
        return VotingConnectorUtils.computeLineCoverageVotingInfo(input.testCoverageDeltaInfo, votingRequirementsCheckerResult, input.mergeRequest.identifier);
    }

    public static LineCoverageVotingInfo computeLineCoverageVotingInfoWithoutRequirementsCheck(@NonNull TestCoverageDeltaInfo coverageDeltaInfo, MergeRequestIdentifier mergeRequestIdentifier) {
        return VotingConnectorUtils.computeLineCoverageVotingInfo(coverageDeltaInfo, TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.SUCCESS, mergeRequestIdentifier);
    }

    private static LineCoverageVotingInfo computeLineCoverageVotingInfo(TestCoverageDeltaInfo coverageDeltaInfo, TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult, MergeRequestIdentifier mergeRequestIdentifier) {
        int coverableLines = 0;
        int coveredLines = 0;
        for (LineCoverageChange lineCoverageChange : coverageDeltaInfo.lineCoverageChanges()) {
            coverableLines += lineCoverageChange.numberOfAddedOrChangedCoverableLines();
            coveredLines += lineCoverageChange.numberOfAddedOrChangedCoveredLines();
        }
        double thresholdPercent = coverageDeltaInfo.lineCoverageThreshold() * 100.0;
        double coveragePercent = 100.0 * LineCoverageInfo.calculateCoverageRatio((int)coveredLines, (int)coverableLines);
        return new LineCoverageVotingInfo(votingRequirementsCheckerResult, coverableLines != 0, coveragePercent, thresholdPercent, coverageDeltaInfo.lineCoverageChanges(), mergeRequestIdentifier);
    }

    public static TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult checkTestGapVotingRequirements(ProjectStorageSystem projectStorageSystem, @Nullable ExternalUploadsVotingCondition externalUploadsVotingCondition, CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        return new TestingIntegrationRequirementsChecker(projectStorageSystem, schedulingParameters.schedulingCommit(), externalUploadsVotingCondition).checkTestGapVotingRequirements(schedulingParameters, input);
    }

    public static TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult checkTestCoverageVotingRequirements(ProjectStorageSystem projectStorageSystem, @Nullable ExternalUploadsVotingCondition externalUploadsVotingCondition, CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        return new TestingIntegrationRequirementsChecker(projectStorageSystem, schedulingParameters.schedulingCommit(), externalUploadsVotingCondition).checkTestCoverageVotingRequirements(schedulingParameters, input);
    }

    public static MetricBadgesConfiguration getMetricBadgesConfiguration(ConnectorConfiguration connector, String optionName) throws JsonSerializationException {
        return (MetricBadgesConfiguration)VotingConnectorUtils.getBadgesConfiguration(connector, optionName);
    }

    public static CriticalChangeBadgesConfiguration getCriticalChangeBadgesConfiguration(ConnectorConfiguration connector) throws ProjectConfigurationException {
        try {
            return (CriticalChangeBadgesConfiguration)VotingConnectorUtils.getBadgesConfiguration(connector, "Badges for Critical Changes");
        }
        catch (JsonSerializationException e) {
            throw new ProjectConfigurationException("Failed to parse metric badges configuration of option '%s' in connector '%s'.".formatted("Badges for Critical Changes", connector.getIdentifier()), (Throwable)e);
        }
    }

    private static BadgesConfigurationBase<? extends IBadgeConfigurationEntry> getBadgesConfiguration(ConnectorConfiguration connector, String optionName) throws JsonSerializationException {
        String optionValue = connector.getOptionValue(optionName);
        if (optionValue == null) {
            return switch (optionName) {
                case "Badges for Metrics", "Badges for Metric Groups" -> new MetricBadgesConfiguration();
                case "Badges for Critical Changes" -> new CriticalChangeBadgesConfiguration();
                default -> throw new UnsupportedOperationException();
            };
        }
        return switch (optionName) {
            case "Badges for Metrics", "Badges for Metric Groups" -> (MetricBadgesConfiguration)JsonUtils.deserializeFromJson((String)optionValue, MetricBadgesConfiguration.class);
            case "Badges for Critical Changes" -> (CriticalChangeBadgesConfiguration)JsonUtils.deserializeFromJson((String)optionValue, CriticalChangeBadgesConfiguration.class);
            default -> throw new UnsupportedOperationException();
        };
    }

    public static boolean isVotingConnector(ConnectorConfiguration connectorConfiguration) {
        return connectorConfiguration.getRepositoryType().map(type -> switch (type) {
            default -> throw new MatchException(null, null);
            case ERepositoryConnector.ABAP_GIT, ERepositoryConnector.ARTIFACTORY, ERepositoryConnector.FILE_SYSTEM, ERepositoryConnector.GIT, ERepositoryConnector.MULTI_VERSION_FILE_SYSTEM, ERepositoryConnector.SVN, ERepositoryConnector.S3, ERepositoryConnector.TFS -> false;
            case ERepositoryConnector.ARTIFICIAL_MERGE_REQUEST, ERepositoryConnector.AZURE_DEVOPS_GIT, ERepositoryConnector.BITBUCKET, ERepositoryConnector.BITBUCKET_SERVER, ERepositoryConnector.GERRIT, ERepositoryConnector.GITEA, ERepositoryConnector.GITHUB, ERepositoryConnector.GITLAB, ERepositoryConnector.SCM_MANAGER -> true;
        }).orElse(false);
    }

    private VotingConnectorUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

