/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.merge_request.MergeRequestDeltaIndex;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import java.util.function.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public class GerritIndexParameters {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public CommitDescriptorIndex commitDescriptorIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public RepositoryLogIndex repositoryLogIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public RepositoryLogFileIndex repositoryLogFileIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public FindingChurnListIndex findingChurnListIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public FindingBlacklistIndex findingBlacklistIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    public MergeRequestIndex mergeRequestIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    public MergeRequestDeltaIndex mergeRequestDeltaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public MetaIndex metaIndex;
    private ProjectStorageSystem projectStorageSystem;
    private GlobalStorageSystem globalStorageSystem;
    private final Supplier<IParallelTaskExecutor> parallelTaskExecutor;
    @BranchingLayerAccess(value=ElementHistoryIndex.class)
    private IBranchingLayer elementHistoryBranchingLayer;

    public GerritIndexParameters(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, HistoryAccessOption historyAccessOption, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
        this.commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        this.repositoryLogIndex = (RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        this.repositoryLogFileIndex = (RepositoryLogFileIndex)projectStorageSystem.openProjectIndex(RepositoryLogFileIndex.class, null);
        this.findingChurnListIndex = (FindingChurnListIndex)projectStorageSystem.openProjectIndex(FindingChurnListIndex.class, null);
        this.findingBlacklistIndex = (FindingBlacklistIndex)projectStorageSystem.openProjectIndex(FindingBlacklistIndex.class, historyAccessOption);
        this.mergeRequestIndex = (MergeRequestIndex)projectStorageSystem.openProjectIndex(MergeRequestIndex.class, null);
        this.mergeRequestDeltaIndex = (MergeRequestDeltaIndex)projectStorageSystem.openProjectIndex(MergeRequestDeltaIndex.class, null);
        this.elementHistoryBranchingLayer = projectStorageSystem.openBranchingLayer(ElementHistoryIndex.class);
        this.metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        this.projectStorageSystem = projectStorageSystem;
        this.globalStorageSystem = globalStorageSystem;
        this.parallelTaskExecutor = () -> parallelTaskExecutor;
    }

    public GerritIndexParameters(Supplier<IParallelTaskExecutor> parallelTaskExecutor) {
        this.parallelTaskExecutor = parallelTaskExecutor;
    }

    public ElementHistoryIndex openElementHistoryIndex(CommitDescriptor commit) throws StorageException {
        HistoryAccessOption accessOption = HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
        IStore storeWithAccessOption = this.elementHistoryBranchingLayer.openStore(accessOption);
        return new ElementHistoryIndex(storeWithAccessOption);
    }

    public ProjectStorageSystem getProjectStorageSystem() {
        return this.projectStorageSystem;
    }

    public GlobalStorageSystem getGlobalStorageSystem() {
        return this.globalStorageSystem;
    }

    public IParallelTaskExecutor getParallelTaskExecutor() {
        return this.parallelTaskExecutor.get();
    }
}

