/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sca.jfrog;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.repository.sca.IgnoreViolationRequest;
import com.teamscale.index.repository.sca.NameWithVersion;
import com.teamscale.index.repository.sca.jfrog.JFrogClasses;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.ResponseBody;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class JfrogXrayClient {
    private final RJFrogRetrofitApi jfrogApi;

    public JfrogXrayClient(String baseUri, String authToken) {
        Objects.requireNonNull(baseUri);
        Objects.requireNonNull(authToken);
        baseUri = StringUtils.stripSuffix((String)baseUri, (String)"/xray");
        CCSMAssert.isTrue((StringUtils.stripSuffix((String)baseUri, (String)"/").endsWith(".jfrog.io") || baseUri.contains("://localhost") ? 1 : 0) != 0, (String)"Client can only be used with jfrog.io (cloud instance)");
        this.jfrogApi = (RJFrogRetrofitApi)Retrofit.builder((String)baseUri).withBearerAuthentication(authToken).build().create(RJFrogRetrofitApi.class);
    }

    public static String determineXrayApiProjectKey(@Nullable String projectKey) {
        if (projectKey == null || projectKey.equals("artifactory")) {
            return "";
        }
        return projectKey;
    }

    public RJFrogRetrofitApi getClient() throws IOException {
        return this.jfrogApi;
    }

    public static interface RJFrogRetrofitApi
    extends IRetrofitApi {
        @GET(value="xray/api/v1/builds?limit=200")
        public Call<BuildsResponse> getXrayBuilds(@Query(value="offset") Integer var1, @Query(value="projectKey") String var2);

        @GET(value="xray/api/v2/summary/build")
        public Call<JFrogClasses.BuildSummary> getBuildSummary(@Query(value="build_name") String var1, @Query(value="build_number") String var2, @Query(value="build_repo") String var3, @Query(value="projectKey") String var4);

        @GET(value="xray/api/v1/builds/{buildName}/versions?base64id=true&num_of_rows=100")
        public Call<BuildsVersionsResponse> getBuildVersions(@Path(value="buildName") String var1, @Query(value="build_repository") String var2, @Query(value="offset") int var3, @Query(value="projectKey") String var4);

        @POST(value="xray/ui/unified/userIssues/details?direction=desc&order_by=updated")
        public Call<JFrogClasses.XrayListResponse<XrayViolation>> getAllViolations(@Body ViolationFilter var1, @Query(value="page_num") int var2, @Query(value="num_of_rows") int var3, @Query(value="projectKey") String var4);

        @GET(value="xray/api/v1/ignore_rules")
        public Call<JFrogClasses.IgnoreRulesResponse> getIgnoreRules(@Query(value="projectKey") @Nullable String var1);

        @POST(value="xray/api/v1/ignore_rules")
        @Headers(value={"Content-Type: application/json"})
        public Call<ResponseBody> createIgnoreRule(@Body IgnoreRuleRequest var1);

        @GET(value="artifactory/api/build/{buildName}/{buildNumber}")
        public Call<JFrogClasses.BuildDetails> getBuildDetails(@Path(value="buildName") String var1, @Path(value="buildNumber") String var2, @Query(value="project") String var3);

        @DELETE(value="xray/api/v1/ignore_rules/{ruleId}")
        @Headers(value={"Content-Type: application/json"})
        public Call<ResponseBody> deleteIgnoreRule(@Path(value="ruleId") String var1);

        @POST(value="xray/api/v2/ci/build")
        @Headers(value={"Content-Type: application/json"})
        public Call<ResponseBody> triggerRescanOfBuild(@Body BuildRescanRequest var1);

        default public Call<JFrogClasses.XrayListResponse<XrayViolation>> getAllViolations(ViolationFilter body, int page1Based, String projectKey) {
            return this.getAllViolations(body, page1Based, 1000, projectKey);
        }
    }

    public record BuildRescanRequest(@JsonProperty(value="build_name") String buildName, @JsonProperty(value="build_number") String buildVersion, @JsonProperty(value="project") @Nullable String project, @JsonProperty(value="rescan") boolean rescan) {
    }

    public record ViolationFilter(@JsonProperty(value="package_id") String packageId, String version) {
        public static ViolationFilter forBuild(String buildName, String buildVersion, @Nullable String buildRepositoryForXrayProject) {
            String buildPrefix = "build://";
            if (StringUtils.isEmpty((String)buildRepositoryForXrayProject) || buildRepositoryForXrayProject.equals("artifactory-build-info")) {
                return new ViolationFilter(buildPrefix + buildName, buildVersion);
            }
            return new ViolationFilter(buildPrefix + "[" + buildRepositoryForXrayProject + "]/" + buildName, buildVersion);
        }
    }

    public record XrayViolation(String user_issue_id, String comp_id, String component_package_type, String comp_name, String comp_version, String type, List<ViolationTarget> targets, String issue_id, List<String> paths, String watcher_id, String watcher_name, List<MatchedPolicy> matched_policies, String summary, String severity, String updated, Permissions permissions, boolean is_source_root, boolean is_high_profile, String title, ApplicabilityDetail applicability_detail, boolean is_exposures_issue, boolean is_package_issue, List<XrayComponent> sources, boolean sources_were_purged) {

        public record Permissions(boolean manageable) {
        }

        public record ApplicabilityDetail(String component_id, String source_comp_id, String vulnerability_id, String result) {
        }

        public record XrayComponent(String source, String source_version, String source_id, boolean is_ignored) {
        }

        public record MatchedPolicy(String policy, String rule, boolean is_blocking, int blocking_mask, boolean is_skip_not_applicable) {
        }

        public record ViolationTarget(String type, String name, String bin_mgr_id, Object filters, String repo_type, Map<String, Object> permissions) {
        }
    }

    public record BuildsVersionsResponse(@Nullable List<JFrogClasses.XrayBuildVersion> data, int offset) {
    }

    public record BuildsResponse(@Nullable List<JFrogClasses.XrayBuildInfo> data, int offset) {
    }

    public record IgnoreRuleRequest(@JsonProperty(value="notes") String notes, @JsonProperty(value="ignore_filters") IgnoreFilters ignore_filters) {
        private static final String ANY_KEYWORD = "any";

        public static IgnoreRuleRequest forTsRequest(IgnoreViolationRequest tsRequest) {
            List issueIds = CollectionUtils.emptyListIfNull((Object)tsRequest.xrayIssueId());
            List<NameWithVersion> builds = CollectionUtils.emptyListIfNull((Object)tsRequest.build()).stream().map(build -> new NameWithVersion(build.name(), build.version())).toList();
            String projectKeyOrNull = StringUtils.nullIfEmpty((String)JfrogXrayClient.determineXrayApiProjectKey(tsRequest.externalProjectKey()));
            return new IgnoreRuleRequest(tsRequest.notes(), new IgnoreFilters(IgnoreRuleRequest.anyStringIfEmpty(issueIds), Collections.emptyList(), IgnoreRuleRequest.anyVersionIfEmpty(builds), IgnoreRuleRequest.anyVersionIfEmpty(tsRequest.components()), IgnoreRuleRequest.anyStringIfEmpty(CollectionUtils.emptyListIfNull((Object)tsRequest.xrayWatchName())), CollectionUtils.emptyListIfNull((Object)projectKeyOrNull)));
        }

        private static List<NameWithVersion> anyVersionIfEmpty(List<NameWithVersion> namedEntries) {
            return namedEntries.stream().map(namedEntry -> {
                String name = namedEntry.name().isEmpty() ? ANY_KEYWORD : namedEntry.name();
                String version = namedEntry.version().isEmpty() ? ANY_KEYWORD : namedEntry.version();
                return new NameWithVersion(name, version);
            }).toList();
        }

        private static List<String> anyStringIfEmpty(List<String> entries) {
            if (entries.isEmpty()) {
                return List.of(ANY_KEYWORD);
            }
            return entries;
        }

        public record IgnoreFilters(@JsonProperty(value="vulnerabilities") List<String> vulnerabilities, @JsonProperty(value="licenses") List<String> licenses, @JsonProperty(value="builds") List<NameWithVersion> builds, @JsonProperty(value="components") List<NameWithVersion> components, @JsonProperty(value="watches") @Nullable List<String> watches, @JsonProperty(value="projects") @Nullable List<String> projectKeys) implements Serializable
        {
        }
    }
}

