/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.element_details.CodeScopeDetail;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

@Index(name="basic-token-elements", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class BasicTokenElementIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "basic-token-elements";
    private final ValueIndex<BasicTokenElementInfo> delegate;

    public BasicTokenElementIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public @Nullable BasicTokenElementInfo getTokenElement(String uniformPath) throws StorageException {
        return (BasicTokenElementInfo)this.delegate.getValue(uniformPath);
    }

    public List<@Nullable BasicTokenElementInfo> getTokenElements(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public List<@Nullable BasicTokenElementInfo> getTokenElementsFor(List<UniformPath> uniformPaths) throws StorageException {
        return this.delegate.getValues(UniformPathCompatibilityUtil.asUniformPathStrings(uniformPaths));
    }

    public void setTokenElements(Collection<BasicTokenElementInfo> tokenElementInfos) throws StorageException {
        PairList tokenElementValues = new PairList();
        for (BasicTokenElementInfo tokenElementInfo : tokenElementInfos) {
            String uniformPath = tokenElementInfo.getUniformPath();
            tokenElementValues.add((Object)uniformPath, (Object)tokenElementInfo);
            CodeScopeDetail.verifyCodeScopeDetail(tokenElementInfo);
        }
        this.delegate.setValues(tokenElementValues);
    }

    public void setTokenElement(BasicTokenElementInfo tokenElementInfo) throws StorageException {
        String uniformPath = tokenElementInfo.getUniformPath();
        CodeScopeDetail.verifyCodeScopeDetail(tokenElementInfo);
        this.delegate.setValue(uniformPath, (Object)tokenElementInfo);
    }

    public void removeTokenElements(Collection<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public Set<String> getContainedUniformPaths(List<String> uniformPaths) throws StorageException {
        return this.delegate.getContainedKeys(uniformPaths);
    }

    public Map<String, BasicTokenElementInfo> getTokenElementsByPath(Collection<String> uniformPaths) throws StorageException {
        return this.delegate.getValuesByKeys(uniformPaths);
    }

    public List<String> getAllUniformPaths() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public List<String> getUniformPathsStartingWith(String uniformPathPrefix) throws StorageException {
        return this.delegate.getKeysStartingWith(uniformPathPrefix);
    }

    public PairList<String, BasicTokenElementInfo> getAllTokenElements() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

