/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.EExtendedResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Index(name="ext-resource-type", options={EStorageOption.BRANCHED})
public class ExtendedResourceTypeIndex
implements IProjectIndex {
    private final ValueIndex<EnumSet<EExtendedResourceType>> delegateIndex;
    public static final String INDEX_NAME = "ext-resource-type";

    public ExtendedResourceTypeIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public boolean isTestCode(String uniformPath) throws StorageException {
        return this.hasResourceType(uniformPath, EExtendedResourceType.TEST_CODE);
    }

    private boolean hasResourceType(String uniformPath, EExtendedResourceType resourceType) throws StorageException {
        return this.getResourceTypes(uniformPath).contains((Object)resourceType);
    }

    public EnumSet<EExtendedResourceType> getResourceTypes(String uniformPath) throws StorageException {
        return Optional.ofNullable((EnumSet)this.delegateIndex.getValue(uniformPath)).orElse(EnumSet.noneOf(EExtendedResourceType.class));
    }

    public List<EnumSet<EExtendedResourceType>> getAllResourceTypes(List<String> uniformPaths) throws StorageException {
        ArrayList<EnumSet<EExtendedResourceType>> result = new ArrayList<EnumSet<EExtendedResourceType>>();
        List values = this.delegateIndex.getValues(uniformPaths);
        for (EnumSet value : values) {
            result.add(Optional.ofNullable(value).orElse(EnumSet.noneOf(EExtendedResourceType.class)));
        }
        return result;
    }

    public List<Boolean> isTestCode(List<String> uniformPaths) throws StorageException {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        List<EnumSet<EExtendedResourceType>> values = this.getAllResourceTypes(uniformPaths);
        for (EnumSet<EExtendedResourceType> value : values) {
            result.add(value.contains((Object)EExtendedResourceType.TEST_CODE));
        }
        return result;
    }

    public Set<UniformPath> getTestCodePaths(Collection<UniformPath> uniformPaths) throws StorageException {
        List<Boolean> isTestCode = this.isTestCode(uniformPaths.stream().map(UniformPath::resolveToCodePath).map(UniformPath::toString).toList());
        HashSet<UniformPath> result = new HashSet<UniformPath>();
        CollectionUtils.forEach(uniformPaths, isTestCode, (path, isTest) -> {
            if (isTest.booleanValue()) {
                result.add((UniformPath)path);
            }
        });
        return result;
    }

    public void removeEntries(Collection<String> uniformPaths) throws StorageException {
        this.delegateIndex.removeValues(uniformPaths);
    }

    public void setTestCode(String uniformPath) throws StorageException {
        this.addResourceType(uniformPath, EExtendedResourceType.TEST_CODE);
    }

    public void addResourceType(String uniformPath, EExtendedResourceType resourceType) throws StorageException {
        this.delegateIndex.setOrMergeValue(uniformPath, EnumSet.of(resourceType), (x$0, xva$1) -> CollectionUtils.enumUnionSet((Set)x$0, (Set[])new Set[]{xva$1}));
    }

    public void addResourceType(List<String> uniformPaths, EExtendedResourceType resourceType) throws StorageException {
        PairList values = new PairList();
        for (String uniformPath : uniformPaths) {
            values.add((Object)uniformPath, EnumSet.of(resourceType));
        }
        this.delegateIndex.setOrMergeValues(values, (x$0, xva$1) -> CollectionUtils.enumUnionSet((Set)x$0, (Set[])new Set[]{xva$1}));
    }

    public PairList<String, EnumSet<EExtendedResourceType>> getAllEntries() throws StorageException {
        return this.delegateIndex.getAllEntries();
    }
}

