/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.metrics.architecture;

import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ArchitectureMetricsUtils {
    public static final String ROOT_PATH_TO_ARCHITECTURES = UniformPath.EType.ARCHITECTURE.getPrefix();
    private static final String COMPONENT_TO_FILE_SEGMENT = "-src-";
    public static final String COMPONENT_TO_FILE_SEPARATOR = "/-src-/";
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean isArchitectureArtifactPath(String uniformPath) {
        return uniformPath.startsWith(ROOT_PATH_TO_ARCHITECTURES);
    }

    public static String removeArchitecturePathPrefix(String uniformPath) {
        if (uniformPath.endsWith(COMPONENT_TO_FILE_SEPARATOR)) {
            return uniformPath;
        }
        String pathWithoutArchitecturePrefix = ArchitectureMetricsUtils.getPathAfterSeparator(uniformPath, COMPONENT_TO_FILE_SEPARATOR);
        if (pathWithoutArchitecturePrefix != null) {
            return pathWithoutArchitecturePrefix;
        }
        return uniformPath;
    }

    private static String getPathAfterSeparator(String uniformPath, String separator) {
        int separatorIndex = uniformPath.indexOf(separator);
        if (separatorIndex != -1) {
            return uniformPath.substring(separatorIndex + separator.length());
        }
        return null;
    }

    public static String getCombinedPath(String currentComponentPath, String srcFilePath) {
        return currentComponentPath + COMPONENT_TO_FILE_SEPARATOR + srcFilePath;
    }

    public static Map<UniformPath, UniformPath> getRecursivePathMappings(MetricsToArchitectureMetricsMappingIndex index, UniformPath architecturePath) throws StorageException {
        List<String> mappings = index.getMappingsStartingWith(architecturePath.toStringAsMigrationFrontier());
        HashMap<UniformPath, UniformPath> result = new HashMap<UniformPath, UniformPath>();
        for (String mapping : mappings) {
            UniformPath oldValue;
            String[] splitResult = MetricsToArchitectureMetricsMappingIndex.splitMapping(mapping);
            UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)splitResult[1]);
            UniformPath architectureMappingPath = UniformPathCompatibilityUtil.convert((String)splitResult[0]);
            if (!architectureMappingPath.isRoot() && architectureMappingPath.getLastSegment().equals("--NO_MAPPING--") || !architectureMappingPath.hasAncestor(architecturePath) || (oldValue = result.put(uniformPath, architectureMappingPath)) == null) continue;
            LOGGER.warn("Duplicate architecture path for source path {}: [{}, {}]", (Object)uniformPath, (Object)oldValue, (Object)architectureMappingPath);
        }
        return result;
    }

    public static Set<String> getLeafPaths(MetricsToArchitectureMetricsMappingIndex mappingIndex, String architecturePath) throws StorageException {
        List<String> mappings = mappingIndex.getMappingsStartingWith(architecturePath);
        HashSet<String> mappedUniformPaths = new HashSet<String>();
        for (String mapping : mappings) {
            String uniformPath = MetricsToArchitectureMetricsMappingIndex.splitMapping(mapping)[1];
            mappedUniformPaths.add(uniformPath);
        }
        if (mappedUniformPaths.isEmpty()) {
            if (architecturePath.contains(COMPONENT_TO_FILE_SEPARATOR)) {
                String uniformPath = ArchitectureMetricsUtils.removeArchitecturePathPrefix(architecturePath);
                return CollectionUtils.asHashSet((Object[])new String[]{uniformPath});
            }
            return CollectionUtils.emptySet();
        }
        return mappedUniformPaths;
    }

    public static Set<String> getArchitectureFreeSourcePaths(String uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption accessOption) throws StorageException {
        if (ArchitectureMetricsUtils.isArchitectureArtifactPath(uniformPath)) {
            MetricsToArchitectureMetricsMappingIndex mappingIndex = (MetricsToArchitectureMetricsMappingIndex)projectStorageSystem.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, accessOption);
            return ArchitectureMetricsUtils.getLeafPaths(mappingIndex, uniformPath);
        }
        ContainerIndex containerIndex = (ContainerIndex)projectStorageSystem.openProjectIndex(ContainerIndex.class, "dir", accessOption);
        uniformPath = ResourceServiceUtils.getUniformPathPrefixContainerAware(containerIndex, uniformPath);
        return CollectionUtils.asHashSet((Object[])new String[]{uniformPath});
    }

    private ArchitectureMetricsUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

