/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.parser.state.java;

import com.teamscale.index.stacktrace.component.ExceptionRepresentation;
import com.teamscale.index.stacktrace.component.Stacktrace;
import com.teamscale.index.stacktrace.parser.IStacktraceParserState;
import com.teamscale.index.stacktrace.parser.state.java.JavaWaitingForCauseExceptionState;
import com.teamscale.index.stacktrace.parser.state.java.JavaWaitingForStackFrameState;
import com.teamscale.index.stacktrace.parser.util.JavaStacktraceParserUtils;
import com.teamscale.index.stacktrace.tokenizer.EStacktraceTokenType;
import com.teamscale.index.stacktrace.tokenizer.token.IStacktraceToken;
import com.teamscale.index.stacktrace.tokenizer.token.java.JavaMoreIdentifierToken;
import java.util.EnumSet;

public class JavaFoundAtLeastOneStackFrameState
implements IStacktraceParserState {
    @Override
    public EnumSet<EStacktraceTokenType> getValidTokenTypes() {
        return EnumSet.of(EStacktraceTokenType.JAVA_CAUSE_EXCEPTION, EStacktraceTokenType.JAVA_STACK_FRAME, EStacktraceTokenType.JAVA_MORE_IDENTIFIER);
    }

    @Override
    public void handleToken(Stacktrace stacktrace, IStacktraceToken token) {
        switch (token.getTokenType()) {
            case JAVA_CAUSE_EXCEPTION: {
                stacktrace.add(JavaStacktraceParserUtils.createCauseExceptionFromJavaToken(token));
                break;
            }
            case JAVA_MORE_IDENTIFIER: {
                JavaMoreIdentifierToken moreIdentifierToken = (JavaMoreIdentifierToken)token;
                ExceptionRepresentation currentException = stacktrace.getInitialException();
                if (!stacktrace.getCauseExceptions().isEmpty()) {
                    currentException = stacktrace.getCauseExceptions().get(stacktrace.getCauseExceptions().size() - 1);
                }
                currentException.setSkippedStackFrames(Integer.parseInt(moreIdentifierToken.getAmount()));
                break;
            }
            case JAVA_STACK_FRAME: {
                stacktrace.getLastException().add(JavaStacktraceParserUtils.createStackFrameFromJavaToken(token));
                break;
            }
        }
    }

    @Override
    public IStacktraceParserState getNextState(IStacktraceToken token) {
        switch (token.getTokenType()) {
            case JAVA_STACK_FRAME: {
                return new JavaFoundAtLeastOneStackFrameState();
            }
            case JAVA_CAUSE_EXCEPTION: {
                return new JavaWaitingForStackFrameState();
            }
            case JAVA_MORE_IDENTIFIER: {
                return new JavaWaitingForCauseExceptionState();
            }
        }
        return null;
    }
}

