/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.engine.sourcecode.coverage.volume.CoverableVolumeUtils;
import org.conqat.lib.commons.collections.CompactLines;

public class CoverageAdjuster {
    public static void correctLineCoverage(String uniformPath, TokenElementLineInfo tokenElementLineInfo, LineCoverageInfo coverageInfo, boolean coverageInfoPresent) {
        if (!ShallowParserFactory.supportsLanguage((ELanguage)tokenElementLineInfo.getLanguage())) {
            return;
        }
        coverageInfo.extendCoverageToStatements(tokenElementLineInfo.getMultilineStatementRegions());
        coverageInfo.setCoverableLines(CoverageAdjuster.getCoverableLines(tokenElementLineInfo, coverageInfo, coverageInfoPresent, uniformPath));
    }

    public static CompactLines getCoverableLines(TokenElementLineInfo tokenElementLineInfo, LineCoverageInfo coverageInfo, boolean coverageInfoPresent, String uniformPath) {
        CompactLines coverableLines;
        if (coverageInfoPresent && CoverableVolumeUtils.useCoverableLinesFromCoverageReports((ELanguage)tokenElementLineInfo.getLanguage())) {
            coverableLines = coverageInfo.getAllCoverableLines();
            if (tokenElementLineInfo.getLanguage() == ELanguage.CPP || tokenElementLineInfo.getLanguage() == ELanguage.CPP_MS_CLI) {
                coverableLines.removeAll(tokenElementLineInfo.getExcludedRawLines());
            }
        } else {
            coverableLines = tokenElementLineInfo.getRawCoverableLines();
            if (coverageInfoPresent && CoverableVolumeUtils.useCoverableVolumeFilterForCpp((String)uniformPath)) {
                coverableLines.retainAll(coverageInfo.getAllCoverableLines());
            }
        }
        return coverableLines;
    }
}

