/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.information_retrieval;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.tests.information_retrieval.PathTermFrequencyIndex;
import com.teamscale.index.tests.information_retrieval.TermPathFrequencyIndex;
import com.teamscale.index.tests.information_retrieval.TokenTermExtractor;
import com.teamscale.index.tests.information_retrieval.data.Term;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestInformationRetrievalSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final int PATHS_TO_PROCESS_BATCH_SIZE = 100;
    @DeltaSource(value=TestImplementationIndex.class)
    private KeyDelta testImplementationDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestImplementationIndex testImplementationIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex tokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private PathTermFrequencyIndex previousPathTermFrequencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PathTermFrequencyIndex pathTermFrequencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TermPathFrequencyIndex termPathFrequencyIndex;

    public void execute() throws Exception {
        Map<UniformPath, CounterSet<Term>> pathTermDelta = this.computeAndStorePathTermDelta();
        this.computeAndStoreTermPathDelta(pathTermDelta);
    }

    private Map<UniformPath, CounterSet<Term>> computeAndStorePathTermDelta() throws ExecutionException, StorageException {
        ConcurrentHashMap<UniformPath, CounterSet<Term>> deltaByPath = new ConcurrentHashMap<UniformPath, CounterSet<Term>>();
        PairList newBagsOfWordsByPath = new PairList();
        Set deletedTestPaths = UniformPathCompatibilityUtil.convertSet((Collection)this.testImplementationDelta.getDeletedKeysAsStrings());
        List deltaPaths = UniformPathCompatibilityUtil.convertCollection((Collection)this.testImplementationDelta.getAllKeysAsStrings());
        this.executeInParallelBatches(deltaPaths, batch -> {
            List<@Nullable CounterSet<Term>> batchOldBagsOfWord = this.previousPathTermFrequencyIndex.getBagsOfWords((List<UniformPath>)batch);
            List<@Nullable TestImplementation> batchTestImplementations = this.testImplementationIndex.getTestImplementationsForPaths((List<UniformPath>)batch);
            Map<TestImplementation, TokenElementInfo> batchTestImplementationTokenInfos = this.getTokenElementInfos(batchTestImplementations);
            for (int i = 0; i < batch.size(); ++i) {
                CounterSet<Term> newEntryBagOfWords;
                UniformPath path = (UniformPath)batch.get(i);
                @Nullable TestImplementation testImplementation = batchTestImplementations.get(i);
                @Nullable CounterSet<Term> oldEntryBagOfWords = batchOldBagsOfWord.get(i);
                boolean isDelete = deletedTestPaths.contains(path);
                if (isDelete) {
                    newEntryBagOfWords = CounterSet.empty();
                } else {
                    CCSMAssert.isNotNull((Object)testImplementation);
                    TokenElementInfo tokenInfos = batchTestImplementationTokenInfos.get(testImplementation);
                    CounterSet<String> newBagOfWordsUnabbreviated = TestInformationRetrievalSynchronizer.tokenizeImplementation(testImplementation, tokenInfos);
                    newEntryBagOfWords = this.pathTermFrequencyIndex.abbreviateToBagOfWords(newBagOfWordsUnabbreviated);
                }
                CounterSet bagOfWordsDelta = newEntryBagOfWords.getDeltaTo(oldEntryBagOfWords);
                deltaByPath.put(path, bagOfWordsDelta);
                PairList pairList = newBagsOfWordsByPath;
                synchronized (pairList) {
                    newBagsOfWordsByPath.add((Object)path, newEntryBagOfWords);
                    continue;
                }
            }
        }, 100);
        this.pathTermFrequencyIndex.putTermFrequency((PairList<UniformPath, CounterSet<Term>>)newBagsOfWordsByPath);
        return deltaByPath;
    }

    private Map<TestImplementation, TokenElementInfo> getTokenElementInfos(List<@Nullable TestImplementation> batchTestImplementations) throws StorageException {
        List<TestImplementation> definedTestImplementations = batchTestImplementations.stream().filter(Objects::nonNull).toList();
        List<TokenElementInfo> batchTestImplementationTokenInfos = this.tokenElementIndex.getTokenElements(definedTestImplementations.stream().map(implementation -> implementation.getLocationWithComment().getUniformPath()).toList());
        return CollectionUtils.zipAsMap(definedTestImplementations, batchTestImplementationTokenInfos);
    }

    private static CounterSet<String> tokenizeImplementation(TestImplementation testImplementation, TokenElementInfo tokenInfos) {
        CounterSet result = new CounterSet();
        result.add(TokenTermExtractor.getContextBagOfWords(tokenInfos, TestInformationRetrievalSynchronizer.toOffsetBasedRegion(testImplementation.getLocationWithComment())));
        result.incAll(TokenTermExtractor.extractContentAsList(TestInformationRetrievalSynchronizer.extractTestBodyTokens(tokenInfos, testImplementation.getLocationWithComment())));
        return result;
    }

    private void computeAndStoreTermPathDelta(Map<UniformPath, CounterSet<Term>> pathTermDelta) throws StorageException {
        HashMap<Term, CounterSet<UniformPath>> termPathDelta = new HashMap<Term, CounterSet<UniformPath>>();
        for (Map.Entry<UniformPath, CounterSet<Term>> entry : pathTermDelta.entrySet()) {
            UniformPath path = entry.getKey();
            CounterSet<Term> termDeltaMap = entry.getValue();
            for (Pair termEntry : termDeltaMap) {
                Term term = (Term)termEntry.getFirst();
                Integer termDelta = (Integer)termEntry.getSecond();
                CounterSet pathDeltaMap = termPathDelta.computeIfAbsent(term, k -> new CounterSet());
                pathDeltaMap.inc((Object)path, termDelta.intValue());
            }
        }
        this.termPathFrequencyIndex.updateWith(termPathDelta);
    }

    private static List<IToken> extractTestBodyTokens(TokenElementInfo testImplementationTokens, TextRegionLocation location) {
        return TokenStreamUtils.getTokensBetween(testImplementationTokens.getPreprocessedTokens(), (int)location.getRawStartOffset(), (int)location.getRawEndOffset());
    }

    private static OffsetBasedRegion toOffsetBasedRegion(TextRegionLocation location) {
        return new OffsetBasedRegion(location.getRawStartOffset(), location.getRawEndOffset());
    }
}

