/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.upload.fortify;

import com.teamscale.index.findings.IntegratedToolUpdateUtils;
import com.teamscale.index.report.parser.fortify.FortifyIssueData;
import com.teamscale.index.upload.IExternalToolRule;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class FortifyRule
implements IExternalToolRule {
    private final String id;
    private final String shortDescription;
    private final String kingdom;
    private final String friority;
    private final String abstractSection;
    private final String tipsSection;
    private final String referencesSection;

    public FortifyRule(FortifyIssueData data) {
        this.kingdom = data.kingdom();
        this.shortDescription = data.issueName();
        this.id = FortifyRule.buildId(data.kingdom(), data.issueName());
        this.abstractSection = data.brief();
        this.tipsSection = data.tips();
        this.referencesSection = data.references();
        this.friority = data.friority();
    }

    private static String buildId(String kingdom, String type) {
        Stream<String> parts = Stream.of("Fortify", kingdom, type);
        return parts.map(part -> Patterns.MULTIPLE_NON_WORD_CHARACTERS.matcher((CharSequence)part).replaceAll("")).collect(Collectors.joining("#"));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public String getReadableName() {
        return IntegratedToolUpdateUtils.makeMarkdownUnambiguous(this.getShortDescription());
    }

    @Override
    public @Nullable String getFullDescription() {
        StringBuilder description = new StringBuilder();
        if (!StringUtils.isEmpty((String)this.abstractSection)) {
            description.append("# Abstract\n").append(this.abstractSection).append("\n\n");
        }
        if (!StringUtils.isEmpty((String)this.tipsSection)) {
            description.append("# Tips\n").append(this.tipsSection).append("\n\n");
        }
        if (!StringUtils.isEmpty((String)this.referencesSection)) {
            description.append("# References\n").append(this.referencesSection).append("\n\n");
        }
        return !description.isEmpty() ? description.toString() : null;
    }

    @Override
    public EFindingEnablement getFindingEnablement() {
        String priority;
        if (this.friority != null && ("high".equals(priority = this.friority.toLowerCase()) || "critical".equals(priority))) {
            return EFindingEnablement.RED;
        }
        return EFindingEnablement.YELLOW;
    }

    @Override
    public String getAnalysisGroup() {
        return this.kingdom;
    }

    @Override
    public String getQualityIndicator() {
        return "Security";
    }
}

