/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Duration;

public interface Issue
extends Serializable {
    public static final int MESSAGE_MAX_SIZE = 1333;
    public static final String STATUS_OPEN = "OPEN";
    public static final String STATUS_CONFIRMED = "CONFIRMED";
    public static final String STATUS_REOPENED = "REOPENED";
    public static final String STATUS_RESOLVED = "RESOLVED";
    public static final String STATUS_CLOSED = "CLOSED";
    public static final String RESOLUTION_FIXED = "FIXED";
    public static final String RESOLUTION_FALSE_POSITIVE = "FALSE-POSITIVE";
    public static final String RESOLUTION_REMOVED = "REMOVED";
    public static final String RESOLUTION_WONT_FIX = "WONTFIX";
    public static final String RESOLUTION_SAFE = "SAFE";
    public static final String RESOLUTION_ACKNOWLEDGED = "ACKNOWLEDGED";
    public static final List<String> RESOLUTIONS = Collections.unmodifiableList(Arrays.asList("FALSE-POSITIVE", "WONTFIX", "FIXED", "REMOVED"));
    public static final List<String> SECURITY_HOTSPOT_RESOLUTIONS = Collections.unmodifiableList(Arrays.asList("FIXED", "SAFE", "ACKNOWLEDGED"));
    public static final String STATUS_TO_REVIEW = "TO_REVIEW";
    @Deprecated
    public static final String STATUS_IN_REVIEW = "IN_REVIEW";
    public static final String STATUS_REVIEWED = "REVIEWED";
    public static final List<String> STATUSES = Collections.unmodifiableList(Arrays.asList("OPEN", "CONFIRMED", "REOPENED", "RESOLVED", "CLOSED", "TO_REVIEW", "REVIEWED"));

    public String key();

    public String componentKey();

    public RuleKey ruleKey();

    public String language();

    @Deprecated(since="10.1")
    @CheckForNull
    public String severity();

    @CheckForNull
    public String message();

    @CheckForNull
    public Integer line();

    @CheckForNull
    public Double gap();

    public String status();

    @CheckForNull
    public String resolution();

    @CheckForNull
    public String assignee();

    public Date creationDate();

    public Date updateDate();

    @CheckForNull
    public Date closeDate();

    @Deprecated
    @CheckForNull
    public String attribute(String var1);

    @Deprecated
    public Map<String, String> attributes();

    @CheckForNull
    public String authorLogin();

    public boolean isNew();

    public boolean isCopied();

    @CheckForNull
    public Duration effort();

    public String projectKey();

    public String projectUuid();

    public String componentUuid();

    public Collection<String> tags();

    @CheckForNull
    public Collection<String> codeVariants();
}

