/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.eventbus.EventBus;
import java.util.HashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.sonarlint.core.clientapi.backend.config.ConfigurationService;
import org.sonarsource.sonarlint.core.clientapi.backend.config.binding.BindingConfigurationDto;
import org.sonarsource.sonarlint.core.clientapi.backend.config.binding.DidUpdateBindingParams;
import org.sonarsource.sonarlint.core.clientapi.backend.config.scope.ConfigurationScopeDto;
import org.sonarsource.sonarlint.core.clientapi.backend.config.scope.DidAddConfigurationScopesParams;
import org.sonarsource.sonarlint.core.clientapi.backend.config.scope.DidRemoveConfigurationScopeParams;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.event.BindingConfigChangedEvent;
import org.sonarsource.sonarlint.core.event.ConfigurationScopeRemovedEvent;
import org.sonarsource.sonarlint.core.event.ConfigurationScopesAddedEvent;
import org.sonarsource.sonarlint.core.repository.config.BindingConfiguration;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScopeWithBinding;

@Named
@Singleton
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final EventBus clientEventBus;
    private final ConfigurationRepository repository;

    public ConfigurationServiceImpl(EventBus clientEventBus, ConfigurationRepository repository) {
        this.clientEventBus = clientEventBus;
        this.repository = repository;
    }

    @Override
    public void didAddConfigurationScopes(DidAddConfigurationScopesParams params) {
        List<ConfigurationScopeDto> addedDtos = params.getAddedScopes();
        HashSet<String> addedIds = new HashSet<String>();
        for (ConfigurationScopeDto addedDto : addedDtos) {
            ConfigurationScope previous = this.addOrUpdateRepository(addedDto);
            if (previous != null) {
                LOG.error("Duplicate configuration scope registered: {}", (Object)addedDto.getId());
                continue;
            }
            addedIds.add(addedDto.getId());
        }
        this.clientEventBus.post((Object)new ConfigurationScopesAddedEvent(addedIds));
    }

    private ConfigurationScope addOrUpdateRepository(ConfigurationScopeDto dto) {
        ConfigurationScope configScopeInReferential = ConfigurationServiceImpl.adapt(dto);
        BindingConfigurationDto bindingDto = dto.getBinding();
        BindingConfiguration bindingConfigInReferential = ConfigurationServiceImpl.adapt(bindingDto);
        return this.repository.addOrReplace(configScopeInReferential, bindingConfigInReferential);
    }

    @NotNull
    private static BindingConfiguration adapt(BindingConfigurationDto dto) {
        return new BindingConfiguration(dto.getConnectionId(), dto.getSonarProjectKey(), dto.isBindingSuggestionDisabled());
    }

    @NotNull
    private static ConfigurationScope adapt(ConfigurationScopeDto dto) {
        return new ConfigurationScope(dto.getId(), dto.getParentId(), dto.isBindable(), dto.getName());
    }

    @Override
    public void didRemoveConfigurationScope(DidRemoveConfigurationScopeParams params) {
        String idToRemove = params.getRemovedId();
        ConfigurationScopeWithBinding removed = this.repository.remove(idToRemove);
        if (removed == null) {
            LOG.error("Attempt to remove configuration scope '{}' that was not registered", (Object)idToRemove);
        } else {
            this.clientEventBus.post((Object)new ConfigurationScopeRemovedEvent(removed.getScope(), removed.getBindingConfiguration()));
        }
    }

    @Override
    public void didUpdateBinding(DidUpdateBindingParams params) {
        BindingConfigChangedEvent boundEvent = this.bind(params.getConfigScopeId(), params.getUpdatedBinding());
        if (boundEvent != null) {
            this.clientEventBus.post((Object)boundEvent);
        }
    }

    @CheckForNull
    private BindingConfigChangedEvent bind(String configurationScopeId, BindingConfigurationDto bindingConfiguration) {
        BindingConfiguration previousBindingConfig = this.repository.getBindingConfiguration(configurationScopeId);
        if (previousBindingConfig == null) {
            LOG.error("Attempt to update binding in configuration scope '{}' that was not registered", (Object)configurationScopeId);
            return null;
        }
        BindingConfiguration newBindingConfig = ConfigurationServiceImpl.adapt(bindingConfiguration);
        this.repository.updateBinding(configurationScopeId, newBindingConfig);
        return ConfigurationServiceImpl.createChangedEventIfNeeded(configurationScopeId, previousBindingConfig, newBindingConfig);
    }

    @CheckForNull
    private static BindingConfigChangedEvent createChangedEventIfNeeded(String configScopeId, BindingConfiguration previousBindingConfig, BindingConfiguration newBindingConfig) {
        if (!previousBindingConfig.equals(newBindingConfig)) {
            return new BindingConfigChangedEvent(configScopeId, previousBindingConfig, newBindingConfig);
        }
        return null;
    }

    public List<ConfigurationScope> getConfigScopesWithBindingConfiguredTo(String connectionId, String projectKey) {
        return this.repository.getBoundScopesByConnection(connectionId, projectKey);
    }
}

