/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.repository.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.BoundScope;
import org.sonarsource.sonarlint.core.repository.config.BindingConfiguration;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScopeWithBinding;

@Named
@Singleton
public class ConfigurationRepository {
    private final Map<String, ConfigurationScope> configScopePerId = new ConcurrentHashMap<String, ConfigurationScope>();
    private final Map<String, BindingConfiguration> bindingPerConfigScopeId = new ConcurrentHashMap<String, BindingConfiguration>();

    public ConfigurationScope addOrReplace(ConfigurationScope configScope, BindingConfiguration bindingConfig) {
        String id = configScope.getId();
        ConfigurationScope previous = this.configScopePerId.put(id, configScope);
        this.bindingPerConfigScopeId.put(id, bindingConfig);
        return previous;
    }

    @CheckForNull
    public ConfigurationScopeWithBinding remove(String idToRemove) {
        ConfigurationScope removedScope = this.configScopePerId.remove(idToRemove);
        BindingConfiguration removeBindingConfiguration = this.bindingPerConfigScopeId.remove(idToRemove);
        return removedScope == null ? null : new ConfigurationScopeWithBinding(removedScope, removeBindingConfiguration);
    }

    public void updateBinding(String configScopeId, BindingConfiguration bindingConfig) {
        this.bindingPerConfigScopeId.put(configScopeId, bindingConfig);
    }

    public Set<String> getConfigScopeIds() {
        return Set.copyOf(this.configScopePerId.keySet());
    }

    @CheckForNull
    public BindingConfiguration getBindingConfiguration(String configScopeId) {
        return this.bindingPerConfigScopeId.get(configScopeId);
    }

    public Optional<Binding> getEffectiveBinding(String configScopeId) {
        String configScopeIdToSearchIn = Objects.requireNonNull(configScopeId, "Configuration Scope ID is mandatory");
        Optional<Binding> binding;
        while (!(binding = this.getConfiguredBinding(configScopeIdToSearchIn)).isPresent()) {
            Optional<String> parentId = this.getParentId(configScopeIdToSearchIn);
            if (parentId.isEmpty()) {
                return Optional.empty();
            }
            configScopeIdToSearchIn = parentId.get();
        }
        return binding;
    }

    public Optional<Binding> getConfiguredBinding(String configScopeId) {
        BindingConfiguration bindingConfiguration = this.bindingPerConfigScopeId.get(configScopeId);
        if (bindingConfiguration != null && bindingConfiguration.isBound()) {
            return Optional.of(new Binding(Objects.requireNonNull(bindingConfiguration.getConnectionId()), Objects.requireNonNull(bindingConfiguration.getSonarProjectKey())));
        }
        return Optional.empty();
    }

    private Optional<String> getParentId(String configScopeId) {
        ConfigurationScope configurationScope = this.configScopePerId.get(configScopeId);
        if (configurationScope != null) {
            return Optional.ofNullable(configurationScope.getParentId());
        }
        return Optional.empty();
    }

    @CheckForNull
    public ConfigurationScope getConfigurationScope(String configScopeId) {
        return this.configScopePerId.get(configScopeId);
    }

    public List<ConfigurationScope> getBoundScopesByConnection(String connectionId, String projectKey) {
        return this.bindingPerConfigScopeId.entrySet().stream().filter(e -> ((BindingConfiguration)e.getValue()).isBoundTo(connectionId, projectKey)).map(e -> this.configScopePerId.get(e.getKey())).collect(Collectors.toList());
    }

    public Collection<BoundScope> getBoundScopesByConnection(String connectionId) {
        return this.bindingPerConfigScopeId.entrySet().stream().filter(e -> ((BindingConfiguration)e.getValue()).isBoundToConnection(connectionId)).map(e -> new BoundScope((String)e.getKey(), connectionId, Objects.requireNonNull(((BindingConfiguration)e.getValue()).getSonarProjectKey()))).collect(Collectors.toList());
    }

    public List<ConfigurationScope> getConfigScopesWithBindingConfiguredTo(String connectionId) {
        return this.bindingPerConfigScopeId.entrySet().stream().filter(e -> ((BindingConfiguration)e.getValue()).isBoundToConnection(connectionId)).map(e -> this.configScopePerId.get(e.getKey())).collect(Collectors.toList());
    }

    public List<BoundScope> getBoundScopesByProject(String projectKey) {
        return this.bindingPerConfigScopeId.entrySet().stream().filter(e -> ((BindingConfiguration)e.getValue()).isBoundToProject(projectKey)).map(e -> new BoundScope((String)e.getKey(), Objects.requireNonNull(((BindingConfiguration)e.getValue()).getConnectionId()), projectKey)).collect(Collectors.toList());
    }

    public Map<String, Map<String, Set<String>>> getScopeIdsPerProjectKeyPerConnectionId() {
        HashMap<String, Map<String, Set<String>>> scopeIdsPerProjectKeyPerConnectionId = new HashMap<String, Map<String, Set<String>>>();
        this.bindingPerConfigScopeId.forEach((scopeId, bindingConfiguration) -> {
            if (bindingConfiguration.isBound()) {
                scopeIdsPerProjectKeyPerConnectionId.computeIfAbsent(bindingConfiguration.getConnectionId(), k -> new HashMap()).computeIfAbsent(bindingConfiguration.getSonarProjectKey(), k -> new HashSet()).add(scopeId);
            }
        });
        return scopeIdsPerProjectKeyPerConnectionId;
    }

    public Map<String, Binding> getEffectiveBindingForLeafConfigScopesById() {
        Set<String> leaves = this.getLeafConfigurationScopeIds();
        return this.bindingPerConfigScopeId.keySet().stream().filter(leaves::contains).map(scopeId -> Map.entry(scopeId, this.getEffectiveBinding((String)scopeId))).filter(entry -> ((Optional)entry.getValue()).isPresent()).map(entry -> Map.entry((String)entry.getKey(), (Binding)((Optional)entry.getValue()).get())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Set<String> getLeafConfigurationScopeIds() {
        Set parentConfigScopeIds = this.configScopePerId.values().stream().map(ConfigurationScope::getParentId).filter(Predicate.not(Objects::isNull)).collect(Collectors.toSet());
        HashSet<String> leaves = new HashSet<String>(this.configScopePerId.keySet());
        leaves.removeAll(parentConfigScopeIds);
        return leaves;
    }
}

