/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.server.event;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.client.event.DidReceiveServerEventParams;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.BoundScope;
import org.sonarsource.sonarlint.core.commons.ConnectionKind;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.event.BindingConfigChangedEvent;
import org.sonarsource.sonarlint.core.event.ConfigurationScopeRemovedEvent;
import org.sonarsource.sonarlint.core.event.ConfigurationScopesAddedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationAddedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationRemovedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationUpdatedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionCredentialsChangedEvent;
import org.sonarsource.sonarlint.core.languages.LanguageSupportRepository;
import org.sonarsource.sonarlint.core.repository.config.BindingConfiguration;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.server.event.SonarQubeEventStream;
import org.sonarsource.sonarlint.core.storage.StorageService;

public class ServerEventsService {
    private final SonarLintClient client;
    private final ConfigurationRepository configurationRepository;
    private final ConnectionConfigurationRepository connectionConfigurationRepository;
    private final StorageService storageService;
    private final ServerApiProvider serverApiProvider;
    private final LanguageSupportRepository languageSupportRepository;
    private final boolean shouldManageServerSentEvents;
    private final Map<String, SonarQubeEventStream> streamsPerConnectionId = new ConcurrentHashMap<String, SonarQubeEventStream>();

    public ServerEventsService(SonarLintClient client, ConfigurationRepository configurationRepository, ConnectionConfigurationRepository connectionConfigurationRepository, StorageService storageService, ServerApiProvider serverApiProvider, LanguageSupportRepository languageSupportRepository, InitializeParams initializeParams) {
        this.client = client;
        this.configurationRepository = configurationRepository;
        this.connectionConfigurationRepository = connectionConfigurationRepository;
        this.storageService = storageService;
        this.serverApiProvider = serverApiProvider;
        this.languageSupportRepository = languageSupportRepository;
        this.shouldManageServerSentEvents = initializeParams.getFeatureFlags().shouldManageServerSentEvents();
    }

    @Subscribe
    public void handle(ConfigurationScopesAddedEvent event) {
        if (!this.shouldManageServerSentEvents) {
            return;
        }
        this.subscribeAll(event.getAddedConfigurationScopeIds());
    }

    @Subscribe
    public void handle(ConfigurationScopeRemovedEvent event) {
        if (!this.shouldManageServerSentEvents) {
            return;
        }
        ConfigurationScope removedScope = event.getRemovedConfigurationScope();
        BindingConfiguration removedBindingConfiguration = event.getRemovedBindingConfiguration();
        BindingConfiguration bindingConfigurationFromRepository = this.configurationRepository.getBindingConfiguration(removedScope.getId());
        if (bindingConfigurationFromRepository == null || ServerEventsService.isBindingDifferent(removedBindingConfiguration, bindingConfigurationFromRepository)) {
            this.unsubscribe(removedBindingConfiguration);
        }
    }

    @Subscribe
    public void handle(BindingConfigChangedEvent event) {
        if (!this.shouldManageServerSentEvents) {
            return;
        }
        BindingConfiguration previousBinding = event.getPreviousConfig();
        if (ServerEventsService.isBindingDifferent(previousBinding, event.getNewConfig())) {
            this.unsubscribe(previousBinding);
            this.subscribe(event.getConfigScopeId());
        }
    }

    @Subscribe
    public void handle(ConnectionConfigurationAddedEvent event) {
        if (!this.shouldManageServerSentEvents) {
            return;
        }
        String connectionId = event.getAddedConnectionId();
        Collection<BoundScope> boundScopes = this.configurationRepository.getBoundScopesByConnection(connectionId);
        this.subscribe(connectionId, boundScopes.stream().map(BoundScope::getSonarProjectKey).collect(Collectors.toSet()));
    }

    @Subscribe
    public void handle(ConnectionConfigurationRemovedEvent event) {
        if (!this.shouldManageServerSentEvents) {
            return;
        }
        SonarQubeEventStream stream = this.streamsPerConnectionId.remove(event.getRemovedConnectionId());
        if (stream != null) {
            stream.stop();
        }
    }

    @Subscribe
    public void handle(ConnectionConfigurationUpdatedEvent event) {
        if (!this.shouldManageServerSentEvents) {
            return;
        }
        this.resubscribe(event.getUpdatedConnectionId());
    }

    @Subscribe
    public void handle(ConnectionCredentialsChangedEvent event) {
        if (!this.shouldManageServerSentEvents) {
            return;
        }
        this.resubscribe(event.getConnectionId());
    }

    private static boolean isBindingDifferent(BindingConfiguration previousConfig, BindingConfiguration newConfig) {
        return !Objects.equals(previousConfig.getSonarProjectKey(), newConfig.getSonarProjectKey()) || !Objects.equals(previousConfig.getConnectionId(), newConfig.getConnectionId());
    }

    private void subscribeAll(Set<String> configurationScopeIds) {
        configurationScopeIds.stream().map(this.configurationRepository::getConfiguredBinding).flatMap(Optional::stream).collect(Collectors.groupingBy(Binding::getConnectionId, Collectors.mapping(Binding::getSonarProjectKey, Collectors.toSet()))).forEach(this::subscribe);
    }

    private void subscribe(String scopeId) {
        this.configurationRepository.getConfiguredBinding(scopeId).ifPresent(binding -> this.subscribe(binding.getConnectionId(), Set.of(binding.getSonarProjectKey())));
    }

    private void subscribe(String connectionId, Set<String> possiblyNewProjectKeys) {
        if (this.supportsServerSentEvents(connectionId)) {
            SonarQubeEventStream stream = this.streamsPerConnectionId.computeIfAbsent(connectionId, k -> this.openStream(connectionId));
            stream.subscribeNew(possiblyNewProjectKeys);
        }
    }

    private SonarQubeEventStream openStream(String connectionId) {
        return new SonarQubeEventStream(this.storageService.connection(connectionId), this.languageSupportRepository.getEnabledLanguagesInConnectedMode(), connectionId, this.serverApiProvider, e -> this.notifyClient(connectionId, (ServerEvent)e));
    }

    private void notifyClient(String connectionId, ServerEvent serverEvent) {
        this.client.didReceiveServerEvent(new DidReceiveServerEventParams(connectionId, serverEvent));
    }

    private boolean supportsServerSentEvents(String connectionId) {
        AbstractConnectionConfiguration connection = this.connectionConfigurationRepository.getConnectionById(connectionId);
        return connection != null && connection.getKind() == ConnectionKind.SONARQUBE;
    }

    private void unsubscribe(BindingConfiguration previousBindingConfiguration) {
        if (previousBindingConfiguration.isBound()) {
            String connectionId = Objects.requireNonNull(previousBindingConfiguration.getConnectionId());
            String projectKey = Objects.requireNonNull(previousBindingConfiguration.getSonarProjectKey());
            if (this.supportsServerSentEvents(connectionId) && this.streamsPerConnectionId.containsKey(connectionId) && this.configurationRepository.getBoundScopesByConnection(connectionId).stream().noneMatch(scope -> scope.getSonarProjectKey().equals(projectKey))) {
                this.streamsPerConnectionId.get(connectionId).unsubscribe(projectKey);
            }
        }
    }

    private void resubscribe(String connectionId) {
        if (this.supportsServerSentEvents(connectionId) && this.streamsPerConnectionId.containsKey(connectionId)) {
            this.streamsPerConnectionId.get(connectionId).resubscribe();
        }
    }

    @PreDestroy
    public void shutdown() {
        this.streamsPerConnectionId.values().forEach(SonarQubeEventStream::stop);
        this.streamsPerConnectionId.clear();
    }
}

