/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.links;

import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.commons.service.client.ServiceClientUris;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.jspecify.annotations.Nullable;

public class TeamscaleCommitLinkProvider
extends TeamscaleProjectLinkProvider {
    private final @Nullable UnresolvedCommitDescriptor commit;

    public TeamscaleCommitLinkProvider(String baseUrl, PublicProjectId projectId, @Nullable UnresolvedCommitDescriptor commit) {
        super(baseUrl, projectId);
        this.commit = commit;
    }

    public String createFindingsDetailLink(String findingId) {
        return this.baseUrl + "findings/details/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + this.createFindingIdOptionString(findingId);
    }

    public String createCommitDetailsLink() {
        return this.baseUrl + "activity/details/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + this.createCommitOptionString();
    }

    public String createCommitAlertDetailsLink(UnresolvedCommitDescriptor commit) {
        return this.baseUrl + "activity/details/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + TeamscaleCommitLinkProvider.createCommitOptionString(commit);
    }

    public String createMergeRequestTestGapDetailsLink(String uniformPath, int methodStartOffset, int methodEndOffset, MergeRequestIdentifier mergeRequestIdentifier) {
        String queryParameters = ServiceClientUris.createOptionString("coverage-mode", "test-gap", "t", UnresolvedCommitDescriptor.latestOnBranch(this.commit.getBranchName()).toString(), "selection", "char-" + methodStartOffset + "-" + methodEndOffset, "merge-request", mergeRequestIdentifier.toString());
        return this.baseUrl + "metrics/code/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + "/" + UrlUtils.encodePathSegment((String)uniformPath) + queryParameters;
    }

    public String createTestGapDetailsLink(String uniformPath, int methodStartOffset, int methodEndOffset, List<String> partitions, long baselineTimestamp) {
        StringBuilder queryParameters = new StringBuilder(ServiceClientUris.createOptionString("coverage-mode", "test-gap", "t", this.commit.toString(), "selection", "char-" + methodStartOffset + "-" + methodEndOffset, "tga-baseline", "TIMESTAMP+" + baselineTimestamp));
        if (!partitions.isEmpty()) {
            queryParameters.append("&partition=");
            queryParameters.append(UrlUtils.encodeQueryParameter((String)JsonUtils.serializeToJSON(partitions)));
        }
        return this.baseUrl + "metrics/code/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + "/" + UrlUtils.encodePathSegment((String)uniformPath) + String.valueOf(queryParameters);
    }

    public String createMergeRequestTestCoverageDetailsLink(String mergeRequestId, String uniformPath, @Nullable String originPath) {
        if (originPath == null) {
            originPath = uniformPath;
        }
        Object[] parameters = new String[]{"merge-request", mergeRequestId, "path", uniformPath, "origin-path", originPath, "show-coverage", "true"};
        if (this.commit != null) {
            parameters = (String[])ArrayUtils.addAll((Object[])parameters, (Object[])new String[]{"t", CommitDescriptor.latestOnBranch(this.commit.getBranchName()).toServiceCallFormat()});
        }
        return this.baseUrl + "compare/coverage/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + ServiceClientUris.createOptionString((String[])parameters);
    }

    public String createLinkToFile(String uniformPath, LineBasedRegion lineBasedRegion) {
        return this.createLinkToFile(uniformPath, lineBasedRegion.getStart() + "-" + lineBasedRegion.getEnd());
    }

    private String createLinkToFile(String uniformPath, String selection) {
        String optionString = this.commit == null ? ServiceClientUris.createOptionString("selection", selection) : ServiceClientUris.createOptionString("t", this.commit.toString(), "selection", selection);
        return this.baseUrl + "metrics/code/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + "/" + UrlUtils.encodePathSegment((String)uniformPath) + optionString;
    }

    private String createCommitOptionString() {
        return TeamscaleCommitLinkProvider.createCommitOptionString(this.commit);
    }

    private static String createCommitOptionString(UnresolvedCommitDescriptor commit) {
        if (commit == null) {
            return "";
        }
        return ServiceClientUris.createOptionString("t", commit.toString());
    }

    private String createFindingIdOptionString(String findingId) {
        if (this.commit == null) {
            return ServiceClientUris.createOptionString("id", findingId);
        }
        return ServiceClientUris.createOptionString("id", findingId, "t", CommitDescriptor.latestOnBranch(this.commit.getBranchName()).toServiceCallFormat());
    }
}

