/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.conqat.lib.commons.collections.CompactLines;

public class CompactLinesSerializationModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    CompactLinesSerializationModule() {
        this.addSerializer(CompactLines.class, new CompactLinesSerializer());
        this.addDeserializer(CompactLines.class, new CompactLinesDeserializer());
    }

    private static class CompactLinesSerializer
    extends JsonSerializer<CompactLines> {
        private CompactLinesSerializer() {
        }

        public void serialize(CompactLines value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (Integer line : value) {
                gen.writeNumber(line.intValue());
            }
            gen.writeEndArray();
        }
    }

    private static class CompactLinesDeserializer
    extends JsonDeserializer<CompactLines> {
        private CompactLinesDeserializer() {
        }

        public CompactLines deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (!p.isExpectedStartArrayToken()) {
                throw new JsonParseException(p, "Expected start of array");
            }
            CompactLines lines = new CompactLines();
            while (p.nextToken() != JsonToken.END_ARRAY) {
                lines.add(p.getIntValue());
            }
            return lines;
        }
    }
}

