/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.sourcecode.coverage.CoverageProbeBase;
import org.conqat.engine.sourcecode.coverage.DecisionProbe;
import org.conqat.engine.sourcecode.coverage.SimpleStatementCoverageProbe;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ProbeCoverageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PROBES_PROPERTY = "probes";
    private static final String UPLOADED_PROPERTY = "uploaded";
    @JsonProperty(value="probes")
    @Schema(implementation=Probes.class)
    private final ArrayList<CoverageProbeBase> probes;
    @JsonProperty(value="uploaded")
    private final boolean uploaded;

    public ProbeCoverageInfo(boolean uploaded) {
        this.probes = new ArrayList();
        this.uploaded = uploaded;
    }

    @JsonCreator
    public ProbeCoverageInfo(@JsonProperty(value="uploaded") boolean uploaded, @JsonProperty(value="probes") Collection<CoverageProbeBase> probes) {
        this(uploaded);
        this.probes.addAll(probes);
    }

    public ProbeCoverageInfo(ProbeCoverageInfo coverageProbeInfo) {
        this.probes = new ArrayList<CoverageProbeBase>(coverageProbeInfo.probes);
        this.uploaded = coverageProbeInfo.uploaded;
    }

    public void addProbe(CoverageProbeBase probe) {
        this.probes.add(probe);
    }

    public UnmodifiableList<CoverageProbeBase> getProbes() {
        return CollectionUtils.asUnmodifiable(this.probes);
    }

    public void setProbes(List<CoverageProbeBase> probes) {
        this.probes.clear();
        this.probes.addAll(probes);
    }

    public boolean isUploaded() {
        return this.uploaded;
    }

    public int getCoverableCount() {
        int coverableCount = 0;
        for (CoverageProbeBase probe : this.probes) {
            coverableCount += probe.getCoverableCount();
        }
        return coverableCount;
    }

    public int getCoveredCount() {
        int coveredCount = 0;
        for (CoverageProbeBase probe : this.probes) {
            coveredCount += probe.getCoveredCount();
        }
        return coveredCount;
    }

    public boolean mergeWith(ProbeCoverageInfo otherCoverage) {
        if (otherCoverage.probes.isEmpty()) {
            return true;
        }
        if (this.probes.isEmpty()) {
            this.probes.addAll(otherCoverage.probes);
            return true;
        }
        return ProbeCoverageInfo.mergeProbes(otherCoverage.probes, this.probes);
    }

    private static boolean mergeProbes(Collection<CoverageProbeBase> sourceProbes, Collection<CoverageProbeBase> targetProbes) {
        Map<Integer, List<CoverageProbeBase>> targetProbesByLine = targetProbes.stream().collect(Collectors.groupingBy(CoverageProbeBase::getLine));
        boolean safe = true;
        for (CoverageProbeBase sourceProbe : sourceProbes) {
            List<CoverageProbeBase> targetProbeCandidates;
            Optional<CoverageProbeBase> matchedProbe = ProbeCoverageInfo.findFirstMatchingProbe(sourceProbe, targetProbeCandidates = targetProbesByLine.get(sourceProbe.getLine()));
            if (matchedProbe.isPresent()) {
                safe = matchedProbe.get().mergeWith(sourceProbe) && safe;
                continue;
            }
            targetProbes.add(sourceProbe);
        }
        return safe;
    }

    private static Optional<CoverageProbeBase> findFirstMatchingProbe(CoverageProbeBase sourceProbe, List<CoverageProbeBase> targetCandidates) {
        if (targetCandidates == null) {
            return Optional.empty();
        }
        return targetCandidates.stream().filter(targetProbe -> targetProbe.getClass() == sourceProbe.getClass()).findFirst();
    }

    @ArraySchema(schema=@Schema(implementation=Probe.class))
    public static interface Probes
    extends List<Probe> {
    }

    @Schema(oneOf={DecisionProbe.class, SimpleStatementCoverageProbe.class})
    public static interface Probe {
    }
}

