/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2005")
public class ConcatenatedStringLiteralCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2005";
    private static final String MESSAGE = "Combine these strings instead of concatenating them.";
    private static final Tree.Kind[] STRING_KINDS = new Tree.Kind[]{Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.EXPANDABLE_STRING_LITERAL};

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        List<ExpressionTree> arguments = ConcatenatedStringLiteralCheck.getFlatConcatenationArguments(tree);
        for (int i = 0; i < arguments.size() - 1; ++i) {
            if (!arguments.get(i).is(STRING_KINDS) || !arguments.get(i + 1).is(STRING_KINDS)) continue;
            this.context().newIssue(this, arguments.get(i), MESSAGE).secondary(arguments.get(i + 1), null);
            return;
        }
        if (arguments.isEmpty()) {
            super.visitBinaryExpression(tree);
        }
    }

    private static List<ExpressionTree> getFlatConcatenationArguments(BinaryExpressionTree tree) {
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        ExpressionTree currentExpression = tree;
        while (currentExpression.is(Tree.Kind.CONCATENATION)) {
            arguments.add(currentExpression.rightOperand());
            currentExpression = currentExpression.leftOperand();
        }
        if (currentExpression.is(STRING_KINDS)) {
            arguments.add(currentExpression);
        }
        Collections.reverse(arguments);
        return arguments;
    }
}

